/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.block;

import com.chefmooon.breezebounce.common.block.SimpleBreezeBounceBlock;
import com.chefmooon.breezebounce.common.registry.ModParticleTypes;
import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class BreezeBounceSlabBlock
extends SlabBlock
implements SimpleBreezeBounceBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BreezeBounceSlabBlock> CODEC = BreezeBounceSlabBlock.simpleCodec(BreezeBounceSlabBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<? extends BreezeBounceSlabBlock> codec() {
        return CODEC;
    }

    public BreezeBounceSlabBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SimpleBreezeBounceBlock.bounceSoundType()));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)MACHINE_POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED, MACHINE_POWERED});
    }

    public void fallOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
        if (entity.isSuppressingBounce()) {
            if ((double)f > 2.4) {
                this.tryDoubleBounceSpread(level, blockState, blockPos);
            }
        } else {
            entity.causeFallDamage(f, 0.0f, level.damageSources().fall());
        }
    }

    public void updateEntityMovementAfterFallOn(BlockGetter blockGetter, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(blockGetter, entity);
        } else {
            BlockPos blockPos = entity.getBlockPosBelowThatAffectsMyMovement().above();
            if (blockGetter.getBlockState(blockPos).getBlock() instanceof BreezeBounceSlabBlock) {
                if (blockGetter.getBlockState(blockPos).getValue((Property)TYPE) == SlabType.BOTTOM) {
                    this.bounceUp(entity, (Boolean)blockGetter.getBlockState(blockPos).getValue((Property)POWERED), 1.0);
                }
            } else if (blockGetter.getBlockState(blockPos.below()).getBlock() instanceof BreezeBounceSlabBlock && blockGetter.getBlockState(blockPos.below()).getValue((Property)TYPE) != SlabType.BOTTOM) {
                this.bounceUp(entity, (Boolean)blockGetter.getBlockState(blockPos.below()).getValue((Property)POWERED), 1.0);
            }
        }
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (level instanceof LevelAccessor) {
            LevelAccessor levelAccessor = (LevelAccessor)level;
            this.checkMachinePower(levelAccessor, (Block)this, pos, state, neighborState);
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public float getJumpFactor() {
        return this.jumpFactor + 0.5f;
    }

    protected void onExplosionHit(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Explosion explosion, BiConsumer<ItemStack, BlockPos> biConsumer) {
        if (explosion.canTriggerBlocks() && !((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.inflate((Block)this, blockState, (Level)serverLevel, blockPos, null);
        }
        super.onExplosionHit(blockState, serverLevel, blockPos, explosion, biConsumer);
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue() && !((Boolean)blockState.getValue((Property)MACHINE_POWERED)).booleanValue()) {
            this.checkPower((Block)this, blockState, (Level)serverLevel, blockPos);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.spawnParticles(level, blockPos);
        }
    }

    @Override
    public void spawnParticles(Level level, BlockPos blockPos) {
        double d = 0.5625;
        RandomSource randomSource = level.random;
        Direction[] directions = Direction.values();
        SlabType slabType = (SlabType)level.getBlockState(blockPos).getValue((Property)TYPE);
        for (Direction direction : directions) {
            BlockPos blockPos2 = blockPos.relative(direction);
            if (level.getBlockState(blockPos2).isSolidRender()) continue;
            Direction.Axis axis = direction.getAxis();
            double e = axis == Direction.Axis.X ? 0.5 + d * (double)direction.getStepX() : (double)randomSource.nextFloat();
            double f = switch (slabType) {
                case SlabType.BOTTOM -> d * (double)randomSource.nextFloat();
                case SlabType.TOP -> 0.48 + d * (double)randomSource.nextFloat();
                default -> axis == Direction.Axis.Y ? 0.5 + d * (double)direction.getStepY() : (double)randomSource.nextFloat();
            };
            double g = axis == Direction.Axis.Z ? 0.5 + d * (double)direction.getStepZ() : (double)randomSource.nextFloat();
            level.addParticle((ParticleOptions)ModParticleTypes.BOUNCE_WHITE.get(), (double)blockPos.getX() + e, (double)blockPos.getY() + f, (double)blockPos.getZ() + g, 0.0, 0.0, 0.0);
        }
    }
}

