/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.block;

import com.chefmooon.breezebounce.common.registry.ModSounds;
import com.chefmooon.breezebounce.common.util.ValidConnectionUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface SimpleBreezeBounceBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty MACHINE_POWERED = BooleanProperty.create((String)"machine_powered");
    public static final int ticksToStayPowered = 80;
    public static final double TERMINAL_VELOCITY = 1.0;
    public static final int FLAMMABILITY = 30;
    public static final int FIRE_SPREAD = 60;
    public static final int DOUBLE_JUMP_SPREAD = 1;
    public static final double DOUBLE_BOUNCE_ACTIVATION_THRESHOLD = 2.4;

    default public void spawnParticles(Level level, BlockPos blockPos) {
    }

    default public void updateEntityAfterSideCollision(Level level, BlockState blockState, BlockPos blockPos, Entity entity, Vec3 vec3) {
        boolean powered = (Boolean)blockState.getValue((Property)POWERED);
        if (!entity.isSuppressingBounce()) {
            this.bounceHorizontal(level, blockPos, entity, vec3, powered, 1.0);
        }
    }

    default public void updateEntityAfterFlyUp(Level level, BlockState blockState, BlockPos blockPos, Entity entity, Vec3 vec3) {
        double VALID_HEAD_BOUNCE_THRESHOLD = 0.082;
        boolean powered = (Boolean)blockState.getValue((Property)POWERED);
        if (vec3.y > VALID_HEAD_BOUNCE_THRESHOLD) {
            if (!entity.isSuppressingBounce()) {
                this.bounceDown(entity, powered, vec3, 1.0);
            }
            this.playBounceSound(entity, (LevelAccessor)level, blockPos, (float)vec3.y);
        }
    }

    default public void bounceUp(Entity entity, Boolean powered, double terminalVelocity) {
        double VERTICAL_TERMINAL_VELOCITY = terminalVelocity * 1.2;
        Vec3 vec3 = entity.getDeltaMovement();
        if (vec3.y < 0.0) {
            double d;
            double d2 = d = entity instanceof LivingEntity ? 1.0 : 0.8;
            if (powered.booleanValue()) {
                d *= 1.5;
            }
            if (powered.booleanValue()) {
                VERTICAL_TERMINAL_VELOCITY *= 1.1;
            }
            if (Math.abs(vec3.y * d) < VERTICAL_TERMINAL_VELOCITY) {
                entity.setDeltaMovement(vec3.x, -vec3.y * d, vec3.z);
            } else {
                entity.setDeltaMovement(vec3.x, VERTICAL_TERMINAL_VELOCITY, vec3.z);
            }
            if (vec3.y < -0.08) {
                this.playBounceSound(entity, (float)vec3.y);
            }
        }
    }

    default public void bounceDown(Entity entity, Boolean powered, Vec3 vec3, double terminalVelocity) {
        double d;
        double VERTICAL_TERMINAL_VELOCITY = terminalVelocity;
        double d2 = d = entity instanceof LivingEntity ? 1.5 : 0.8;
        if (powered.booleanValue()) {
            d *= 2.0;
        }
        if (powered.booleanValue()) {
            VERTICAL_TERMINAL_VELOCITY *= 1.2;
        }
        if (Math.abs(vec3.y * d) < VERTICAL_TERMINAL_VELOCITY) {
            if (vec3.y < 0.01) {
                d *= 100.0;
            }
            entity.setDeltaMovement(vec3.x, -vec3.y * d, vec3.z);
        } else {
            entity.setDeltaMovement(vec3.x, -VERTICAL_TERMINAL_VELOCITY, vec3.z);
        }
    }

    default public void bounceHorizontal(Level level, BlockPos blockPos, Entity entity, Vec3 vec3, Boolean powered, double terminalVelocity) {
        double d;
        double HORIZONTAL_TERMINAL_VELOCITY = terminalVelocity;
        double VALID_BOUNCE_THRESHOLD = 0.1;
        double d2 = d = entity instanceof LivingEntity ? 1.5 : 0.8;
        if (powered.booleanValue()) {
            d *= 2.0;
        }
        if (powered.booleanValue()) {
            HORIZONTAL_TERMINAL_VELOCITY *= 2.0;
        }
        Vec3 reverseVector = this.getBounceDirection(vec3);
        if (Math.abs(vec3.z) > VALID_BOUNCE_THRESHOLD || Math.abs(vec3.x) > VALID_BOUNCE_THRESHOLD) {
            if (Math.abs(vec3.z * d) < HORIZONTAL_TERMINAL_VELOCITY && Math.abs(vec3.x * d) < HORIZONTAL_TERMINAL_VELOCITY) {
                entity.setDeltaMovement(reverseVector.x * d, reverseVector.y, reverseVector.z * d);
            } else {
                entity.setDeltaMovement(reverseVector.x, reverseVector.y, reverseVector.z);
            }
            this.playBounceSound(entity, (LevelAccessor)level, blockPos, (float)reverseVector.length());
        }
    }

    default public void inflate(Block block, BlockState blockState, Level level, BlockPos blockPos, @Nullable Player player) {
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        level.updateNeighborsAt(blockPos, block);
        level.scheduleTick(blockPos, block, this.getPoweredTime());
        this.playSound(null, (LevelAccessor)level, blockPos, true);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, blockPos);
    }

    default public void machineInflate(Block block, BlockState blockState, Level level, BlockPos blockPos, @Nullable Player player) {
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        level.updateNeighborsAt(blockPos, block);
        level.scheduleTick(blockPos, block, 5);
        this.playSound(null, (LevelAccessor)level, blockPos, true);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, blockPos);
    }

    default public void machineSilentInflate(Block block, BlockState blockState, Level level, BlockPos blockPos, @Nullable Player player) {
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        level.updateNeighborsAt(blockPos, block);
        level.scheduleTick(blockPos, block, 5);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, blockPos);
    }

    default public void machineInflation(Block block, BlockState blockState, Level level, BlockPos blockPos, @Nullable Player player) {
        if (!level.getBlockTicks().hasScheduledTick(blockPos, (Object)block)) {
            if (!((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
                this.machineInflate(block, blockState, level, blockPos, player);
            } else {
                this.machineSilentInflate(block, blockState, level, blockPos, player);
            }
        }
    }

    default public int getPoweredTime() {
        return 80;
    }

    default public void checkPower(Block block, BlockState blockState, Level level, BlockPos blockPos) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            level.updateNeighborsAt(blockPos, block);
            this.playSound(null, (LevelAccessor)level, blockPos, false);
            level.gameEvent((Entity)((Player)null), (Holder)GameEvent.BLOCK_DEACTIVATE, blockPos);
        }
    }

    default public void checkMachinePower(LevelAccessor level, Block block, BlockPos pos, BlockState state, BlockState neighborState) {
        if (block instanceof SimpleBreezeBounceBlock && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (neighborState.is(Blocks.MOVING_PISTON) || neighborState.is(Blocks.PISTON_HEAD)) {
                this.deflate(block, state, level, pos);
            } else if (neighborState.getBlock() instanceof SimpleBreezeBounceBlock && !((Boolean)neighborState.getValue((Property)MACHINE_POWERED)).booleanValue() && !level.getBlockTicks().hasScheduledTick(pos, (Object)block)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MACHINE_POWERED, (Comparable)Boolean.valueOf(false)), 3);
                level.scheduleTick(pos, block, 5);
            }
        }
    }

    default public void deflate(Block block, BlockState blockState, LevelAccessor level, BlockPos blockPos) {
        level.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)MACHINE_POWERED, (Comparable)Boolean.valueOf(false)), 3);
        level.blockUpdated(blockPos, block);
        this.playSound(null, level, blockPos, false);
        level.gameEvent((Entity)((Player)null), (Holder)GameEvent.BLOCK_DEACTIVATE, blockPos);
    }

    default public Vec3 getBounceDirection(Vec3 vec3) {
        double VALID_BOUNCE_THRESHOLD = 0.1;
        double x = vec3.x;
        double z = vec3.z;
        Vec3 bounceVector = vec3;
        Pair<Direction, Float> xVector = this.getDirectionVector(x, Direction.WEST, Direction.EAST, VALID_BOUNCE_THRESHOLD);
        Pair<Direction, Float> zVector = this.getDirectionVector(z, Direction.NORTH, Direction.SOUTH, VALID_BOUNCE_THRESHOLD);
        Pair<Direction, Float> majorVector = Math.abs(((Float)xVector.getSecond()).floatValue()) > Math.abs(((Float)zVector.getSecond()).floatValue()) ? xVector : zVector;
        Direction majorDirection = (Direction)majorVector.getFirst();
        if (majorDirection == Direction.NORTH || majorDirection == Direction.SOUTH) {
            bounceVector = new Vec3(bounceVector.x, bounceVector.y, -bounceVector.z);
        } else if (majorDirection == Direction.EAST || majorDirection == Direction.WEST) {
            bounceVector = new Vec3(-bounceVector.x, bounceVector.y, bounceVector.z);
        }
        return bounceVector;
    }

    default public Pair<Direction, Float> getDirectionVector(double d, Direction positiveDirection, Direction negativeDirection, double threshold) {
        if (d > threshold) {
            return Pair.of((Object)positiveDirection, (Object)Float.valueOf((float)d));
        }
        if (d < -threshold) {
            return Pair.of((Object)negativeDirection, (Object)Float.valueOf((float)d));
        }
        return Pair.of((Object)Direction.UP, (Object)Float.valueOf(0.0f));
    }

    default public void playBounceSound(Entity entity, float y) {
        if (entity instanceof Player) {
            entity.playSound(this.getBounceSound(), this.getVolume(y), this.getPitch(y));
        }
    }

    default public void playBounceSound(Entity entity, LevelAccessor levelAccessor, BlockPos blockPos, float y) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            levelAccessor.playSound(player, blockPos, this.getBounceSound(), SoundSource.BLOCKS, this.getVolume(y), this.getPitch(y));
        } else {
            levelAccessor.playSound((Player)null, blockPos, this.getBounceSound(), SoundSource.BLOCKS);
        }
    }

    default public void playSound(@Nullable Player player, LevelAccessor levelAccessor, BlockPos blockPos, boolean bl) {
        levelAccessor.playSound((Player)(bl ? player : null), blockPos, this.getSound(bl), SoundSource.BLOCKS);
    }

    default public float getVolume(float y) {
        return Math.clamp(0.6f + Math.abs(y) * 0.3f, 0.6f, 1.2f);
    }

    default public float getPitch(float y) {
        return Math.clamp(0.2f + Math.abs(y) * 0.4f, 0.2f, 1.1f);
    }

    default public SoundEvent getBounceSound() {
        return ModSounds.BOUNCE_BLOCK_BOUNCE.get();
    }

    default public SoundEvent getSound(boolean bl) {
        return bl ? ModSounds.BOUNCE_BLOCK_INFLATE.get() : ModSounds.BOUNCE_BLOCK_DEFLATE.get();
    }

    default public void tryDoubleBounceSpread(Level level, BlockState blockState, BlockPos blockPos) {
        if (blockState.getBlock() instanceof SimpleBreezeBounceBlock && !((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            level.playSound(null, blockPos, ModSounds.BOUNCE_BLOCK_DOUBLE_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, 0.6f);
            Set<BlockPos> blocks = ValidConnectionUtil.findDoubleJumpBlocks(level, blockPos, 1);
            for (BlockPos pos : blocks) {
                BlockState doubleJumpBlockState = level.getBlockState(pos);
                Block block = doubleJumpBlockState.getBlock();
                if (!(block instanceof SimpleBreezeBounceBlock) || ((Boolean)doubleJumpBlockState.getValue((Property)POWERED)).booleanValue()) continue;
                this.inflate(block, doubleJumpBlockState, level, pos, null);
            }
        }
    }

    public static SoundType bounceSoundType() {
        return new SoundType(1.0f, 1.0f, SoundEvents.WOOL_BREAK, ModSounds.BOUNCE_BLOCK_STEP.get(), SoundEvents.WOOL_PLACE, ModSounds.BOUNCE_BLOCK_BOUNCE.get(), SoundEvents.EMPTY);
    }
}

