/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.block.entity;

import com.chefmooon.breezebounce.common.block.InflationMachineBlock;
import com.chefmooon.breezebounce.common.block.SimpleBreezeBounceBlock;
import com.chefmooon.breezebounce.common.registry.ModSounds;
import com.chefmooon.breezebounce.common.util.TextUtil;
import com.chefmooon.breezebounce.common.util.ValidConnectionUtil;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InflationMachineBlockEntity
extends BlockEntity
implements WorldlyContainer,
Nameable {
    protected LockCode lockKey;
    @Nullable
    protected Component name;
    protected static final MutableComponent DISPLAY_NAME = TextUtil.getTranslatable("container.inflation_machine", new Object[0]);
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    int inflateTime;
    int inflateDuration;
    @Nullable
    private static volatile Map<Item, Integer> fuelCache;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int i) {
            switch (i) {
                case 0: {
                    return InflationMachineBlockEntity.this.inflateTime;
                }
                case 1: {
                    return InflationMachineBlockEntity.this.inflateDuration;
                }
            }
            return 0;
        }

        public void set(int i, int j) {
            switch (i) {
                case 0: {
                    InflationMachineBlockEntity.this.inflateTime = j;
                    break;
                }
                case 1: {
                    InflationMachineBlockEntity.this.inflateDuration = j;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    int soundCooldownTime = -1;
    private static final int SOUND_COOLDOWN = 40;
    private static final int RADIUS = 5;
    private static final int HEIGHT = 1;
    private Set<BlockPos> previousBlocks = new HashSet<BlockPos>();

    public InflationMachineBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.lockKey = LockCode.NO_LOCK;
    }

    public static Map<Item, Integer> getFuel() {
        Map<Item, Integer> map = fuelCache;
        if (map != null) {
            return map;
        }
        LinkedHashMap map2 = Maps.newLinkedHashMap();
        InflationMachineBlockEntity.add(map2, (ItemLike)Items.WIND_CHARGE, 240);
        InflationMachineBlockEntity.add(map2, (ItemLike)Items.BREEZE_ROD, 1200);
        fuelCache = map2;
        return map2;
    }

    private static void add(Map<Item, Integer> map, ItemLike itemLike, int i) {
        Item item = itemLike.asItem();
        map.put(item, i);
    }

    public static boolean isFuel(ItemStack itemStack) {
        return InflationMachineBlockEntity.getFuel().containsKey(itemStack.getItem());
    }

    private boolean isInflate() {
        return this.inflateTime > 0;
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.lockKey = LockCode.fromTag((CompoundTag)compoundTag, (HolderLookup.Provider)provider);
        if (compoundTag.contains("CustomName", 8)) {
            this.name = InflationMachineBlockEntity.parseCustomNameSafe((String)compoundTag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        this.inflateTime = compoundTag.getShort("InflateTime");
        this.inflateDuration = this.getInflateDuration((ItemStack)this.items.get(0));
        this.soundCooldownTime = compoundTag.getShort("SoundCooldownTime");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.lockKey.addToTag(compoundTag, provider);
        if (this.name != null) {
            compoundTag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        compoundTag.putShort("InflateTime", (short)this.inflateTime);
        compoundTag.putShort("InflateDuration", (short)this.inflateDuration);
        compoundTag.putShort("SoundCooldownTime", (short)this.soundCooldownTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomAndMetadata(provider);
    }

    protected int getInflateDuration(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return 0;
        }
        Item item = itemStack.getItem();
        return InflationMachineBlockEntity.getFuel().getOrDefault(item, 0);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, InflationMachineBlockEntity inflationMachineBlockEntity) {
        boolean isInflate = inflationMachineBlockEntity.isInflate();
        if (((Boolean)blockState.getValue((Property)InflationMachineBlock.ENABLED)).booleanValue()) {
            ItemStack itemStack;
            boolean hasFuel;
            boolean progress = false;
            if (isInflate && !((Boolean)blockState.getValue((Property)InflationMachineBlock.INFLATE)).booleanValue()) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)InflationMachineBlock.INFLATE, (Comparable)Boolean.valueOf(true)), 3);
                InflationMachineBlockEntity.playStartupSound(level, blockPos, inflationMachineBlockEntity);
            }
            if (inflationMachineBlockEntity.isInflate()) {
                InflationMachineBlockEntity.inflateConnectedBlocks(level, blockPos, blockState, inflationMachineBlockEntity);
                InflationMachineBlockEntity.tryPlayInflateSound(level, blockPos, inflationMachineBlockEntity);
                --inflationMachineBlockEntity.inflateTime;
            }
            boolean bl = hasFuel = !(itemStack = (ItemStack)inflationMachineBlockEntity.items.get(0)).isEmpty();
            if ((inflationMachineBlockEntity.isInflate() || hasFuel) && !inflationMachineBlockEntity.isInflate()) {
                inflationMachineBlockEntity.inflateDuration = inflationMachineBlockEntity.inflateTime = inflationMachineBlockEntity.getInflateDuration(itemStack);
                if (inflationMachineBlockEntity.isInflate()) {
                    progress = true;
                    itemStack.shrink(1);
                }
            }
            if (!isInflate && inflationMachineBlockEntity.isInflate()) {
                InflationMachineBlockEntity.playStartupSound(level, blockPos, inflationMachineBlockEntity);
            }
            if (isInflate != inflationMachineBlockEntity.isInflate()) {
                progress = true;
                blockState = (BlockState)blockState.setValue((Property)InflationMachineBlock.INFLATE, (Comparable)Boolean.valueOf(inflationMachineBlockEntity.isInflate()));
                level.setBlock(blockPos, blockState, 3);
            }
            if (progress) {
                InflationMachineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        } else if (inflationMachineBlockEntity.isInflate()) {
            blockState = (BlockState)blockState.setValue((Property)InflationMachineBlock.INFLATE, (Comparable)Boolean.valueOf(false));
            level.setBlock(blockPos, blockState, 3);
        }
    }

    public static void playStartupSound(Level level, BlockPos blockPos, InflationMachineBlockEntity inflationMachineBlockEntity) {
        level.playSound(null, blockPos, ModSounds.BLOCK_INFLATION_MACHINE_STARTUP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        inflationMachineBlockEntity.setSoundCooldownTime(40);
    }

    public static void playShutdownSound(Level level, BlockPos blockPos) {
        level.playSound(null, blockPos, ModSounds.BLOCK_INFLATION_MACHINE_SHUTDOWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void tryPlayInflateSound(Level level, BlockPos blockPos, InflationMachineBlockEntity inflationMachineBlockEntity) {
        if (inflationMachineBlockEntity.soundCooldownTime > -1) {
            --inflationMachineBlockEntity.soundCooldownTime;
        }
        if (!inflationMachineBlockEntity.isOnSoundCooldown() && (double)level.getRandom().nextFloat() < 0.01) {
            float pitchVariance = 0.9f + level.getRandom().nextFloat() * 0.2f;
            level.playSound(null, blockPos, ModSounds.BLOCK_INFLATION_MACHINE_INFLATE.get(), SoundSource.BLOCKS, 1.0f, pitchVariance);
            inflationMachineBlockEntity.setSoundCooldownTime(40);
        }
    }

    private static void inflateConnectedBlocks(Level level, BlockPos blockPos, BlockState blockState, InflationMachineBlockEntity inflationMachineBlockEntity) {
        Set<BlockPos> connectedBlocks = ValidConnectionUtil.findConnectedBlocks(level, blockPos, (Direction.Axis)blockState.getValue(InflationMachineBlock.AXIS), 1, 5);
        if (inflationMachineBlockEntity.inflateTime > 1) {
            inflationMachineBlockEntity.inflateBlocks(connectedBlocks, level);
        } else if (inflationMachineBlockEntity.isEmpty()) {
            InflationMachineBlockEntity.removeMachinePowerTick(connectedBlocks, level);
            InflationMachineBlockEntity.playShutdownSound(level, blockPos);
        }
    }

    public void inflateBlocks(Set<BlockPos> blocks, Level level) {
        for (BlockPos pos : blocks) {
            BlockState blockState = level.getBlockState(pos);
            Block block = blockState.getBlock();
            if (!(block instanceof SimpleBreezeBounceBlock)) continue;
            SimpleBreezeBounceBlock simpleBreezeBounceBlock = (SimpleBreezeBounceBlock)block;
            if (!((Boolean)blockState.getValue((Property)SimpleBreezeBounceBlock.MACHINE_POWERED)).booleanValue()) {
                blockState = (BlockState)blockState.setValue((Property)SimpleBreezeBounceBlock.MACHINE_POWERED, (Comparable)Boolean.valueOf(true));
            }
            simpleBreezeBounceBlock.machineInflation(block, blockState, level, pos, null);
        }
        HashSet<BlockPos> blocksToDeflate = new HashSet<BlockPos>(this.previousBlocks);
        blocksToDeflate.removeAll(blocks);
        if (!blocksToDeflate.isEmpty()) {
            for (BlockPos pos : blocksToDeflate) {
                BlockState blockState = level.getBlockState(pos);
                if (!(blockState.getBlock() instanceof SimpleBreezeBounceBlock)) continue;
                InflationMachineBlockEntity.removeMachinePowerDeflate(Set.of(pos), level);
            }
        }
        this.previousBlocks = new HashSet<BlockPos>(blocks);
    }

    public void onRemoveMachinePower(Level level, BlockPos blockPos, BlockState blockState) {
        Set<BlockPos> connectedBlocks = ValidConnectionUtil.findConnectedBlocks(level, blockPos, (Direction.Axis)blockState.getValue(InflationMachineBlock.AXIS), 1, 5);
        InflationMachineBlockEntity.removeMachinePowerTick(connectedBlocks, level);
    }

    private static void removeMachinePowerDeflate(Set<BlockPos> blocks, Level level) {
        for (BlockPos pos : blocks) {
            BlockState blockState = level.getBlockState(pos);
            Block block = blockState.getBlock();
            if (!(block instanceof SimpleBreezeBounceBlock)) continue;
            SimpleBreezeBounceBlock simpleBreezeBounceBlock = (SimpleBreezeBounceBlock)block;
            simpleBreezeBounceBlock.deflate(block, blockState, (LevelAccessor)level, pos);
        }
    }

    private static void removeMachinePowerTick(Set<BlockPos> blocks, Level level) {
        for (BlockPos pos : blocks) {
            BlockState blockState = level.getBlockState(pos);
            Block block = blockState.getBlock();
            if (!(block instanceof SimpleBreezeBounceBlock)) continue;
            level.setBlock(pos, (BlockState)blockState.setValue((Property)SimpleBreezeBounceBlock.MACHINE_POWERED, (Comparable)Boolean.valueOf(false)), 3);
            if (level.getBlockTicks().hasScheduledTick(pos, (Object)block)) continue;
            level.scheduleTick(pos, block, 1);
        }
    }

    private void setSoundCooldownTime(int soundCooldownTime) {
        this.soundCooldownTime = soundCooldownTime;
    }

    private boolean isOnSoundCooldown() {
        return this.soundCooldownTime > 0;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return ((ItemStack)this.items.getFirst()).isEmpty();
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.getItems().clear();
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    protected Component getDefaultName() {
        return DISPLAY_NAME;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public boolean canOpen(Player player) {
        return InflationMachineBlockEntity.canUnlock(player, this.lockKey, this.getDisplayName());
    }

    public static boolean canUnlock(Player player, LockCode code, Component displayName) {
        if (!player.isSpectator() && !code.unlocksWith(player.getMainHandItem())) {
            player.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{displayName}), true);
            player.playNotifySound(SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
        this.lockKey = (LockCode)componentInput.getOrDefault(DataComponents.LOCK, (Object)LockCode.NO_LOCK);
        ((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        if (!this.lockKey.equals((Object)LockCode.NO_LOCK)) {
            components.set(DataComponents.LOCK, (Object)this.lockKey);
        }
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
        tag.remove("Lock");
        tag.remove("Items");
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return InflationMachineBlockEntity.isFuel(itemStack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }
}

