/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.block.entity.container;

import com.chefmooon.breezebounce.common.block.entity.InflationMachineBlockEntity;
import com.chefmooon.breezebounce.common.registry.ModMenuTypes;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;

public class InflationMachineMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;

    public InflationMachineMenu(int i, Inventory inventory, BlockPos blockPos) {
        this(i, inventory, (Container)InflationMachineMenu.getBlockEntity(inventory, blockPos), (ContainerData)new SimpleContainerData(4));
    }

    public InflationMachineMenu(int i, Inventory inventory) {
        this(i, inventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(4));
    }

    public InflationMachineMenu(int i, Inventory inventory, Container container, ContainerData containerData) {
        super((MenuType)((Holder.Reference)BuiltInRegistries.MENU.get(ModMenuTypes.INFLATION_MACHINE).orElseThrow()).value(), i);
        int l;
        InflationMachineMenu.checkContainerSize((Container)container, (int)1);
        InflationMachineMenu.checkContainerDataCount((ContainerData)containerData, (int)2);
        this.container = container;
        this.data = containerData;
        this.addSlot(new InflationMachineFuelSlot(this, container, 0, 80, 45));
        for (l = 0; l < 3; ++l) {
            for (int m = 0; m < 9; ++m) {
                this.addSlot(new Slot((Container)inventory, m + l * 9 + 9, 8 + m * 18, 84 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)inventory, l, 8 + l * 18, 142));
        }
        this.addDataSlots(containerData);
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (i == 0) {
                if (!this.moveItemStackTo(slotStack, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (this.isFuel(slotStack)) {
                if (!this.moveItemStackTo(slotStack, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (i >= 1 && i < 28) {
                if (!this.moveItemStackTo(slotStack, 28, 37, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (i >= 28 && i < 37 && !this.moveItemStackTo(slotStack, 1, 28, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(slotStack, 1, 37, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    protected boolean isFuel(ItemStack itemStack) {
        return InflationMachineBlockEntity.isFuel(itemStack);
    }

    private static InflationMachineBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof InflationMachineBlockEntity) {
            return (InflationMachineBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    private static InflationMachineBlockEntity getBlockEntity(Inventory inventory, BlockPos blockPos) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(blockPos, "data cannot be null");
        BlockEntity blockEntity = inventory.player.level().getBlockEntity(blockPos);
        if (blockEntity instanceof InflationMachineBlockEntity) {
            InflationMachineBlockEntity inflationMachineBlockEntity = (InflationMachineBlockEntity)blockEntity;
            return inflationMachineBlockEntity;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(blockEntity));
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public float getInflateProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isInflate() {
        return this.data.get(0) > 0;
    }

    class InflationMachineFuelSlot
    extends Slot {
        public InflationMachineFuelSlot(InflationMachineMenu this$0, Container container, int i, int j, int k) {
            super(container, i, j, k);
        }

        public boolean mayPlace(ItemStack itemStack) {
            return itemStack.is(Items.WIND_CHARGE) || itemStack.is(Items.BREEZE_ROD);
        }
    }
}

