/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.mixin;

import com.chefmooon.breezebounce.common.block.SimpleBreezeBounceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"jumpFromGround()V"}, at={@At(value="TAIL")})
    public void breezeBounceJump(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            BlockPos blockPos;
            Player player = (Player)livingEntity;
            Level level = livingEntity.level();
            Block block = level.getBlockState(blockPos = player.getOnPos()).getBlock();
            if (block instanceof SimpleBreezeBounceBlock) {
                SimpleBreezeBounceBlock simpleBreezeBounceBlock = (SimpleBreezeBounceBlock)block;
                level.playSound(player, blockPos, simpleBreezeBounceBlock.getBounceSound(), SoundSource.BLOCKS, 0.7f, 0.5f);
            }
        }
    }
}

