/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.util;

import com.chefmooon.breezebounce.common.block.BreezeBounceSlabBlock;
import com.chefmooon.breezebounce.common.block.BreezeBounceStairBlock;
import com.chefmooon.breezebounce.common.block.BreezeBounceWallBlock;
import com.chefmooon.breezebounce.common.block.SimpleBreezeBounceBlock;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class ValidConnectionUtil {
    public static Set<BlockPos> findDoubleJumpBlocks(Level level, BlockPos startPos, int radius) {
        return ValidConnectionUtil.findConnectedBlocks(level, startPos, Direction.Axis.Y, 0, radius);
    }

    public static Set<BlockPos> findConnectedBlocks(Level level, BlockPos startPos, Direction.Axis axis, int height, int radius) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startPos);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            if (visited.contains(current) || !ValidConnectionUtil.isWithinSquareRadius(startPos, current, axis, height, radius)) continue;
            visited.add(current);
            BlockState blockState = level.getBlockState(current);
            Block block = blockState.getBlock();
            HashSet<Direction> directions = new HashSet<Direction>();
            if (block instanceof BreezeBounceWallBlock) {
                if (blockState.getValue(BreezeBounceWallBlock.AXIS) == Direction.Axis.X) {
                    directions.addAll(Arrays.asList(Direction.EAST, Direction.WEST));
                } else if (blockState.getValue(BreezeBounceWallBlock.AXIS) == Direction.Axis.Z) {
                    directions.addAll(Arrays.asList(Direction.NORTH, Direction.SOUTH));
                } else if (blockState.getValue(BreezeBounceWallBlock.AXIS) == Direction.Axis.Y) {
                    directions.addAll(Arrays.asList(Direction.UP, Direction.DOWN));
                }
            } else if (block instanceof BreezeBounceSlabBlock) {
                directions.addAll(Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST));
                if (blockState.getValue((Property)BreezeBounceSlabBlock.TYPE) == SlabType.BOTTOM) {
                    directions.add(Direction.DOWN);
                } else if (blockState.getValue((Property)BreezeBounceSlabBlock.TYPE) == SlabType.TOP) {
                    directions.add(Direction.UP);
                } else if (blockState.getValue((Property)BreezeBounceSlabBlock.TYPE) == SlabType.DOUBLE) {
                    directions.addAll(Arrays.asList(Direction.UP, Direction.DOWN));
                }
            } else {
                directions.addAll(Arrays.asList(Direction.values()));
            }
            for (Direction direction : directions) {
                BlockPos neighbor = current.relative(direction);
                if (!ValidConnectionUtil.isValidConnection(level, blockState, neighbor, direction)) continue;
                queue.add(neighbor);
            }
        }
        return visited;
    }

    private static boolean isWithinSquareRadius(BlockPos start, BlockPos current, Direction.Axis axis, int height, int radius) {
        return Math.abs(current.getX() - start.getX()) <= (axis == Direction.Axis.X ? height : radius) && Math.abs(current.getY() - start.getY()) <= (axis == Direction.Axis.Y ? height : radius) && Math.abs(current.getZ() - start.getZ()) <= (axis == Direction.Axis.Z ? height : radius);
    }

    private static boolean isValidConnection(Level level, BlockState sourceBlockState, BlockPos pos, Direction direction) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        Block sourceBlock = sourceBlockState.getBlock();
        Block block2 = block;
        Objects.requireNonNull(block2);
        Block block3 = block2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BreezeBounceWallBlock.class, BreezeBounceSlabBlock.class, BreezeBounceStairBlock.class}, (Object)block3, n)) {
            case 0 -> {
                BreezeBounceWallBlock ignored = (BreezeBounceWallBlock)block3;
                yield ValidConnectionUtil.isValidWallConnection(direction, state);
            }
            case 1 -> {
                BreezeBounceSlabBlock ignored = (BreezeBounceSlabBlock)block3;
                yield ValidConnectionUtil.isValidSlabConnection(direction, state, sourceBlock, sourceBlockState);
            }
            case 2 -> {
                BreezeBounceStairBlock ignored = (BreezeBounceStairBlock)block3;
                yield ValidConnectionUtil.isValidStairConnection(block, sourceBlock, sourceBlockState, state, direction);
            }
            default -> block instanceof SimpleBreezeBounceBlock;
        };
    }

    private static boolean isValidWallConnection(Direction direction, BlockState blockState) {
        if (blockState.getValue(BreezeBounceWallBlock.AXIS) == Direction.Axis.Y && (direction == Direction.UP || direction == Direction.DOWN)) {
            return true;
        }
        if (blockState.getValue(BreezeBounceWallBlock.AXIS) == Direction.Axis.X && (direction == Direction.EAST || direction == Direction.WEST)) {
            return true;
        }
        return blockState.getValue(BreezeBounceWallBlock.AXIS) == Direction.Axis.Z && (direction == Direction.NORTH || direction == Direction.SOUTH);
    }

    private static boolean isValidSlabConnection(Direction direction, BlockState state, Block sourceBlock, BlockState sourceBlockState) {
        if (direction == Direction.UP || direction == Direction.DOWN) {
            if (direction == Direction.UP && state.getValue((Property)BreezeBounceSlabBlock.TYPE) != SlabType.TOP) {
                return true;
            }
            return direction == Direction.DOWN && state.getValue((Property)BreezeBounceSlabBlock.TYPE) != SlabType.BOTTOM;
        }
        if (sourceBlock instanceof BreezeBounceSlabBlock) {
            if (sourceBlockState.getValue((Property)BreezeBounceSlabBlock.TYPE) == state.getValue((Property)BreezeBounceSlabBlock.TYPE)) {
                return true;
            }
            return sourceBlockState.getValue((Property)BreezeBounceSlabBlock.TYPE) == SlabType.DOUBLE || state.getValue((Property)BreezeBounceSlabBlock.TYPE) == SlabType.DOUBLE;
        }
        if (sourceBlock instanceof BreezeBounceStairBlock) {
            SlabType type = (SlabType)state.getValue((Property)BreezeBounceSlabBlock.TYPE);
            Half half = (Half)sourceBlockState.getValue((Property)BreezeBounceStairBlock.HALF);
            if (type == SlabType.DOUBLE || type == SlabType.BOTTOM && half == Half.BOTTOM || type == SlabType.TOP && half == Half.TOP) {
                return true;
            }
            Direction sourceFacing = (Direction)sourceBlockState.getValue((Property)BreezeBounceStairBlock.FACING);
            StairsShape sourceShape = (StairsShape)sourceBlockState.getValue((Property)BreezeBounceStairBlock.SHAPE);
            if (sourceFacing == direction) {
                return true;
            }
            if (sourceFacing == direction.getClockWise()) {
                return sourceShape != StairsShape.OUTER_RIGHT;
            }
            if (sourceFacing == direction.getCounterClockWise()) {
                return sourceShape != StairsShape.OUTER_LEFT;
            }
            return sourceShape == StairsShape.INNER_LEFT || sourceShape == StairsShape.INNER_RIGHT;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidStairConnection(Block block, Block sourceBlock, BlockState sourceBlockState, BlockState state, Direction direction) {
        boolean innerConner;
        if (sourceBlock instanceof BreezeBounceSlabBlock) {
            if (sourceBlockState.getValue((Property)BreezeBounceSlabBlock.TYPE) == SlabType.DOUBLE) {
                return true;
            }
            Direction facing = (Direction)state.getValue((Property)BreezeBounceStairBlock.FACING);
            StairsShape shape = (StairsShape)state.getValue((Property)BreezeBounceStairBlock.SHAPE);
            SlabType slabType = (SlabType)sourceBlockState.getValue((Property)BreezeBounceSlabBlock.TYPE);
            Half stairHalf = (Half)state.getValue((Property)BreezeBounceStairBlock.HALF);
            if (slabType == SlabType.BOTTOM) {
                if (stairHalf == Half.BOTTOM) return true;
            }
            if (slabType == SlabType.TOP && stairHalf == Half.TOP) {
                return true;
            }
            if (facing == direction) {
                if (shape == StairsShape.INNER_LEFT) return true;
                if (shape != StairsShape.INNER_RIGHT) return false;
                return true;
            }
            if (facing == direction.getClockWise()) {
                if (shape != StairsShape.OUTER_LEFT) return block instanceof SimpleBreezeBounceBlock;
                return false;
            }
            if (facing != direction.getCounterClockWise()) return true;
            if (shape != StairsShape.OUTER_RIGHT) return block instanceof SimpleBreezeBounceBlock;
            return false;
        }
        if (!(sourceBlock instanceof BreezeBounceStairBlock)) return block instanceof SimpleBreezeBounceBlock;
        Half sourceHalf = (Half)sourceBlockState.getValue((Property)BreezeBounceStairBlock.HALF);
        Half half = (Half)state.getValue((Property)BreezeBounceStairBlock.HALF);
        Direction sourceFacing = (Direction)sourceBlockState.getValue((Property)BreezeBounceStairBlock.FACING);
        Direction facing = (Direction)state.getValue((Property)BreezeBounceStairBlock.FACING);
        StairsShape sourceShape = (StairsShape)sourceBlockState.getValue((Property)BreezeBounceStairBlock.SHAPE);
        StairsShape shape = (StairsShape)state.getValue((Property)BreezeBounceStairBlock.SHAPE);
        boolean bl = innerConner = shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT || sourceShape == StairsShape.INNER_LEFT || sourceShape == StairsShape.INNER_RIGHT;
        if (direction == Direction.DOWN) {
            if (sourceHalf == Half.BOTTOM && half == Half.TOP) {
                return true;
            }
            if (facing == sourceFacing.getOpposite()) {
                if (sourceShape == StairsShape.OUTER_RIGHT && shape != StairsShape.INNER_LEFT) {
                    return false;
                }
                if (sourceShape != StairsShape.OUTER_LEFT) return innerConner;
                if (shape == StairsShape.INNER_RIGHT) return innerConner;
                return false;
            }
            if (facing == sourceFacing.getClockWise()) {
                if (sourceShape != StairsShape.OUTER_LEFT) return true;
                if (shape != StairsShape.INNER_LEFT) return false;
                return true;
            }
            if (facing != sourceFacing.getCounterClockWise()) return block instanceof SimpleBreezeBounceBlock;
            if (sourceShape != StairsShape.OUTER_RIGHT) return true;
            if (shape != StairsShape.INNER_RIGHT) return false;
            return true;
        }
        if (direction == Direction.UP) {
            if (sourceHalf == Half.TOP && half == Half.BOTTOM) {
                return true;
            }
            if (facing == sourceFacing.getOpposite()) {
                if (sourceShape == StairsShape.INNER_LEFT && shape == StairsShape.OUTER_LEFT) {
                    return false;
                }
                if (sourceShape != StairsShape.INNER_RIGHT) return innerConner;
                if (shape != StairsShape.OUTER_RIGHT) return innerConner;
                return false;
            }
            if (facing == sourceFacing.getClockWise()) {
                if (sourceShape != StairsShape.INNER_LEFT) return true;
                if (shape != StairsShape.OUTER_LEFT) return false;
                return true;
            }
            if (facing != sourceFacing.getCounterClockWise()) return block instanceof SimpleBreezeBounceBlock;
            if (sourceShape != StairsShape.INNER_RIGHT) return true;
            if (shape != StairsShape.OUTER_RIGHT) return false;
            return true;
        }
        if (half == sourceHalf) {
            return true;
        }
        if (facing == sourceFacing.getOpposite()) {
            if (direction == sourceFacing) return true;
            if (!innerConner) return false;
            return true;
        }
        if (facing == sourceFacing.getClockWise()) {
            if (sourceShape == StairsShape.OUTER_LEFT) return false;
            if (shape != StairsShape.OUTER_RIGHT) return block instanceof SimpleBreezeBounceBlock;
            return false;
        }
        if (facing != sourceFacing.getCounterClockWise()) return true;
        if (sourceShape == StairsShape.OUTER_RIGHT) return false;
        if (shape != StairsShape.OUTER_LEFT) return block instanceof SimpleBreezeBounceBlock;
        return false;
    }
}

