/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.block;

import dev.xylonity.knightlib.KnightLib;
import dev.xylonity.knightlib.block.AbstractTickBlock;
import dev.xylonity.knightlib.compat.integration.KnightQuestIntegration;
import dev.xylonity.knightlib.compat.registry.KnightLibBlocks;
import dev.xylonity.knightlib.compat.registry.KnightLibItems;
import dev.xylonity.knightlib.compat.registry.KnightLibParticles;
import dev.xylonity.knightquest.common.item.KQWeaponItem;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChaliceBlock
extends AbstractTickBlock {
    public static final IntegerProperty fill = IntegerProperty.m_61631_((String)"level", (int)1, (int)10);
    private static final VoxelShape SHAPE_N = Stream.of(Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.m_49796_((double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ChaliceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE_N;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{fill});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        double particleZ;
        double particleX;
        int i;
        double initialY;
        double centerZ;
        double centerX;
        double radius;
        Block block = pLevel.m_8055_(pPos).m_60734_();
        ItemStack stack = pPlayer.m_21120_(pHand);
        Item item = stack.m_41720_();
        Item knightquestEmptyGoblet = null;
        Item knightquestFilledGoblet = null;
        Item knightquestRadiantEssence = null;
        Item knightquestChaoticEssence = null;
        if (KnightLib.isKnightQuestLoaded()) {
            knightquestEmptyGoblet = KnightQuestIntegration.getEmptyGoblet();
            knightquestFilledGoblet = KnightQuestIntegration.getFilledGoblet();
            knightquestRadiantEssence = KnightQuestIntegration.getRadiantEssence();
            knightquestChaoticEssence = KnightQuestIntegration.getChaoticEssence();
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item instanceof KQWeaponItem && ((Integer)pState.m_61143_((Property)fill)).equals(10) && !stack.m_41784_().m_128471_("Activated")) {
            if (pLevel.m_5776_()) {
                radius = 0.5;
                centerX = (double)pPos.m_123341_() + 0.5;
                centerZ = (double)pPos.m_123343_() + 0.5;
                initialY = pPos.m_123342_();
                for (i = 0; i < 720; i += 12) {
                    double angleRadians = Math.toRadians(i);
                    particleX = centerX + radius * Math.cos(angleRadians);
                    particleZ = centerZ + radius * Math.sin(angleRadians);
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123785_, particleX, initialY + 1.0, particleZ, -0.5, 0.5, 0.5);
                }
            }
            if (!pLevel.m_5776_()) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)fill, (Comparable)Integer.valueOf(1)), 3);
                stack.m_41784_().m_128379_("Activated", true);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11868_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(KnightLibItems.GREAT_ESSENCE.get()) && Arrays.asList(1, 2, 3, 4).contains(pState.m_61143_((Property)fill)) && !pLevel.m_5776_()) {
            double centerX2 = (double)pPos.m_123341_() + 0.5;
            double centerZ2 = (double)pPos.m_123343_() + 0.5;
            double initialY2 = (double)pPos.m_123342_() + 0.1;
            double particleY = initialY2 - 0.48;
            ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET_PARTICLE.get()), true, centerX2, particleY, centerZ2, 0.0f, 0.0f, 0.0f, 1.0f, 1);
            if (pLevel instanceof ServerLevel) {
                pLevel.m_7654_().m_6846_().m_11241_(null, centerX2, particleY, centerZ2, 50.0, pLevel.m_46472_(), (Packet)packet);
            }
            pLevel.m_5594_(null, pPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)fill), 3);
            if (pPlayer.m_21120_(pHand).m_41613_() > 1) {
                int count = stack.m_41613_();
                stack.m_41764_(--count);
            } else {
                pPlayer.m_21008_(pHand, new ItemStack((ItemLike)ItemStack.f_41583_.m_41720_()));
            }
            if ((Integer)pState.m_61143_((Property)fill) == 4) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(knightquestEmptyGoblet) && ((Integer)pState.m_61143_((Property)fill)).equals(5)) {
            if (pLevel.m_5776_()) {
                radius = 0.5;
                centerX = (double)pPos.m_123341_() + 0.5;
                centerZ = (double)pPos.m_123343_() + 0.5;
                initialY = pPos.m_123342_();
                for (i = 0; i < 360; i += 12) {
                    double angleRadians = Math.toRadians(i);
                    particleX = centerX + radius * Math.cos(angleRadians);
                    particleZ = centerZ + radius * Math.sin(angleRadians);
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123806_, particleX, initialY + 1.0, particleZ, -0.5, 0.5, 0.5);
                }
            }
            if (!pLevel.m_5776_() && knightquestFilledGoblet != null) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (pPlayer.m_21120_(pHand).m_41613_() > 1) {
                    int stackCount = stack.m_41613_();
                    stack.m_41764_(--stackCount);
                } else {
                    pPlayer.m_21008_(pHand, new ItemStack((ItemLike)ItemStack.f_41583_.m_41720_()));
                }
                ItemEntity entity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.0, (double)pPos.m_123343_() + 0.5, knightquestFilledGoblet.m_7968_());
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)fill, (Comparable)Integer.valueOf(1)), 3);
                pLevel.m_7967_((Entity)entity);
            }
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(knightquestRadiantEssence) && ((Integer)pState.m_61143_((Property)fill)).equals(5) && !pLevel.m_5776_()) {
            if (pPlayer.m_21120_(pHand).m_41613_() > 1) {
                int stackCount = stack.m_41613_();
                stack.m_41764_(--stackCount);
            } else {
                pPlayer.m_21008_(pHand, new ItemStack((ItemLike)ItemStack.f_41583_.m_41720_()));
            }
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)fill), 3);
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(knightquestChaoticEssence) && ((Integer)pState.m_61143_((Property)fill)).equals(5) && !pLevel.m_5776_()) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_215671_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (pPlayer.m_21120_(pHand).m_41613_() > 1) {
                int stackCount = stack.m_41613_();
                stack.m_41764_(--stackCount);
            } else {
                pPlayer.m_21008_(pHand, new ItemStack((ItemLike)ItemStack.f_41583_.m_41720_()));
            }
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)fill, (Comparable)Integer.valueOf(10)), 3);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void m_214162_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        double particleZ;
        double particleX;
        double angleRadians;
        int i;
        double initialY;
        double centerZ;
        double centerX;
        double radius;
        if (((Integer)pState.m_61143_((Property)fill)).equals(5) && pLevel.m_5776_()) {
            radius = 0.37;
            centerX = (double)pPos.m_123341_() + 0.5;
            centerZ = (double)pPos.m_123343_() + 0.5;
            initialY = (double)pPos.m_123342_() - 0.5;
            for (i = 0; i < 360; i += 60) {
                angleRadians = Math.toRadians(i);
                particleX = centerX + radius * Math.cos(angleRadians);
                particleZ = centerZ + radius * Math.sin(angleRadians);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123806_, particleX, initialY + 1.0, particleZ, 0.0, 0.35, 0.0);
            }
        }
        if (((Integer)pState.m_61143_((Property)fill)).equals(10) && pLevel.m_5776_()) {
            radius = 0.37;
            centerX = (double)pPos.m_123341_() + 0.5;
            centerZ = (double)pPos.m_123343_() + 0.5;
            initialY = (double)pPos.m_123342_() - 0.5;
            for (i = 0; i < 360; i += 60) {
                angleRadians = Math.toRadians(i);
                particleX = centerX + radius * Math.cos(angleRadians);
                particleZ = centerZ + radius * Math.sin(angleRadians);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123785_, particleX, initialY + 1.0, particleZ, 0.0, 0.35, 0.0);
            }
        }
        super.m_214162_(pState, pLevel, pPos, pRandom);
    }

    @Override
    public void m_213897_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int tickCount = this.getTickCount(pPos);
        if (Arrays.asList(6, 7, 8, 9).contains(pState.m_61143_((Property)fill)) && KnightLib.isKnightQuestLoaded()) {
            if (tickCount == 0) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_11868_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (tickCount % 10 == 0 && (Integer)pState.m_61143_((Property)fill) != 9 && tickCount < 60) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)fill), 3);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (tickCount == 60) {
                Entity entity;
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)fill, (Comparable)Integer.valueOf(1)), 3);
                LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)pLevel);
                if (lightningBolt != null) {
                    lightningBolt.m_6027_((double)pPos.m_123341_() + 0.5, (double)(pPos.m_123342_() - 1), (double)pPos.m_123343_() + 0.5);
                    pLevel.m_7967_((Entity)lightningBolt);
                }
                if ((entity = KnightQuestIntegration.nethermanEntity().m_20615_((Level)pLevel)) != null) {
                    entity.m_6027_((double)((float)pPos.m_123341_() + 0.5f), (double)(pPos.m_123342_() + 1), (double)((float)pPos.m_123343_() + 0.5f));
                    pLevel.m_7967_(entity);
                }
                this.resetTickCount(pPos);
            } else {
                this.incrementTickCount(pPos);
            }
            this.scheduleTick((Level)pLevel, pPos);
        }
    }
}

