/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.datagen;

import dev.xylonity.knightlib.compat.datagen.KnightLibAddItemModifier;
import dev.xylonity.knightlib.compat.registry.KnightLibItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class KnightLibLootModifierGenerator
extends GlobalLootModifierProvider {
    private static final ResourceLocation[] MOB_IDS;
    private static final ResourceLocation RATMAN_ID;
    private static final ResourceLocation LIZZY_ID;

    public KnightLibLootModifierGenerator(PackOutput output) {
        super(output, "knightlib");
    }

    protected void start() {
        for (ResourceLocation mobId : MOB_IDS) {
            this.add(mobId.m_135815_() + "_small_essence", (IGlobalLootModifier)new KnightLibAddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(mobId).m_6409_()}, new ItemStack((ItemLike)KnightLibItems.SMALL_ESSENCE.get()).m_41720_(), 0.5f));
        }
    }

    static {
        int i;
        String[] vanilla = new String[]{"creeper", "spider", "skeleton", "zombie", "cave_spider", "blaze", "enderman", "ghast", "magma_cube", "phantom", "slime", "stray", "vex", "drowned", "witch", "husk", "zombie_villager", "wither_skeleton", "pillager", "vindicator", "evoker", "hoglin", "piglin"};
        String[] knightquest = new String[]{"gremlin", "eldknight", "samhain", "ratman", "swampman", "eldbomb", "lizzy", "bad_patch"};
        MOB_IDS = new ResourceLocation[vanilla.length + knightquest.length];
        for (i = 0; i < vanilla.length; ++i) {
            KnightLibLootModifierGenerator.MOB_IDS[i] = new ResourceLocation("minecraft", "entities/" + vanilla[i]);
        }
        for (i = 0; i < knightquest.length; ++i) {
            KnightLibLootModifierGenerator.MOB_IDS[vanilla.length + i] = new ResourceLocation("knightquest", "entities/" + knightquest[i]);
        }
        RATMAN_ID = new ResourceLocation("knightquest", "entities/ratman");
        LIZZY_ID = new ResourceLocation("knightquest", "entities/lizzy");
    }

    @Mod.EventBusSubscriber(modid="knightlib", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class KnightLibRecipeGenerator {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            generator.addProvider(event.includeServer(), (DataProvider)new KnightLibLootModifierGenerator(packOutput));
        }
    }
}

