/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.records;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public record PlayerProfileData(UUID playerId, String playerName, int level, double experience, double health, double maxHealth, double armor, List<ItemStack> inventory, BlockPos lastKnownPosition, List<String> achievements) {
    public double getExperienceProgress() {
        int expForCurrentLevel = this.getXpForLevel(this.level);
        int expForNextLevel = this.getXpForLevel(this.level + 1);
        return (this.experience - (double)expForCurrentLevel) / (double)(expForNextLevel - expForCurrentLevel);
    }

    public boolean hasAchievement(String achievement) {
        return this.achievements.contains(achievement);
    }

    public void addAchievement(String achievement) {
        if (!this.hasAchievement(achievement)) {
            this.achievements.add(achievement);
        }
    }

    public int getItemCount(String itemName) {
        return this.inventory.stream().filter(itemStack -> itemStack.m_41720_().m_5456_().toString().equals(itemName)).mapToInt(ItemStack::m_41613_).sum();
    }

    public double calculateArmorRating() {
        return this.armor + this.inventory.stream().filter(itemStack -> itemStack.m_41720_() instanceof ArmorItem).mapToDouble(itemStack -> ((ArmorItem)itemStack.m_41720_()).m_40404_()).sum();
    }

    private int getXpForLevel(int level) {
        if (level <= 15) {
            return level * level + 6 * level;
        }
        if (level <= 30) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    @Override
    public String toString() {
        return this.playerName + " [Level: " + this.level + ", Health: " + this.health + "/" + this.maxHealth + "]";
    }
}

