/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockUtil {
    public static boolean isAirBlock(ServerLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_();
    }

    public static void replaceBlock(ServerLevel level, BlockPos pos, Block newBlock) {
        level.m_46597_(pos, newBlock.m_49966_());
    }

    public static void dropBlockAsItem(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        Block.m_49950_((BlockState)blockState, (Level)level, (BlockPos)pos);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public static boolean isBlockSolid(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60804_((BlockGetter)level, pos);
    }

    public static boolean tryPlaceBlock(ServerLevel level, BlockPos pos, Block block, Player player) {
        if (level.m_8055_(pos).m_60795_()) {
            level.m_46597_(pos, block.m_49966_());
            return true;
        }
        return false;
    }

    public static float getBlockHardness(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60800_((BlockGetter)level, pos);
    }

    public static boolean isBlockExposedToSunlight(ServerLevel level, BlockPos pos) {
        return level.m_45527_(pos);
    }

    public static boolean breakBlockAsPlayer(ServerLevel level, BlockPos pos, Player player) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60800_((BlockGetter)level, pos) >= 0.0f) {
            blockState.m_60734_().m_6240_((Level)level, player, pos, blockState, null, player.m_21205_());
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return true;
        }
        return false;
    }

    public static boolean isBlockSurroundedBySolidBlocks(ServerLevel level, BlockPos pos) {
        return BlockUtil.isBlockSolid(level, pos.m_7494_()) && BlockUtil.isBlockSolid(level, pos.m_7495_()) && BlockUtil.isBlockSolid(level, pos.m_122012_()) && BlockUtil.isBlockSolid(level, pos.m_122019_()) && BlockUtil.isBlockSolid(level, pos.m_122024_()) && BlockUtil.isBlockSolid(level, pos.m_122029_());
    }

    public static int countBlockInArea(ServerLevel level, BlockPos fromPos, BlockPos toPos, Block blockToCount) {
        int count = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)fromPos, (BlockPos)toPos)) {
            if (!level.m_8055_(pos).m_60713_(blockToCount)) continue;
            ++count;
        }
        return count;
    }

    public static void destroyBlocksInArea(ServerLevel level, BlockPos fromPos, BlockPos toPos, boolean dropItems) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)fromPos, (BlockPos)toPos)) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) continue;
            if (dropItems) {
                Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static BlockPos findFirstSolidBlockBelow(ServerLevel level, BlockPos pos) {
        BlockPos currentPos = pos.m_7495_();
        while (currentPos.m_123342_() > level.m_141937_()) {
            if (!level.m_8055_(currentPos).m_60795_()) {
                return currentPos;
            }
            currentPos = currentPos.m_7495_();
        }
        return null;
    }

    public static Set<Block> getBlocksInArea(ServerLevel level, BlockPos fromPos, BlockPos toPos) {
        return BlockPos.m_121990_((BlockPos)fromPos, (BlockPos)toPos).map(pos -> level.m_8055_(pos).m_60734_()).collect(Collectors.toSet());
    }

    public static boolean placeBlockWithValidation(ServerLevel level, BlockPos pos, Block block, BlockPlaceContext context) {
        BlockState blockState = block.m_49966_();
        if (blockState.m_60710_((LevelReader)level, pos)) {
            level.m_7731_(pos, blockState, 3);
            return true;
        }
        return false;
    }

    public static void replaceMostFrequentBlock(ServerLevel level, BlockPos fromPos, BlockPos toPos, Block replacementBlock) {
        Map<Block, Long> blockFrequency = BlockPos.m_121990_((BlockPos)fromPos, (BlockPos)toPos).map(pos -> level.m_8055_(pos).m_60734_()).collect(Collectors.groupingBy(block -> block, Collectors.counting()));
        blockFrequency.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).ifPresent(mostFrequentBlock -> BlockPos.m_121990_((BlockPos)fromPos, (BlockPos)toPos).filter(pos -> level.m_8055_(pos).m_60734_() == mostFrequentBlock).forEach(pos -> level.m_46597_(pos, replacementBlock.m_49966_())));
    }

    public static Stream<BlockPos> getBlocksWithCondition(ServerLevel level, BlockPos fromPos, BlockPos toPos, Predicate<BlockState> condition) {
        return BlockPos.m_121990_((BlockPos)fromPos, (BlockPos)toPos).filter(pos -> condition.test(level.m_8055_(pos)));
    }

    public static void replaceBlocksWithCondition(ServerLevel level, BlockPos fromPos, BlockPos toPos, Predicate<BlockState> condition, Block replacementBlock) {
        BlockPos.m_121990_((BlockPos)fromPos, (BlockPos)toPos).filter(pos -> condition.test(level.m_8055_(pos))).forEach(pos -> level.m_46597_(pos, replacementBlock.m_49966_()));
    }
}

