/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class ChatUtil {
    public static MutableComponent createFormattedMessage(String prefix, String message, ChatFormatting ... format) {
        String finalMessage = (prefix != null ? prefix : "") + message;
        return Component.m_237113_((String)finalMessage).m_130944_(format);
    }

    public static MutableComponent createFormattedTranslatableMessage(String prefix, String translationKey, Object[] args, ChatFormatting ... format) {
        String finalPrefix = prefix != null ? prefix : "";
        MutableComponent translatableMessage = Component.m_237110_((String)translationKey, (Object[])args);
        return Component.m_237113_((String)finalPrefix).m_7220_((Component)translatableMessage).m_130944_(format);
    }

    public static void sendChatMessage(Player player, MutableComponent message) {
        if (player.m_9236_().f_46443_) {
            player.m_213846_((Component)message);
        }
    }

    public static void sendChatMessage(Player player, String prefix, String message, ChatFormatting ... format) {
        ChatUtil.sendChatMessage(player, ChatUtil.createFormattedMessage(prefix, message, format));
    }

    public static void addServerChatMessage(Player player, Component message) {
        if (!player.m_9236_().f_46443_) {
            player.m_213846_(message);
        }
    }

    public static void addServerChatMessage(Player player, String prefix, String message, ChatFormatting ... format) {
        ChatUtil.addServerChatMessage(player, (Component)ChatUtil.createFormattedMessage(prefix, message, format));
    }

    public static String blockPosToString(BlockPos pos) {
        return pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_();
    }

    public static void sendStatusMessage(Player player, String prefix, String message, ChatFormatting ... format) {
        player.m_5661_((Component)ChatUtil.createFormattedMessage(prefix, message, format), true);
    }

    public static void sendFeedback(CommandContext<CommandSourceStack> context, String prefix, String message, ChatFormatting ... format) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ChatUtil.createFormattedMessage(prefix, message, format), false);
    }

    public static void sendColoredMessage(Player player, String message, ChatFormatting color) {
        MutableComponent coloredMessage = ChatUtil.createFormattedMessage("", message, new ChatFormatting[0]).m_130940_(color);
        player.m_213846_((Component)coloredMessage);
    }

    public static void sendErrorMessage(Player player, String message) {
        ChatUtil.sendColoredMessage(player, message, ChatFormatting.RED);
    }

    public static void sendSuccessMessage(Player player, String message) {
        ChatUtil.sendColoredMessage(player, message, ChatFormatting.GREEN);
    }

    public static void sendWarningMessage(Player player, String message) {
        ChatUtil.sendColoredMessage(player, message, ChatFormatting.YELLOW);
    }

    public static void broadcastMessage(Iterable<Player> players, String message) {
        for (Player player : players) {
            ChatUtil.sendChatMessage(player, "", message, new ChatFormatting[0]);
        }
    }

    public static void broadcastServerMessage(Iterable<Player> players, String message) {
        for (Player player : players) {
            ChatUtil.addServerChatMessage(player, "", message, new ChatFormatting[0]);
        }
    }

    public static void broadcastFormattedMessage(Iterable<Player> players, String prefix, String message, ChatFormatting ... format) {
        for (Player player : players) {
            ChatUtil.addServerChatMessage(player, prefix, message, format);
        }
    }

    public static void sendPositionalMessage(Player player, String prefix, BlockPos pos) {
        String posString = ChatUtil.blockPosToString(pos);
        ChatUtil.sendChatMessage(player, prefix, "Position: " + posString, ChatFormatting.GRAY);
    }

    public static void logMessageToConsole(String prefix, String message, ChatFormatting formatting) {
        MutableComponent consoleMessage = ChatUtil.createFormattedMessage(prefix, message, formatting);
        System.out.println(consoleMessage.getString());
    }
}

