/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class EntityUtil {
    public static void teleportEntity(Entity entity, BlockPos pos) {
        entity.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public static void makeEntityFollow(Entity follower, Entity target, double speed) {
        if (follower instanceof Mob) {
            Mob mob = (Mob)follower;
            if (target != null) {
                mob.m_21573_().m_5624_(target, speed);
            }
        }
    }

    public static void applyKnockbackInDirection(Entity entity, Vec3 direction, double force) {
        Vec3 vec3 = direction.m_82541_().m_82490_(force);
        entity.m_20256_(vec3);
        entity.f_19864_ = true;
    }

    public static void teleportToHighestSolidBlock(Entity entity, ServerLevel level) {
        BlockPos currentPos = entity.m_20183_();
        BlockPos highestPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, currentPos);
        entity.m_6021_((double)highestPos.m_123341_() + 0.5, (double)highestPos.m_123342_(), (double)highestPos.m_123343_() + 0.5);
    }

    public static void leashEntity(Entity entity, Entity leashHolder) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21463_(leashHolder, true);
        }
    }

    public static void pullEntityTowards(Entity entity, Vec3 targetPos, double pullStrength) {
        Vec3 direction = targetPos.m_82546_(entity.m_20182_()).m_82541_();
        Vec3 pullVector = direction.m_82490_(pullStrength);
        entity.m_20256_(entity.m_20184_().m_82549_(pullVector));
        entity.f_19864_ = true;
    }

    public static void launchEntityUpwards(Entity entity, double velocity) {
        entity.m_20256_(new Vec3(0.0, velocity, 0.0));
        entity.f_19864_ = true;
    }

    public static void explodeEntity(Entity entity, float explosionPower, boolean destroysBlocks) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!entity.m_9236_().f_46443_) {
                level2.m_254849_(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), explosionPower, destroysBlocks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
                entity.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public static void buryEntity(Entity entity, int yLevel) {
        BlockPos entityPos = entity.m_20183_();
        entity.m_6021_((double)entityPos.m_123341_(), (double)yLevel, (double)entityPos.m_123343_());
    }

    public static void strikeWithLightning(Entity entity, ServerLevel level) {
        LightningBolt lightning = new LightningBolt(EntityType.f_20465_, (Level)level);
        lightning.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        level.m_7967_((Entity)lightning);
    }

    public static void randomTeleportWithinRadius(Entity entity, double radius) {
        double randomX = entity.m_20185_() + (Math.random() - 0.5) * radius * 2.0;
        double randomZ = entity.m_20189_() + (Math.random() - 0.5) * radius * 2.0;
        double y = entity.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)randomX, (int)randomZ);
        entity.m_6021_(randomX, y, randomZ);
    }

    public static boolean isEntityInCompleteDarkness(Entity entity) {
        return entity.m_9236_().m_46803_(entity.m_20183_()) == 0;
    }
}

