/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ItemStackUtil {
    public static boolean hasItemAmount(Player player, Item item, int count) {
        int totalCount = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != item || (totalCount += stack.m_41613_()) < count) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromPlayer(Player player, Item item, int count) {
        int remaining = count;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != item) continue;
            int stackCount = stack.m_41613_();
            if (stackCount > remaining) {
                stack.m_41774_(remaining);
                return true;
            }
            remaining -= stackCount;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
        }
        return remaining <= 0;
    }

    public static void clearEnchantments(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41793_() && (tag = stack.m_41783_()) != null) {
            tag.m_128473_("Enchantments");
        }
    }

    public static ItemStack setCustomName(ItemStack stack, String name) {
        stack.m_41714_((Component)Component.m_237113_((String)name));
        return stack;
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment enchantment) {
        return EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(enchantment);
    }

    public static ItemStack combineEnchantments(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return stack1;
        }
        Map enchantment1 = EnchantmentHelper.m_44831_((ItemStack)stack1);
        Map enchantment2 = EnchantmentHelper.m_44831_((ItemStack)stack2);
        enchantment2.forEach((enchantment, level) -> enchantment1.merge(enchantment, level, Math::max));
        EnchantmentHelper.m_44865_((Map)enchantment1, (ItemStack)stack1);
        return stack1;
    }

    public static List<ItemStack> splitStack(ItemStack stack, int size) {
        int splitSize;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int remaining = stack.m_41613_(); remaining > 0; remaining -= splitSize) {
            splitSize = Math.min(size, remaining);
            ItemStack splitStack = stack.m_41777_();
            splitStack.m_41764_(splitSize);
            result.add(splitStack);
        }
        return result;
    }

    public static boolean repairItem(ItemStack stack, int repairAmount) {
        if (!stack.m_41763_() || stack.m_41773_() == 0) {
            return false;
        }
        int newDamage = stack.m_41773_() - repairAmount;
        stack.m_41721_(Math.max(newDamage, 0));
        return true;
    }

    public static boolean fullyRepairItem(ItemStack stack) {
        if (!stack.m_41763_() || stack.m_41773_() == 0) {
            return false;
        }
        stack.m_41721_(0);
        return true;
    }

    public static boolean canStacksBeCombined(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return false;
        }
        return stack1.m_41720_() == stack2.m_41720_() && stack1.m_41773_() == stack2.m_41773_() && !stack1.m_41793_() && !stack2.m_41793_();
    }

    public static int getTotalDurability(ItemStack stack) {
        if (!stack.m_41763_()) {
            return 0;
        }
        return stack.m_41776_();
    }

    public static int getRemainingDurability(ItemStack stack) {
        if (!stack.m_41763_()) {
            return 0;
        }
        return stack.m_41776_() - stack.m_41773_();
    }

    public static void addCustomNBT(ItemStack stack, String key, String value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(key, value);
    }

    public static String getCustomNBT(ItemStack stack, String key) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(key) ? tag.m_128461_(key) : null;
    }
}

