/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class PlayerUtil {
    public static void healPlayer(Player player, float amount) {
        player.m_21153_(Math.min(player.m_21233_(), player.m_21223_() + amount));
    }

    public static void teleportPlayer(Player player, BlockPos pos) {
        player.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public static boolean giveItemToPlayer(Player player, ItemStack itemStack) {
        int freeSpace = PlayerUtil.calculateFreeSpaceForItem(player, itemStack);
        if (freeSpace >= itemStack.m_41613_()) {
            player.m_150109_().m_36054_(itemStack);
            return true;
        }
        if (freeSpace > 0) {
            ItemStack stackToAdd = itemStack.m_41777_();
            stackToAdd.m_41764_(freeSpace);
            player.m_150109_().m_36054_(stackToAdd);
        }
        ItemStack remainingStack = itemStack.m_41777_();
        remainingStack.m_41764_(itemStack.m_41613_() - freeSpace);
        PlayerUtil.dropItemNearPlayer(player, remainingStack);
        return false;
    }

    private static int calculateFreeSpaceForItem(Player player, ItemStack itemStack) {
        int freeSpace = 0;
        int maxStackSize = itemStack.m_41741_();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_()) {
                freeSpace += maxStackSize;
            } else if (stack == itemStack) {
                freeSpace += maxStackSize - stack.m_41613_();
            }
            if (freeSpace < itemStack.m_41613_()) continue;
            return itemStack.m_41613_();
        }
        return freeSpace;
    }

    private static void dropItemNearPlayer(Player player, ItemStack itemStack) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && !itemStack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), itemStack);
            itemEntity.m_32010_(40);
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static boolean transferItemBetweenPlayers(Player fromPlayer, Player toPlayer, ItemStack itemStack, int amount) {
        ItemStack stackToTransfer = itemStack.m_41777_();
        stackToTransfer.m_41764_(amount);
        if (fromPlayer.m_150109_().m_36063_(stackToTransfer)) {
            fromPlayer.m_150109_().m_36057_(stackToTransfer);
            boolean addedToReceiver = toPlayer.m_150109_().m_36054_(stackToTransfer);
            if (!addedToReceiver) {
                PlayerUtil.dropItemNearPlayer(toPlayer, stackToTransfer);
            }
            return true;
        }
        return false;
    }

    public static boolean giveItemIfConditionsMet(Player player, int requiredYLevel, int requiredExperience, ItemStack itemStack) {
        if (player.m_20186_() > (double)requiredYLevel && player.f_36078_ >= requiredExperience) {
            return PlayerUtil.giveItemToPlayer(player, itemStack);
        }
        return false;
    }

    public static boolean hasFreeInventorySlots(Player player, int requiredSlots) {
        long freeSlots = player.m_150109_().f_35974_.stream().filter(ItemStack::m_41619_).count();
        return freeSlots >= (long)requiredSlots;
    }

    public static void setPlayerHunger(Player player, int amount) {
        player.m_36324_().m_38705_(Math.min(20, Math.max(0, amount)));
    }

    public static boolean isPlayerAboveYLevel(Player player, double yLevel) {
        return player.m_20186_() > yLevel;
    }

    public static void killPlayer(Player player) {
        player.m_21153_(0.0f);
    }

    public static void launchPlayer(Player player, Vec3 direction, double velocity) {
        Vec3 normalizedDirection = direction.m_82541_();
        player.m_20256_(normalizedDirection.m_82490_(velocity));
        player.f_19812_ = true;
    }

    public static void freezePlayer(Player player, int freezeTicks) {
        player.m_146917_(freezeTicks);
    }

    public static boolean isPlayerInWater(Player player) {
        return player.m_20069_();
    }

    public static void applyPotionEffect(Player player, MobEffect effect, int duration, int amplifier) {
        player.m_7292_(new MobEffectInstance(effect, duration, amplifier));
    }

    public static void pushPlayerAwayFromEntity(Player player, Entity entity, double force) {
        Vec3 direction = player.m_20182_().m_82546_(entity.m_20182_()).m_82541_();
        player.m_20256_(direction.m_82490_(force));
        player.f_19812_ = true;
    }

    public static void setPlayerGlowing(Player player, int duration) {
        PlayerUtil.applyPotionEffect(player, MobEffects.f_19619_, duration, 0);
    }

    public static boolean isPlayerWithinDistance(Player player, BlockPos pos, double maxDistance) {
        return player.m_20183_().m_123314_((Vec3i)pos, maxDistance);
    }

    public static boolean tryGiveItem(Player player, ItemStack stack) {
        if (player.m_150109_().m_36062_() != -1) {
            player.m_150109_().m_36054_(stack);
            return true;
        }
        return false;
    }

    public static void resetPlayerPositionToSpawn(Player player) {
        BlockPos spawnPos = ((ServerPlayer)player).m_8961_();
        if (spawnPos != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Optional spawnLocation = Player.m_36130_((ServerLevel)((ServerLevel)serverPlayer.m_9236_()), (BlockPos)spawnPos, (float)((ServerPlayer)player).m_8962_(), (boolean)true, (boolean)false);
            if (spawnLocation.isPresent()) {
                Vec3 spawnVec = (Vec3)spawnLocation.get();
                player.m_6021_(spawnVec.m_7096_(), spawnVec.m_7098_(), spawnVec.m_7094_());
            } else {
                PlayerUtil.teleportToWorldSpawn(player);
            }
        } else {
            PlayerUtil.teleportToWorldSpawn(player);
        }
    }

    private static void teleportToWorldSpawn(Player player) {
        BlockPos worldSpawn = player.m_9236_().m_220360_();
        player.m_6021_((double)worldSpawn.m_123341_(), (double)worldSpawn.m_123342_(), (double)worldSpawn.m_123343_());
    }

    public static Entity findClosestEntity(Player player, double maxDistance, Predicate<Entity> condition) {
        return player.m_9236_().m_6249_((Entity)player, player.m_20191_().m_82400_(maxDistance), condition).stream().min(Comparator.comparingDouble(e -> e.m_20270_((Entity)player))).orElse(null);
    }

    public static String getFormattedInventoryString(Player player) {
        return player.m_150109_().f_35974_.stream().filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> itemStack.m_41720_().m_5524_() + " x" + itemStack.m_41613_()).collect(Collectors.joining(", "));
    }

    public static boolean isPlayerHoldingAnyItemFromList(Player player, List<ItemStack> itemList) {
        return itemList.stream().anyMatch(item -> player.m_21205_().m_41720_().equals(item.m_41720_()));
    }

    public static List<Player> sortPlayersByExperienceLevel(List<Player> players) {
        return players.stream().sorted(Comparator.comparingInt(Player::m_213860_).reversed()).collect(Collectors.toList());
    }

    public static <T extends Entity> List<T> findEntitiesAroundPlayer(Player player, Class<T> entityType, double radius) {
        return player.m_9236_().m_45976_(entityType, player.m_20191_().m_82400_(radius));
    }

    public static void randomTeleport(Player player, double range) {
        double randomX = player.m_20185_() + (Math.random() - 0.5) * range * 2.0;
        double randomZ = player.m_20189_() + (Math.random() - 0.5) * range * 2.0;
        double y = player.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)randomX, (int)randomZ);
        player.m_6021_(randomX, y, randomZ);
    }

    public static void fullyHealAndFeedPlayer(Player player) {
        player.m_21153_(player.m_21233_());
        player.m_36324_().m_38705_(20);
        player.m_36324_().m_38717_(20.0f);
    }

    public static BlockPos findNearestBlockOfType(Player player, List<Block> blockTypes, double radius) {
        BlockPos playerPos = player.m_20183_();
        BlockPos nearestBlock = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_((int)(-radius), (int)(-radius), (int)(-radius)), (BlockPos)playerPos.m_7918_((int)radius, (int)radius, (int)radius))) {
            double distance;
            if (!blockTypes.contains(player.m_9236_().m_8055_(pos).m_60734_()) || !((distance = playerPos.m_123331_((Vec3i)pos)) < closestDistance)) continue;
            closestDistance = distance;
            nearestBlock = pos;
        }
        return nearestBlock;
    }

    public static int calculateInventoryValue(Player player, Map<Item, Integer> itemValues) {
        return player.m_150109_().f_35974_.stream().filter(itemStack -> !itemStack.m_41619_() && itemValues.containsKey(itemStack.m_41720_())).mapToInt(itemStack -> (Integer)itemValues.get(itemStack.m_41720_()) * itemStack.m_41613_()).sum();
    }

    public static void executeRunnableAtLocation(Player player, BlockPos targetPos, double radius, Runnable runnable) {
        if (player.m_20183_().m_123314_((Vec3i)targetPos, radius)) {
            runnable.run();
        }
    }

    public static void logPlayerState(Player player) {
        System.out.printf("Player Position: [x: %.2f, y: %.2f, z: %.2f]%n", player.m_20185_(), player.m_20186_(), player.m_20189_());
        System.out.println("Inventory: " + PlayerUtil.getFormattedInventoryString(player));
    }

    public static void sortInventoryByItemName(Player player) {
        List<ItemStack> sortedItems = player.m_150109_().f_35974_.stream().filter(itemStack -> !itemStack.m_41619_()).sorted(Comparator.comparing(itemStack -> itemStack.m_41720_().m_5524_())).toList();
        ItemStack[] armorBackup = new ItemStack[4];
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            armorBackup[slot.m_20749_()] = (ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_());
        }
        ItemStack offhandBackup = (ItemStack)player.m_150109_().f_35976_.get(0);
        player.m_150109_().m_6211_();
        for (int i = 0; i < sortedItems.size() && i < player.m_150109_().f_35974_.size(); ++i) {
            player.m_150109_().m_6836_(i, sortedItems.get(i));
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            player.m_150109_().f_35975_.set(slot.m_20749_(), (Object)armorBackup[slot.m_20749_()]);
        }
        player.m_150109_().f_35976_.set(0, (Object)offhandBackup);
    }
}

