/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.ai.navigator;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public class NodeSmoother {
    public static List<Node> copyAndSmooth(@NotNull Path original) {
        ArrayList<Node> nodes = new ArrayList<Node>(original.m_77398_());
        for (int i = 0; i < original.m_77398_(); ++i) {
            nodes.add(original.m_77375_(i));
        }
        return NodeSmoother.smoothNodes(nodes);
    }

    private static List<Node> smoothNodes(List<Node> nodes) {
        if (nodes.size() < 3) {
            return ImmutableList.copyOf(nodes);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(nodes.get(0));
        for (int i = 1; i < nodes.size() - 1; ++i) {
            Node next;
            Node curr;
            Node prev = (Node)result.get(result.size() - 1);
            if (NodeSmoother.isNearlyCollinear(prev, curr = nodes.get(i), next = nodes.get(i + 1))) continue;
            result.add(curr);
        }
        result.add(nodes.get(nodes.size() - 1));
        return ImmutableList.copyOf(result);
    }

    private static boolean isNearlyCollinear(Node prev, Node curr, Node next) {
        double v1x = curr.f_77271_ - prev.f_77271_;
        double v1y = curr.f_77272_ - prev.f_77272_;
        double v1z = curr.f_77273_ - prev.f_77273_;
        double v2x = next.f_77271_ - curr.f_77271_;
        double v2y = next.f_77272_ - curr.f_77272_;
        double v2z = next.f_77273_ - curr.f_77273_;
        double len1 = Math.sqrt(v1x * v1x + v1y * v1y + v1z * v1z);
        double len2 = Math.sqrt(v2x * v2x + v2y * v2y + v2z * v2z);
        if (len1 < 1.0E-6 || len2 < 1.0E-6) {
            return true;
        }
        double dot = v1x * v2x + v1y * v2y + v1z * v2z;
        double cos = dot / (len1 * len2);
        double angle = Math.toDegrees(Math.acos(cos = Math.max(-1.0, Math.min(1.0, cos))));
        return angle < 15.0;
    }
}

