/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.boss;

import dev.xylonity.knightquest.common.entity.boss.AbstractNethermanProjectile;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NethermanProjectileChargeEntity
extends AbstractNethermanProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int explosionTimer;
    private boolean shouldGoDown;

    public NethermanProjectileChargeEntity(EntityType<? extends AbstractNethermanProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
        this.explosionTimer = this.f_19796_.m_188503_(100) + 20;
        if (!this.m_9236_().f_46443_) {
            this.shouldGoDown = this.f_19796_.m_188499_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            --this.explosionTimer;
            if (this.explosionTimer <= 0) {
                this.explode();
            }
        }
        if (this.shouldGoDown && !this.m_9236_().f_46443_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        }
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.m_9236_().f_46443_) {
            this.explode();
        }
    }

    private void explode() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)KQConfigValues.NETHERMAN_PROJECTILE_EXPLOSION_RADIUS, Level.ExplosionInteraction.NONE);
        this.m_146870_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rotateController", 0, this::rotatePredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coreController", 0, this::corePredicate)});
    }

    private PlayState corePredicate(AnimationState<?> event) {
        if (this.f_19797_ < 10) {
            event.getController().setAnimation(RawAnimation.begin().then("summon", Animation.LoopType.PLAY_ONCE));
        } else if (this.explosionTimer < 11) {
            event.getController().setAnimation(RawAnimation.begin().then("die", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState rotatePredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("rotate", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

