/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.registry.KnightQuestParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EldBombEntity
extends Creeper
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;

    public EldBombEntity(EntityType<? extends Creeper> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier setAttributes() {
        return Creeper.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, 0.5).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SwellGoal((Creeper)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 35.0f, 1.0, 0.5));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.swell > 10) {
            event.getController().setAnimation(RawAnimation.begin().then("sneak", Animation.LoopType.LOOP));
        } else if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public int getSwell() {
        return this.swell;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int $$0;
            this.oldSwell = this.swell;
            if (this.m_32311_()) {
                this.m_32283_(1);
            }
            if (($$0 = this.m_32310_()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += $$0;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.poisonNearbyPlayers();
                this.explode();
            }
        }
        super.m_8119_();
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            float power = this.m_7090_() ? 2.5f : 1.0f;
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * power, Level.ExplosionInteraction.MOB);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 6; ++i) {
                    double particleX = this.m_20185_();
                    double particleY = this.m_20186_() + 1.0;
                    double particleZ = this.m_20189_();
                    ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)KnightQuestParticles.POISON_PARTICLE.get(), true, particleX, particleY, particleZ, 1.2f, 1.2f, 1.2f, 0.05f, 1);
                    serverLevel.m_7654_().m_6846_().m_11241_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 50.0, serverLevel.m_46472_(), (Packet)packet);
                }
                float[] arrayX = new float[]{0.5f, -1.0f, 1.0f};
                float[] arrayZ = new float[]{1.0f, 0.0f, -0.5f};
                for (int i = 0; i < 3; ++i) {
                    double particleX = this.m_20185_() + (double)arrayX[i];
                    double particleY = this.m_20186_() - 0.2;
                    double particleZ = this.m_20189_() + (double)arrayZ[i];
                    ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)KnightQuestParticles.POISON_CLOUD_PARTICLE.get(), true, particleX, particleY, particleZ, 0.0f, 0.15f, 0.0f, 1.0f, 1);
                    serverLevel.m_7654_().m_6846_().m_11241_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 50.0, serverLevel.m_46472_(), (Packet)packet);
                }
            }
            this.m_146870_();
        }
    }

    private void poisonNearbyPlayers() {
        this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(3.5)).forEach(player -> player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 160, 0)));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate).setOverrideEasingType(EasingType.LINEAR)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

