/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.item.weapons;

import dev.xylonity.knightquest.common.item.KQWeaponItem;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NailWeapon
extends KQWeaponItem {
    private static final Map<UUID, Boolean> doubleJumpStates = new HashMap<UUID, Boolean>();

    public NailWeapon(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    @Override
    public void interaction(Level level, Player player, InteractionHand hand) {
        boolean canDash = doubleJumpStates.getOrDefault(player.m_20148_(), true);
        if (canDash) {
            NailWeapon.handleClientSideDoubleJump(player);
        }
        doubleJumpStates.put(player.m_20148_(), true);
    }

    @Override
    public int getCooldownTicks() {
        return KQConfigValues.COOLDOWN_NAIL;
    }

    @Override
    public String getName() {
        return "nail";
    }

    @Override
    protected boolean isEnabled() {
        return KQConfigValues.NAIL;
    }

    private static void handleClientSideDoubleJump(Player player) {
        boolean canDash = doubleJumpStates.getOrDefault(player.m_20148_(), true);
        if (canDash) {
            Level level;
            if (player.m_9236_().f_46443_) {
                doubleJumpStates.put(player.m_20148_(), false);
                double dashSpeed = KQConfigValues.DASH_POWER_NAIL;
                player.m_20256_(player.m_20154_().m_82490_(dashSpeed));
            }
            if (!player.m_9236_().f_46443_ && (level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                Vec3 playerPos = player.m_20182_().m_82520_(0.0, 1.0, 0.0);
                Vec3 dashDirection = player.m_20154_().m_82490_(0.5);
                for (int i = 0; i < 20; ++i) {
                    double randomOffsetX = (Math.random() - 0.5) * 0.3;
                    double randomOffsetY = (Math.random() - 0.5) * 0.1;
                    double randomOffsetZ = (Math.random() - 0.5) * 0.3;
                    Vec3 particlePos = playerPos.m_82520_(randomOffsetX, randomOffsetY, randomOffsetZ);
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123796_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, dashDirection.f_82479_, dashDirection.f_82480_, dashDirection.f_82481_, 0.1);
                }
            }
        }
    }
}

