/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class KQAddItemModifier
extends LootModifier {
    public static final Supplier<Codec<KQAddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> KQAddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, KQAddItemModifier::new)));
    private final Item item;
    private final float chance;

    public KQAddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        if (this.item == KnightQuestItems.RATMAN_EYE.get() && context.m_230907_().m_188501_() <= KQConfigValues.DROP_CHANCE_RATMAN_EYE) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        if (this.item == KnightQuestItems.LIZZY_SCALE.get() && context.m_230907_().m_188501_() <= KQConfigValues.DROP_CHANCE_LIZZY_SCALE) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

