/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.registry;

import dev.xylonity.knightquest.KnightQuest;
import dev.xylonity.knightquest.common.entity.boss.NethermanCloneEntity;
import dev.xylonity.knightquest.common.entity.boss.NethermanEntity;
import dev.xylonity.knightquest.common.entity.boss.NethermanProjectileChargeEntity;
import dev.xylonity.knightquest.common.entity.entities.BadPatchEntity;
import dev.xylonity.knightquest.common.entity.entities.EldBombEntity;
import dev.xylonity.knightquest.common.entity.entities.EldKnightEntity;
import dev.xylonity.knightquest.common.entity.entities.FallenKnightEntity;
import dev.xylonity.knightquest.common.entity.entities.GhastlingEntity;
import dev.xylonity.knightquest.common.entity.entities.GhostyEntity;
import dev.xylonity.knightquest.common.entity.entities.GremlinEntity;
import dev.xylonity.knightquest.common.entity.entities.LizzyEntity;
import dev.xylonity.knightquest.common.entity.entities.RatmanEntity;
import dev.xylonity.knightquest.common.entity.entities.SamhainEntity;
import dev.xylonity.knightquest.common.entity.entities.SwampmanAxeEntity;
import dev.xylonity.knightquest.common.entity.entities.SwampmanEntity;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class KnightQuestEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"knightquest");
    public static final RegistryObject<EntityType<GremlinEntity>> GREMLIN = KnightQuestEntities.register("gremlin", GremlinEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<FallenKnightEntity>> FALLEN_KNIGHT = KnightQuestEntities.register("fallen_knight", FallenKnightEntity::new, MobCategory.MONSTER, 0.8f, 2.0f);
    public static final RegistryObject<EntityType<EldBombEntity>> ELDBOMB = KnightQuestEntities.register("eldbomb", EldBombEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<EldKnightEntity>> ELDKINGHT = KnightQuestEntities.register("eldknight", EldKnightEntity::new, MobCategory.MONSTER, 1.0f, 2.6f);
    public static final RegistryObject<EntityType<SwampmanEntity>> SWAMPMAN;
    public static final RegistryObject<EntityType<SamhainEntity>> SAMHAIN;
    public static final RegistryObject<EntityType<RatmanEntity>> RATMAN;
    public static final RegistryObject<EntityType<LizzyEntity>> LIZZY;
    public static final RegistryObject<EntityType<BadPatchEntity>> BADPATCH;
    public static final RegistryObject<EntityType<GhastlingEntity>> SHIELD;
    public static final RegistryObject<EntityType<GhostyEntity>> GHOSTY;
    public static final RegistryObject<EntityType<NethermanEntity>> NETHERMAN;
    public static final RegistryObject<EntityType<NethermanCloneEntity>> NETHERMAN_CLONE;
    public static final RegistryObject<EntityType<NethermanProjectileChargeEntity>> NETHERMAN_PROJECTILE_CHARGE;
    public static final RegistryObject<EntityType<SwampmanAxeEntity>> SWAMPMAN_AXE;
    public static final RegistryObject<Item> GREMLIN_EGG;
    public static final RegistryObject<Item> ELD_BOMB_EGG;
    public static final RegistryObject<Item> ELD_KNIGHT_EGG;
    public static final RegistryObject<Item> RATMAN_EGG;
    public static final RegistryObject<Item> SAMHAIN_EGG;
    public static final RegistryObject<Item> SWAMPMAN_EGG;
    public static final RegistryObject<Item> LIZZY_EGG;
    public static final RegistryObject<Item> BADPATCH_EGG;
    public static final RegistryObject<Item> GHOSTY_EGG;
    public static final RegistryObject<Item> NETHERMAN_EGG;
    public static final RegistryObject<Item> FALLEN_KNIGHT_EGG;

    private static <X extends Entity> RegistryObject<EntityType<X>> register(String name, EntityType.EntityFactory<X> entity, MobCategory category, float width, float height) {
        return ENTITY.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entity, (MobCategory)category).m_20699_(width, height).m_20712_(String.valueOf(new ResourceLocation("knightquest", name))));
    }

    private static <X extends Mob> RegistryObject<Item> registerSpawnEggItem(String id, Supplier<EntityType<X>> entityType, int primaryEggColour, int secondaryEggColour) {
        return KnightQuest.ITEMS.register(id, () -> new ForgeSpawnEggItem(entityType, primaryEggColour, secondaryEggColour, new Item.Properties()));
    }

    static {
        SAMHAIN = KnightQuestEntities.register("samhain", SamhainEntity::new, MobCategory.MONSTER, 1.0f, 1.5f);
        SWAMPMAN = KnightQuestEntities.register("swampman", SwampmanEntity::new, MobCategory.MONSTER, 1.0f, 2.0f);
        RATMAN = KnightQuestEntities.register("ratman", RatmanEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        LIZZY = KnightQuestEntities.register("lizzy", LizzyEntity::new, MobCategory.AMBIENT, 1.0f, 0.3f);
        BADPATCH = KnightQuestEntities.register("bad_patch", BadPatchEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        SHIELD = KnightQuestEntities.register("ghastling", GhastlingEntity::new, MobCategory.MONSTER, 0.65f, 0.65f);
        GHOSTY = KnightQuestEntities.register("ghosty", GhostyEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        NETHERMAN = KnightQuestEntities.register("netherman", NethermanEntity::new, MobCategory.MONSTER, 0.8f, 2.8f);
        NETHERMAN_CLONE = KnightQuestEntities.register("netherman_clone", NethermanCloneEntity::new, MobCategory.MONSTER, 0.8f, 2.8f);
        NETHERMAN_PROJECTILE_CHARGE = KnightQuestEntities.register("netherman_projectile_charge", NethermanProjectileChargeEntity::new, MobCategory.MISC, 0.5f, 0.5f);
        SWAMPMAN_AXE = KnightQuestEntities.register("swampman_axe", SwampmanAxeEntity::new, MobCategory.MISC, 0.3f, 1.0f);
        GREMLIN_EGG = KnightQuestEntities.registerSpawnEggItem("gremlin_spawn_egg", GREMLIN, 12726054, 0x45545D);
        ELD_BOMB_EGG = KnightQuestEntities.registerSpawnEggItem("eldbomb_spawn_egg", ELDBOMB, 4407374, 8509989);
        ELD_KNIGHT_EGG = KnightQuestEntities.registerSpawnEggItem("eldknight_spawn_egg", ELDKINGHT, 8358578, 9058606);
        RATMAN_EGG = KnightQuestEntities.registerSpawnEggItem("ratman_spawn_egg", RATMAN, 3813437, 12014467);
        SAMHAIN_EGG = KnightQuestEntities.registerSpawnEggItem("samhain_spawn_egg", SAMHAIN, 16637443, 9972024);
        SWAMPMAN_EGG = KnightQuestEntities.registerSpawnEggItem("swampman_spawn_egg", SWAMPMAN, 1083251, 10367055);
        LIZZY_EGG = KnightQuestEntities.registerSpawnEggItem("lizzy_spawn_egg", LIZZY, 764914, 13729835);
        BADPATCH_EGG = KnightQuestEntities.registerSpawnEggItem("bad_patch_spawn_egg", BADPATCH, 15472139, 15725048);
        GHOSTY_EGG = KnightQuestEntities.registerSpawnEggItem("ghosty_spawn_egg", GHOSTY, 2930814, 16507141);
        NETHERMAN_EGG = KnightQuestEntities.registerSpawnEggItem("netherman_spawn_egg", NETHERMAN, 15461868, 0xC3C3C3);
        FALLEN_KNIGHT_EGG = KnightQuestEntities.registerSpawnEggItem("fallen_knight_spawn_egg", FALLEN_KNIGHT, 0xC5C5C5, 5735417);
    }
}

