/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModMaterials {
    public static final DeferredRegister<ArmorMaterial> MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"critterarmory");
    public static final Map.Entry<Holder<ArmorMaterial>, String> IRON = ModMaterials.copy((Holder<ArmorMaterial>)ArmorMaterials.IRON);
    public static final Map.Entry<Holder<ArmorMaterial>, String> GOLD = ModMaterials.copy((Holder<ArmorMaterial>)ArmorMaterials.GOLD, "golden");
    public static final Map.Entry<Holder<ArmorMaterial>, String> DIAMOND = ModMaterials.copy((Holder<ArmorMaterial>)ArmorMaterials.DIAMOND);
    public static final Map.Entry<Holder<ArmorMaterial>, String> NETHERITE = ModMaterials.copy((Holder<ArmorMaterial>)ArmorMaterials.NETHERITE);

    private static EnumMap<ArmorItem.Type, Integer> createMap(int[] values) {
        EnumMap<ArmorItem.Type, Integer> enumMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (int i = 0; i < values.length; ++i) {
            enumMap.put(ArmorItem.Type.values()[i], values[i]);
        }
        return enumMap;
    }

    private static Map.Entry<Holder<ArmorMaterial>, String> copy(Holder<ArmorMaterial> material) {
        ArmorMaterial value = (ArmorMaterial)material.value();
        return ModMaterials.register(material.getRegisteredName().substring(material.getRegisteredName().indexOf(58) + 1), (EnumMap)value.defense(), value.enchantmentValue(), (Holder<SoundEvent>)value.equipSound(), value.toughness(), value.knockbackResistance(), value.repairIngredient());
    }

    private static Map.Entry<Holder<ArmorMaterial>, String> copy(Holder<ArmorMaterial> material, String name) {
        return ModMaterials.register(ModMaterials.copy(material).getKey(), name);
    }

    private static Map.Entry<Holder<ArmorMaterial>, String> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int i, Holder<SoundEvent> holder, float f, float g, Supplier<Ingredient> supplier) {
        return Map.entry(MATERIALS.register(name, () -> new ArmorMaterial((Map)defense, i, holder, supplier, List.of(new ArmorMaterial.Layer(new ResourceLocation("critterarmory", name))), f, g)), name);
    }

    private static Map.Entry<Holder<ArmorMaterial>, String> register(Holder<ArmorMaterial> material, String name) {
        return Map.entry(material, name);
    }

    public static void init(IEventBus bus) {
        MATERIALS.register(bus);
    }
}

