/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.json;

import club.someoneice.json.JsonParser;
import club.someoneice.json.node.ArrayNode;
import club.someoneice.json.node.JsonNode;
import club.someoneice.json.node.MapNode;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class JSON {
    public static JSON json = new JSON(false);
    public static JSON json5 = new JSON(true);
    private final boolean isJson5;

    private JSON(boolean isJson5) {
        this.isJson5 = isJson5;
    }

    public JsonNode<?> parse(File file) {
        JsonParser processor = new JsonParser(file, this.isJson5);
        return processor.getNodeWithTypeUnknown();
    }

    public JsonNode<?> parse(InputStream inputStream, boolean shouldClose) {
        JsonParser processor = new JsonParser(inputStream, shouldClose, this.isJson5);
        return processor.getNodeWithTypeUnknown();
    }

    public JsonNode<?> parse(String str) {
        JsonParser processor = new JsonParser(str);
        return processor.getNodeWithTypeUnknown();
    }

    @Deprecated
    public ArrayNode tryPullArrayOrEmpty(JsonNode<?> jsonNode) {
        if (jsonNode.getType() == JsonNode.NodeType.Array) {
            return (ArrayNode)jsonNode;
        }
        return new ArrayNode(new ArrayList());
    }

    @Deprecated
    public ArrayNode tryPullArrayOrEmpty(String raw) {
        JsonNode<?> jsonNode = this.parse(raw);
        return this.tryPullArrayOrEmpty(jsonNode);
    }

    @Deprecated
    public MapNode tryPullObjectOrEmpty(JsonNode<?> jsonNode) {
        if (jsonNode.getType() == JsonNode.NodeType.Map) {
            return (MapNode)jsonNode;
        }
        return new MapNode(new HashMap());
    }

    @Deprecated
    public MapNode tryPullObjectOrEmpty(String raw) {
        JsonNode<?> jsonNode = this.parse(raw);
        return this.tryPullObjectOrEmpty(jsonNode);
    }

    public <T> T tryPullAsClass(Class<? extends T> clazz, String str) throws InstantiationException, IllegalAccessException {
        MapNode jsonMap = this.tryPullObjectOrEmpty(this.parse(str));
        return this.tryPullAsClass(clazz, jsonMap);
    }

    public <T> T tryPullAsClass(Class<? extends T> clazz, File file) throws InstantiationException, IllegalAccessException {
        MapNode jsonMap = this.tryPullObjectOrEmpty(this.parse(file));
        return this.tryPullAsClass(clazz, jsonMap);
    }

    public <T> T tryPullAsClass(Class<? extends T> clazz, MapNode jsonMap) throws InstantiationException, IllegalAccessException {
        Field[] fields;
        T targetClass = clazz.newInstance();
        for (Field field : fields = targetClass.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            field.set(targetClass, jsonMap.get(name).getObj());
        }
        return targetClass;
    }

    public <T> List<T> tryPullAsClassList(Class<? extends T> clazz, String str) throws InstantiationException, IllegalAccessException {
        JsonNode<?> jsonNode = this.parse(str);
        return this.createClassList(clazz, jsonNode);
    }

    public <T> List<T> tryPullAsClassList(Class<? extends T> clazz, File file) throws InstantiationException, IllegalAccessException {
        JsonNode<?> jsonNode = this.parse(file);
        return this.createClassList(clazz, jsonNode);
    }

    private <T> List<T> createClassList(Class<? extends T> clazz, JsonNode<?> jsonNode) throws InstantiationException, IllegalAccessException {
        if (jsonNode.getType() == JsonNode.NodeType.Map) {
            return Collections.singletonList(this.tryPullAsClass(clazz, (MapNode)jsonNode));
        }
        if (jsonNode.getType() != JsonNode.NodeType.Array) {
            return null;
        }
        ArrayNode jsonList = this.tryPullArrayOrEmpty(jsonNode);
        ArrayList<T> clazzList = new ArrayList<T>();
        Iterator iterator = jsonList.getObj().iterator();
        while (iterator.hasNext()) {
            JsonNode node = (JsonNode)iterator.next();
            clazzList.add(this.tryPullAsClass(clazz, this.tryPullObjectOrEmpty(node)));
        }
        return clazzList;
    }
}

