/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.json;

import club.someoneice.json.node.ArrayNode;
import club.someoneice.json.node.BooleanNode;
import club.someoneice.json.node.DoubleNode;
import club.someoneice.json.node.FloatNode;
import club.someoneice.json.node.IntegerNode;
import club.someoneice.json.node.JsonNode;
import club.someoneice.json.node.MapNode;
import club.someoneice.json.node.NullNode;
import club.someoneice.json.node.StringNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;

public class JsonParser {
    public static final String SP = "    ";
    public static final char KEY_SPACE = ' ';
    public static final char KEY_STRING = '\"';
    public static final char KEY_NEXT = ',';
    public static final char KEY_VALUE = ':';
    public static final char KEY_ARRAY_START = '[';
    public static final char KEY_ARRAY_END = ']';
    public static final char KEY_MAP_START = '{';
    public static final char KEY_MAP_END = '}';
    public static final char KEY_COUNT = '.';
    String raw;

    JsonParser(String str) {
        this.raw = str;
    }

    JsonParser(File file, boolean json5) {
        try {
            if (!json5) {
                this.raw = this.fileReader(file);
            } else {
                this.json5processor(file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    JsonParser(InputStream stream, boolean shouldClose, boolean isJson5) {
        try {
            this.raw = !isJson5 ? (shouldClose ? this.streamReader(stream) : this.streamReaderWithoutClose(stream)) : (shouldClose ? this.json5ProcessorStreamWithClose(stream) : this.json5processor(stream));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String json5ProcessorStreamWithClose(InputStream stream) throws IOException {
        String rawS = this.json5processor(stream);
        stream.close();
        return rawS;
    }

    String json5processor(InputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader in = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(in);
        while (reader.ready()) {
            String text = reader.readLine();
            if (text.contains("//")) {
                builder.append(text, 0, text.indexOf("//"));
                continue;
            }
            builder.append(text);
        }
        in.close();
        reader.close();
        return builder.toString();
    }

    private void json5processor(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            StringBuilder builder = new StringBuilder();
            FileReader fr = new FileReader(file);
            BufferedReader reader = new BufferedReader(fr);
            this.read(builder, reader);
            fr.close();
            reader.close();
            this.raw = builder.toString();
            return;
        }
        this.raw = "";
    }

    private void read(StringBuilder builder, BufferedReader reader) throws IOException {
        while (reader.ready()) {
            String text = reader.readLine();
            if (text.contains("//")) {
                builder.append(text, 0, text.indexOf("//"));
                continue;
            }
            builder.append(text);
        }
    }

    JsonNode<?> getNodeWithTypeUnknown() {
        if (this.raw.isEmpty()) {
            return NullNode.INSTANCE;
        }
        return this.getNodeWithTypeUnknown(this.raw);
    }

    private JsonNode<?> getNodeWithTypeUnknown(String rawStr) {
        char[] charList = (rawStr = rawStr.replaceAll("\n", "").replaceAll("\r", "")).toCharArray();
        char c = charList[0];
        return c == '[' ? this.arrayNodeProcessor(charList) : (c == '{' ? this.mapNodeProcessor(charList) : this.tryGetNode(new StringBuilder(rawStr)));
    }

    private ArrayNode arrayNodeProcessor(char[] charList) {
        ArrayNode node = new ArrayNode(new ArrayList());
        StringBuilder builder = new StringBuilder();
        boolean stringStart = false;
        for (int i = 1; i < charList.length; ++i) {
            StringBuilder array;
            int end;
            char c = charList[i];
            if (stringStart) {
                if (c != '\"') {
                    builder.append(c);
                    continue;
                }
                stringStart = false;
                node.add(this.tryGetNode(builder));
                builder.delete(0, builder.length());
                continue;
            }
            if (c == ' ') continue;
            if (c == '}') {
                throw new RuntimeException("Here are no map! But its a map 's end!");
            }
            if (c == ',') {
                if (!builder.toString().isEmpty()) {
                    node.add(this.tryGetNode(builder));
                }
                builder.delete(0, builder.length());
                continue;
            }
            if (c == ']') {
                if (builder.toString().isEmpty()) {
                    return node;
                }
                node.add(this.tryGetNode(builder));
                return node;
            }
            if (c == '\"') {
                stringStart = true;
                continue;
            }
            if (c == '[') {
                end = this.findArrayEnd(charList, i);
                if (end == -1) {
                    throw new RuntimeException("Here are no end for this array!");
                }
                array = this.getArrayFromObject(charList, i, end);
                node.add(this.arrayNodeProcessor(array.toString().toCharArray()));
                i = end;
                continue;
            }
            if (c == '{') {
                end = this.findMapEnd(charList, i);
                if (end == -1) {
                    throw new RuntimeException("Here are no end for this map!");
                }
                array = this.getMapFromObj(charList, i, end);
                node.add(this.mapNodeProcessor(array.toString().toCharArray()));
                i = end;
                continue;
            }
            builder.append(c);
        }
        return null;
    }

    private int findArrayEnd(char[] charList, int start) {
        return this.findDataNode(charList, start, '[', ']');
    }

    private StringBuilder getArrayFromObject(char[] charList, int start, int end) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < end + 1; ++i) {
            builder.append(charList[i]);
        }
        return builder;
    }

    private MapNode mapNodeProcessor(char[] charList) {
        MapNode node = new MapNode(new HashMap());
        StringBuilder builder = new StringBuilder();
        StringBuilder key = new StringBuilder();
        JsonNode valueNode = NullNode.INSTANCE;
        boolean stringStart = false;
        boolean keyEnd = false;
        for (int i = 1; i < charList.length; ++i) {
            StringBuilder array;
            int end;
            char c = charList[i];
            if (stringStart) {
                if (c != '\"') {
                    builder.append(c);
                    continue;
                }
                stringStart = false;
                if (!keyEnd) continue;
                valueNode = new StringNode(builder.toString());
                builder.delete(0, builder.length());
                continue;
            }
            if (c == ' ') continue;
            if (c == ':') {
                if (keyEnd) {
                    throw new RuntimeException("What up here? Its had two value?");
                }
                key.append((CharSequence)builder);
                builder.delete(0, builder.length());
                keyEnd = true;
                continue;
            }
            if (c == ',') {
                if (!keyEnd) {
                    throw new RuntimeException("Its a array bro.");
                }
                keyEnd = false;
                if (valueNode == NullNode.INSTANCE) {
                    valueNode = this.tryGetNode(builder);
                }
                node.put(key.toString(), valueNode);
                builder.delete(0, builder.length());
                key.delete(0, key.length());
                valueNode = NullNode.INSTANCE;
                continue;
            }
            if (c == '}') {
                if (valueNode == NullNode.INSTANCE) {
                    valueNode = this.tryGetNode(builder);
                }
                node.put(key.toString(), valueNode);
                return node;
            }
            if (c == '\"') {
                stringStart = true;
                continue;
            }
            if (c == '[') {
                end = this.findArrayEnd(charList, i);
                if (end == -1) {
                    throw new NullPointerException("Here are no end for this array!");
                }
                array = this.getArrayFromObject(charList, i, end);
                valueNode = this.arrayNodeProcessor(array.toString().toCharArray());
                i = end;
                continue;
            }
            if (c == '{') {
                end = this.findMapEnd(charList, i);
                if (end == -1) {
                    throw new NullPointerException("Here are no end for this map!");
                }
                array = this.getMapFromObj(charList, i, end);
                valueNode = this.mapNodeProcessor(array.toString().toCharArray());
                i = end;
                continue;
            }
            builder.append(c);
        }
        return null;
    }

    private int findMapEnd(char[] charList, int start) {
        return this.findDataNode(charList, start, '{', '}');
    }

    private StringBuilder getMapFromObj(char[] charList, int start, int end) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < end + 1; ++i) {
            builder.append(charList[i]);
        }
        return builder;
    }

    JsonNode<?> tryGetNode(StringBuilder builder) {
        String str = builder.toString();
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
            return new BooleanNode(str.equalsIgnoreCase("true"));
        }
        NumberType number = this.getNumber(str);
        if (number != null) {
            switch (number) {
                case Int: {
                    return new IntegerNode(Integer.parseInt(str));
                }
                case Float: {
                    return new FloatNode(Float.parseFloat(str));
                }
                case Double: {
                    return new DoubleNode(Double.parseDouble(str));
                }
            }
        }
        return new StringNode(str);
    }

    private NumberType getNumber(String str) {
        if (str.isEmpty()) {
            return null;
        }
        boolean has = false;
        boolean E = false;
        if (str.startsWith("-")) {
            str = str.replace("-", "");
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (c == '.') {
                if (has) {
                    return null;
                }
                has = true;
                continue;
            }
            if (c == 'E' || c == 'e') {
                if (E) {
                    return null;
                }
                E = true;
                continue;
            }
            if (c == 'd' || c == 'D') {
                if (i == str.length() - 1) {
                    return NumberType.Double;
                }
                return null;
            }
            if (c == 'f' || c == 'F') {
                if (i == str.length() - 1) {
                    return NumberType.Float;
                }
                return null;
            }
            return null;
        }
        if (has) {
            return NumberType.Double;
        }
        return NumberType.Int;
    }

    String fileReader(File file) {
        if (file.exists() && file.isFile()) {
            try {
                return new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    String streamReaderWithoutClose(InputStream stream) throws IOException {
        byte[] bytes = new byte[stream.available()];
        stream.read(bytes);
        return new String(bytes);
    }

    String streamReader(InputStream stream) throws IOException {
        byte[] bytes = new byte[stream.available()];
        stream.read(bytes);
        stream.close();
        return new String(bytes);
    }

    private int findDataNode(char[] charList, int start, char keyMapStart, char keyMapEnd) {
        int count = 0;
        for (int i = start; i < charList.length; ++i) {
            if (charList[i] == keyMapStart) {
                ++count;
            }
            if (charList[i] != keyMapEnd) continue;
            if (count == 1) {
                return i;
            }
            --count;
        }
        return -1;
    }

    private static enum NumberType {
        Int,
        Float,
        Double;

    }
}

