/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.json;

import club.someoneice.json.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PairList<A, B>
extends ArrayList<Pair<A, B>> {
    private static final long serialVersionUID = 2L;
    public final Set<Pair<A, B>> cache = new HashSet<Pair<A, B>>();

    public Pair<A, B> put(A key, B value) {
        Pair<A, B> pair = new Pair<A, B>(key, value);
        this.add(pair);
        return pair;
    }

    public Pair<A, B> put(Pair<A, B> pair) {
        this.add(pair);
        return pair;
    }

    @Deprecated
    public Pair<A, B> get(A key) {
        return this.getByKey(key);
    }

    public Pair<A, B> getByKey(A key) {
        this.checkUpdates();
        return this.cache.stream().filter(it -> it.getKey() == key).findFirst().orElse(null);
    }

    public Pair<A, B> getByValue(B value) {
        this.checkUpdates();
        return this.stream().filter(it -> it.getValue() == value).findFirst().orElse(null);
    }

    public Pair<A, B> at(int i) {
        return i < this.size() ? (Pair)this.get(i) : null;
    }

    public void replaceIf(Pair<A, B> pair, Predicate<? super Pair<A, B>> filter) {
        this.replaceIf(pair.getKey(), pair.getValue(), filter);
    }

    public void replaceIf(A key, B value, Predicate<? super Pair<A, B>> filter) {
        Objects.requireNonNull(filter);
        this.stream().filter(filter).forEach((? super T it) -> {
            it.setKey(key);
            it.setValue(value);
        });
    }

    public void setKeyIf(A key, Predicate<? super Pair<A, B>> filter) {
        Objects.requireNonNull(filter);
        this.stream().filter(filter).forEach((? super T it) -> it.setKey(key));
    }

    public void setValueIf(B value, Predicate<? super Pair<A, B>> filter) {
        Objects.requireNonNull(filter);
        this.stream().filter(filter).forEach((? super T it) -> it.setValue(value));
    }

    public List<Pair<A, B>> asList() {
        return new ArrayList<Pair<A, B>>(this);
    }

    public void replace(List<Pair<A, B>> list) {
        this.clear();
        this.addAll(list);
    }

    public HashMap<A, B> asMap() {
        HashMap map = new HashMap();
        this.forEach((? super E it) -> map.put(it.getKey(), it.getValue()));
        return map;
    }

    public <T extends Map<A, B>> T asMap(T map) {
        this.forEach((? super E it) -> map.put(it.getKey(), it.getValue()));
        return map;
    }

    public Iterator<Pair<A, B>> getIterator() {
        return this.iterator();
    }

    private void checkUpdates() {
        if (this.cache.size() == this.size()) {
            return;
        }
        this.cache.clear();
        this.cache.addAll(this);
    }
}

