/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.json.node;

import club.someoneice.json.api.TreeNode;
import club.someoneice.json.node.BooleanNode;
import club.someoneice.json.node.DoubleNode;
import club.someoneice.json.node.FloatNode;
import club.someoneice.json.node.IntegerNode;
import club.someoneice.json.node.JsonNode;
import club.someoneice.json.node.LongNode;
import club.someoneice.json.node.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class ArrayNode
extends JsonNode<List<JsonNode<?>>>
implements Iterable<JsonNode<?>>,
TreeNode<JsonNode<?>> {
    public ArrayNode(List<JsonNode<?>> obj) {
        super(obj);
    }

    public ArrayNode() {
        super(new ArrayList());
    }

    @Override
    public List<JsonNode<?>> getObj() {
        return (List)super.getObj();
    }

    @Override
    public JsonNode.NodeType getType() {
        return JsonNode.NodeType.Array;
    }

    public void addChild(JsonNode<?> ... child) {
        Arrays.stream(child).forEach(this::add);
    }

    public JsonNode<?> add(JsonNode<?> obj) {
        ((List)this.obj).add(obj);
        return obj;
    }

    public void addAll(List<JsonNode<?>> list) {
        ((List)this.obj).addAll(list);
    }

    public JsonNode<?> get(int i) {
        return (JsonNode)((List)this.obj).get(i);
    }

    public void clear() {
        ((List)this.obj).clear();
    }

    public boolean isEmpty() {
        return ((List)this.obj).isEmpty();
    }

    public boolean isNotEmpty() {
        return !((List)this.obj).isEmpty();
    }

    public Stream<JsonNode<?>> stream() {
        return ((List)this.obj).stream();
    }

    @Override
    public Iterator<JsonNode<?>> iterator() {
        return ((List)this.obj).iterator();
    }

    @Override
    public ArrayNode asTypeNode() {
        return this;
    }

    public ArrayNode copy() {
        return new ArrayNode(new ArrayList((Collection)this.obj));
    }

    public ArrayNode copy(ArrayNode node) {
        node.addAll((List<JsonNode<?>>)this.getObj());
        return node;
    }

    public ArrayNode copy(List<JsonNode<?>> list) {
        list.addAll((Collection)this.obj);
        return new ArrayNode(list);
    }

    public ArrayNode add(String str) {
        this.add(new StringNode(str));
        return this;
    }

    public ArrayNode add(int i) {
        this.add(new IntegerNode(i));
        return this;
    }

    public ArrayNode add(long l) {
        this.add(new LongNode(l));
        return this;
    }

    public ArrayNode add(double d) {
        this.add(new DoubleNode(d));
        return this;
    }

    public ArrayNode add(float f) {
        this.add(new FloatNode(f));
        return this;
    }

    public ArrayNode add(boolean b) {
        this.add(new BooleanNode(b));
        return this;
    }
}

