/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.json.node;

import club.someoneice.json.api.NodeLike;
import club.someoneice.json.api.exception.NodeCastException;
import club.someoneice.json.node.ArrayNode;
import club.someoneice.json.node.BooleanNode;
import club.someoneice.json.node.DoubleNode;
import club.someoneice.json.node.FloatNode;
import club.someoneice.json.node.IntegerNode;
import club.someoneice.json.node.LongNode;
import club.someoneice.json.node.MapNode;
import club.someoneice.json.node.NullNode;
import club.someoneice.json.node.StringNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class JsonNode<T>
implements NodeLike {
    protected final T obj;

    public JsonNode(T obj) {
        this.obj = obj;
    }

    @Override
    public NodeType getType() {
        if (this.obj == null || this instanceof NullNode) {
            return NodeType.Null;
        }
        if (this.obj instanceof Map || this instanceof MapNode) {
            return NodeType.Map;
        }
        if (this.obj instanceof List || this instanceof ArrayNode) {
            return NodeType.Array;
        }
        if (this.obj instanceof String) {
            return NodeType.String;
        }
        if (this.obj instanceof Boolean) {
            return NodeType.Boolean;
        }
        if (this.obj instanceof Integer) {
            return NodeType.Int;
        }
        if (this.obj instanceof Float) {
            return NodeType.Float;
        }
        if (this.obj instanceof Double) {
            return NodeType.Double;
        }
        if (this.obj instanceof Long) {
            return NodeType.Long;
        }
        if (this.obj instanceof Number) {
            return NodeType.Number;
        }
        return NodeType.Other;
    }

    public JsonNode asTypeNode() {
        switch (this.getType()) {
            case String: {
                return new StringNode((String)this.obj);
            }
            case Int: {
                return new IntegerNode((Integer)this.obj);
            }
            case Float: {
                return new FloatNode(((Float)this.obj).floatValue());
            }
            case Double: {
                return new DoubleNode((Double)this.obj);
            }
            case Long: {
                return new LongNode((Long)this.obj);
            }
            case Boolean: {
                return new BooleanNode((Boolean)this.obj);
            }
            case Map: {
                return new MapNode(new HashMap((Map)this.obj));
            }
            case Array: {
                return new ArrayNode(new ArrayList((List)this.obj));
            }
            case Null: {
                return NullNode.INSTANCE;
            }
            case Number: 
            case Other: {
                return this;
            }
        }
        return this;
    }

    public JsonNode asTypeNodeOrThrow(NodeType type, String message) {
        JsonNode node = this.asTypeNode();
        if (!node.typeOf(type)) {
            throw new NodeCastException(message);
        }
        return node;
    }

    public JsonNode asTypeNodeOrThrow(NodeType type) {
        return this.asTypeNodeOrThrow(type, "");
    }

    public <N extends JsonNode> N asTypeOrElse(NodeType type, Supplier<N> function) {
        JsonNode node = this.asTypeNode();
        return (N)(this.typeOf(type) ? node : (JsonNode)function.get());
    }

    public JsonNode asTypeOrNull(NodeType type) {
        JsonNode<T> node = this.asTypeNode();
        return this.typeOf(type) ? node : NullNode.INSTANCE;
    }

    public MapNode asMapNodeOrEmpty() {
        JsonNode node = this.asTypeNode();
        return node.typeOf(NodeType.Map) ? (MapNode)node : new MapNode();
    }

    public ArrayNode asArrayNodeOrEmpty() {
        JsonNode node = this.asTypeNode();
        return node.typeOf(NodeType.Array) ? (ArrayNode)node : new ArrayNode();
    }

    public JsonNode<?> copy() {
        return new JsonNode<T>(this.getObj());
    }

    public boolean typeOf(NodeType type) {
        return this.getType() == type;
    }

    public boolean isNull() {
        return this.typeOf(NodeType.Null) || this == NullNode.INSTANCE;
    }

    public boolean nonNull() {
        return !this.isNull();
    }

    public T getObj() {
        return this.obj;
    }

    public String toString() {
        return this.obj.toString();
    }

    public boolean equals(Object obj) {
        return obj.getClass().equals(this.getClass()) && this.obj.equals(obj);
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    public JsonNode asJsonNode() {
        return this.asTypeNode();
    }

    public static JsonNode asJsonNodeOrEmpty(Object obj) {
        if (obj instanceof NodeLike) {
            return ((NodeLike)obj).asJsonNode();
        }
        JsonNode<Object> node = new JsonNode<Object>(obj);
        return node.getType() == NodeType.Other ? NullNode.INSTANCE : node;
    }

    public static enum NodeType {
        Null,
        String,
        Int,
        Float,
        Double,
        Boolean,
        Map,
        Array,
        Number,
        Long,
        Other;

    }
}

