/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.json.processor;

import club.someoneice.json.Pair;
import club.someoneice.json.PairList;
import club.someoneice.json.api.IJson5Bean;
import club.someoneice.json.node.JsonNode;
import club.someoneice.json.node.NullNode;
import club.someoneice.json.node.StringNode;
import club.someoneice.json.processor.JsonBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Json5Builder {
    private final List<IJson5Bean> taskTable = new ArrayList<IJson5Bean>();

    public Json5Builder create() {
        return new Json5Builder();
    }

    public void put(IJson5Bean bean) {
        this.taskTable.add(bean);
    }

    public void clearTask() {
        this.taskTable.clear();
    }

    public boolean noTask() {
        return this.taskTable.isEmpty();
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        this.taskTable.forEach(it -> builder.append(this.build((IJson5Bean)it, 0)));
        return builder.toString();
    }

    private String build(IJson5Bean bean, int ct) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (!bean.isMap()) {
            this.arrayBuilder(builder, ct, bean);
        } else {
            this.mapBuilder(builder, ct, bean);
        }
        return builder.toString();
    }

    private void arrayBuilder(StringBuilder builder, int ct, IJson5Bean bean) {
        int i;
        Iterator<Pair<IJson5Bean.COMMAND, JsonNode<?>>> iterator = bean.getTask().getIterator();
        int count = 1 + ct;
        for (i = 0; i < count - 1; ++i) {
            builder.append("    ");
        }
        builder.append("[");
        while (iterator.hasNext()) {
            int i2;
            Pair<IJson5Bean.COMMAND, JsonNode<?>> pair = iterator.next();
            for (i2 = 0; i2 < count; ++i2) {
                builder.append("    ");
            }
            this.arrayCommand(iterator, builder, pair, count);
            for (i2 = 0; i2 < count - 1; ++i2) {
                builder.append("    ");
            }
        }
        builder.append("\n");
        for (i = 0; i < count - 1; ++i) {
            builder.append("    ");
        }
        builder.append("]");
    }

    private void arrayCommand(Iterator<Pair<IJson5Bean.COMMAND, JsonNode<?>>> iterator, StringBuilder builder, Pair<IJson5Bean.COMMAND, JsonNode<?>> pair, int count) {
        switch (pair.getKey()) {
            case NODE: {
                builder.append("\n");
                builder.append(JsonBuilder.prettyPrint(JsonBuilder.asString(pair.getValue()), count));
                if (!iterator.hasNext()) break;
                builder.append(",");
                break;
            }
            case COMMIT: {
                builder.append("\n");
                builder.append("//").append(pair.getValue().toString());
                break;
            }
            case LINE: {
                builder.append("\n");
                break;
            }
            case MAP: 
            case ARRAY: {
                builder.append("\n");
                builder.append(this.build((IJson5Bean)((Object)pair.getValue()), count));
                if (!iterator.hasNext()) break;
                builder.append(",");
            }
        }
    }

    private void mapBuilder(StringBuilder builder, int ct, IJson5Bean bean) {
        int i;
        Iterator<Pair<IJson5Bean.COMMAND, Pair<String, JsonNode<?>>>> iterator = bean.getTask().getIterator();
        int count = 1 + ct;
        for (i = 0; i < count - 1; ++i) {
            builder.append("    ");
        }
        builder.append("{");
        while (iterator.hasNext()) {
            Pair<IJson5Bean.COMMAND, Pair<String, JsonNode<?>>> cmdPair = iterator.next();
            this.mapCommand(iterator, builder, cmdPair, count);
            for (int i2 = 0; i2 < count - 1; ++i2) {
                builder.append("    ");
            }
        }
        builder.append("\n");
        for (i = 0; i < count - 1; ++i) {
            builder.append("    ");
        }
        builder.append("}");
    }

    private void mapCommand(Iterator<Pair<IJson5Bean.COMMAND, Pair<String, JsonNode<?>>>> iterator, StringBuilder builder, Pair<IJson5Bean.COMMAND, Pair<String, JsonNode<?>>> pair, int count) {
        switch (pair.getKey()) {
            case NODE: {
                builder.append("\n");
                for (int i = 0; i < count; ++i) {
                    builder.append("    ");
                }
                builder.append(pair.getValue().getKey()).append(": ");
                if (pair.getValue().getValue().getType() == JsonNode.NodeType.Array || pair.getValue().getValue().getType() == JsonNode.NodeType.Map) {
                    builder.append(this.prettyPrintWithoutFirstLine(JsonBuilder.asString(pair.getValue().getValue()), count));
                } else {
                    builder.append(JsonBuilder.prettyPrint(JsonBuilder.asString(pair.getValue().getValue())));
                }
                if (!iterator.hasNext()) break;
                builder.append(",");
                break;
            }
            case COMMIT: {
                builder.append("\n");
                for (int i = 0; i < count; ++i) {
                    builder.append("    ");
                }
                builder.append("//").append(pair.getValue().getKey());
                break;
            }
            case LINE: {
                builder.append("\n");
                break;
            }
            case MAP: 
            case ARRAY: {
                builder.append("\n");
                for (int i = 0; i < count; ++i) {
                    builder.append("    ");
                }
                builder.append(pair.getValue().getKey()).append(": ").append(this.build((IJson5Bean)((Object)pair.getValue().getValue()), count));
                if (!iterator.hasNext()) break;
                builder.append(",");
            }
        }
    }

    public ArrayBean getArrayBean() {
        return new ArrayBean();
    }

    public ObjectBean getObjectBean() {
        return new ObjectBean();
    }

    String prettyPrintWithoutFirstLine(String node, int ct) {
        StringBuilder builder = new StringBuilder();
        int count = ct + 1;
        char[] charList = node.toCharArray();
        builder.append(charList[0]);
        builder.append("\n");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                builder.append("    ");
            }
        }
        for (int o = 1; o < charList.length; ++o) {
            char c = charList[o];
            count = JsonBuilder.checkAndPut(builder, count, c);
        }
        return builder.toString();
    }

    public static final class ObjectBean
    extends NullNode
    implements IJson5Bean {
        private final PairList<IJson5Bean.COMMAND, Pair<String, JsonNode<?>>> commandSet = new PairList();

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public Object getObj() {
            return this.commandSet.clone();
        }

        @Override
        public void clean() {
            this.commandSet.clear();
        }

        public PairList<IJson5Bean.COMMAND, Pair<String, JsonNode<?>>> getTask() {
            return this.commandSet;
        }

        public ObjectBean put(String key, JsonNode<?> obj) {
            this.commandSet.put(IJson5Bean.COMMAND.NODE, new Pair(key, obj));
            return this;
        }

        public ObjectBean addNote(String note) {
            this.commandSet.put(IJson5Bean.COMMAND.COMMIT, new Pair<String, NullNode>(note, NullNode.INSTANCE));
            return this;
        }

        public ObjectBean enterLine() {
            this.commandSet.put(IJson5Bean.COMMAND.LINE, new Pair<String, NullNode>("null", NullNode.INSTANCE));
            return this;
        }

        public ObjectBean addBean(String key, ArrayBean bean) {
            this.commandSet.put(IJson5Bean.COMMAND.ARRAY, new Pair<String, ArrayBean>(key, bean));
            return this;
        }

        public ObjectBean addBean(String key, ObjectBean bean) {
            this.commandSet.put(IJson5Bean.COMMAND.MAP, new Pair<String, ObjectBean>(key, bean));
            return this;
        }
    }

    public static final class ArrayBean
    extends NullNode
    implements IJson5Bean {
        private final PairList<IJson5Bean.COMMAND, JsonNode<?>> commandSet = new PairList();

        @Override
        public Object getObj() {
            return this.commandSet.clone();
        }

        @Override
        public boolean isMap() {
            return false;
        }

        @Override
        public void clean() {
            this.commandSet.clear();
        }

        public PairList<IJson5Bean.COMMAND, JsonNode<?>> getTask() {
            return this.commandSet;
        }

        public ArrayBean add(JsonNode<?> obj) {
            this.commandSet.put(IJson5Bean.COMMAND.NODE, obj);
            return this;
        }

        public ArrayBean addNote(String note) {
            this.commandSet.put(IJson5Bean.COMMAND.COMMIT, new StringNode(note));
            return this;
        }

        public ArrayBean enterLine() {
            this.commandSet.put(IJson5Bean.COMMAND.LINE, NullNode.INSTANCE);
            return this;
        }

        public ArrayBean addBean(ArrayBean bean) {
            this.commandSet.put(IJson5Bean.COMMAND.ARRAY, bean);
            return this;
        }

        public ArrayBean addBean(ObjectBean bean) {
            this.commandSet.put(IJson5Bean.COMMAND.MAP, bean);
            return this;
        }
    }
}

