/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.json.processor;

import club.someoneice.json.node.ArrayNode;
import club.someoneice.json.node.JsonNode;
import club.someoneice.json.node.MapNode;
import java.util.Iterator;

public class JsonBuilder {
    private JsonBuilder() {
    }

    public static String prettyPrint(JsonNode<?> node) {
        return JsonBuilder.prettyPrint(JsonBuilder.asString(node));
    }

    public static String prettyPrint(String node) {
        return JsonBuilder.prettyPrint(node, 0);
    }

    public static String asString(JsonNode<?> node) {
        StringBuilder builder = new StringBuilder();
        if (node.getType() == JsonNode.NodeType.Array) {
            ArrayNode array = (ArrayNode)node;
            builder.append("[");
            Iterator<JsonNode<?>> itor = array.getObj().iterator();
            JsonBuilder.whileToBuildNode(builder, itor);
            builder.append("]");
        } else if (node.getType() == JsonNode.NodeType.Map) {
            MapNode map = (MapNode)node;
            builder.append("{");
            Iterator<String> itor = map.getObj().keySet().iterator();
            JsonBuilder.whileToBuildString(builder, itor, map);
            builder.append("}");
        } else if (node.getType() == JsonNode.NodeType.String) {
            builder.append("\"").append(node).append("\"");
        } else {
            builder.append(node.getObj().toString());
        }
        return builder.toString();
    }

    public static String prettyPrint(String node, int ct) {
        StringBuilder builder = new StringBuilder();
        int count = ct;
        boolean rawInput = false;
        boolean skinNext = false;
        char[] charList = node.toCharArray();
        for (int i = 0; i < count; ++i) {
            builder.append("    ");
        }
        for (char c : charList) {
            if (skinNext) {
                builder.append(c);
                skinNext = false;
                continue;
            }
            if (c == '\"') {
                boolean bl = rawInput = !rawInput;
            }
            if (rawInput) {
                skinNext = c == '\\';
                builder.append(c);
                continue;
            }
            count = JsonBuilder.checkAndPut(builder, count, c);
        }
        return builder.toString();
    }

    static int checkAndPut(StringBuilder builder, int count, char c) {
        switch (c) {
            case ',': {
                builder.append(c).append("\n");
                for (int i = 0; i < count; ++i) {
                    builder.append("    ");
                }
                break;
            }
            case '[': 
            case '{': {
                builder.append(c).append("\n");
                ++count;
                for (int i = 0; i < count; ++i) {
                    builder.append("    ");
                }
                break;
            }
            case ']': 
            case '}': {
                --count;
                builder.append("\n");
                for (int i = 0; i < count; ++i) {
                    builder.append("    ");
                }
                builder.append(c);
                break;
            }
            case ':': {
                builder.append(c).append(" ");
                break;
            }
            default: {
                builder.append(c);
            }
        }
        return count;
    }

    private static void whileToBuildNode(StringBuilder builder, Iterator<JsonNode<?>> itor) {
        while (itor.hasNext()) {
            JsonNode<?> it = itor.next();
            JsonBuilder.createAndAppend(builder, it, itor.hasNext());
        }
    }

    private static void whileToBuildString(StringBuilder builder, Iterator<String> itor, MapNode map) {
        while (itor.hasNext()) {
            String key = itor.next();
            JsonNode<?> value = map.get(key);
            builder.append(String.format("\"%s\"", key)).append(":");
            JsonBuilder.createAndAppend(builder, value, itor.hasNext());
        }
    }

    private static void createAndAppend(StringBuilder builder, JsonNode<?> it, boolean b) {
        if (it.getType() == JsonNode.NodeType.Array || it.getType() == JsonNode.NodeType.Map) {
            builder.append(JsonBuilder.asString(it));
        } else if (it.getType() == JsonNode.NodeType.String) {
            builder.append("\"").append(it).append("\"");
        } else {
            builder.append(it.getObj());
        }
        if (b) {
            builder.append(",");
        }
    }
}

