/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.minepulse.core;

import club.someoneice.minepulse.core.OreMark;
import club.someoneice.minepulse.core.ServerConfig;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2431;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class MinePulse
implements ModInitializer {
    public static final Map<String, Boolean> PLAYER_STATE = Maps.newConcurrentMap();
    public static final class_2960 S2CSoundPacket = new class_2960("minepulse:sendsound");
    public static final class_2960 C2SPlaceStateIn = new class_2960("minepulse:playerstate");

    public void onInitialize() {
        try {
            ServerConfig.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2SPlaceStateIn, (server, player, packetImpl, buff, sender) -> PLAYER_STATE.put(player.method_5476().getString(), buff.readBoolean()));
    }

    public static void logHook(class_1657 player, class_3218 world, class_2338 pos) {
        HashSet blockPos = Sets.newHashSet();
        Stack<class_2338> blockPosStack = new Stack<class_2338>();
        class_2248 blockMark = world.method_8320(pos).method_26204();
        int cache = 0;
        blockPos.add(pos);
        blockPosStack.push(pos);
        while (!(blockPosStack.empty() || ServerConfig.maxSizeCache != -1 && cache >= ServerConfig.maxSizeCache)) {
            class_2338 posIn = (class_2338)blockPosStack.pop();
            for (class_2338 offset : class_2338.method_10094((int)-1, (int)0, (int)-1, (int)1, (int)1, (int)1)) {
                class_2338 posAt = posIn.method_10081((class_2382)offset);
                if (blockPos.contains(posAt) || !world.method_8320(posAt).method_27852(blockMark)) continue;
                ++cache;
                blockPos.add(posAt);
                blockPosStack.push(posAt);
            }
        }
        MinePulse.billing(blockPos, player, world, pos);
    }

    public static void oreHook(class_1657 player, class_3218 world, class_2338 pos, OreMark mark) {
        HashSet blockPos = Sets.newHashSet();
        Stack<class_2338> blockPosStack = new Stack<class_2338>();
        int cache = 0;
        blockPos.add(pos);
        blockPosStack.push(pos);
        while (!(blockPosStack.empty() || ServerConfig.maxSizeCache != -1 && cache >= ServerConfig.maxSizeCache)) {
            class_2338 posIn = (class_2338)blockPosStack.pop();
            for (class_2350 value : class_2350.values()) {
                class_2338 posAt = posIn.method_10093(value);
                class_2680 state = world.method_8320(posAt);
                if (blockPos.contains(posAt) || !mark.mark(state)) continue;
                ++cache;
                blockPos.add(posAt);
                blockPosStack.push(posAt);
            }
        }
        MinePulse.billing(blockPos, player, world, pos);
    }

    private static void billing(Set<class_2338> blockPos, class_1657 player, class_3218 world, class_2338 pos) {
        int[] posYs = blockPos.stream().mapToInt(class_2382::method_10264).distinct().filter(it -> it != pos.method_10264()).toArray();
        int max = Arrays.stream(posYs).max().orElseGet(() -> ((class_2338)pos).method_10264());
        int min = Arrays.stream(posYs).min().orElseGet(() -> ((class_2338)pos).method_10264());
        int fin = max < pos.method_10264() ? Math.min(min, pos.method_10264()) : max;
        HashMap posMap = Maps.newHashMap();
        blockPos.stream().filter(it -> it.method_10264() == fin && it != pos).forEach(it -> posMap.put(MinePulse.dis(pos, it), it));
        class_2338 finalPos = !posMap.isEmpty() ? (class_2338)posMap.get(posMap.keySet().stream().max(Comparator.naturalOrder()).get()) : pos;
        MinePulse.breakBlock(finalPos, world.method_8320(finalPos), world, player, pos);
    }

    private static int dis(class_2338 A, class_2338 B) {
        return Math.abs(A.method_10263() - B.method_10263()) + Math.abs(A.method_10260() - B.method_10260());
    }

    private static void pushToPlayer(class_1542 itemEntity, class_1657 player) {
        class_243 playerPos = player.method_19538();
        class_243 entityPos = itemEntity.method_19538();
        itemEntity.method_5762((playerPos.field_1352 - entityPos.field_1352) * 0.1, (playerPos.field_1351 - entityPos.field_1351) * 0.1, (playerPos.field_1350 - entityPos.field_1350) * 0.1);
    }

    private static class_243 getRealVec(class_1657 player, class_2338 pos) {
        double offsetX;
        double offsetY;
        class_243 vec = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        class_2338 posOn = player.method_24515();
        double d = posOn.method_10264() < pos.method_10264() ? (pos.method_10264() - posOn.method_10264() >= 2 ? -0.7 : 0.0) : (offsetY = 0.7);
        double d2 = posOn.method_10263() != pos.method_10263() ? (posOn.method_10263() > pos.method_10263() ? 0.7 : -0.7) : (offsetX = 0.0);
        double offsetZ = posOn.method_10260() != pos.method_10260() ? (posOn.method_10260() > pos.method_10260() ? 0.7 : -0.7) : 0.0;
        return vec.method_1031(offsetX, offsetY, offsetZ);
    }

    private static void breakBlock(class_2338 pos, class_2680 state, class_3218 world, class_1657 player, class_2338 oPos) {
        class_1799 item = player.method_6047();
        item.method_7952((class_1937)world, state, pos, player);
        class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, null, (class_1297)player, (class_1799)item.method_7972()).forEach(itemStack -> {
            class_243 vc = MinePulse.getRealVec(player, oPos);
            class_1542 entity = new class_1542((class_1937)world, vc.method_10216(), vc.method_10214(), vc.method_10215(), itemStack);
            entity.method_6988();
            world.method_8649((class_1297)entity);
            MinePulse.pushToPlayer(entity, player);
        });
        if (state.method_26204() instanceof class_2431) {
            ((class_2431)state.method_26204()).method_9565(state, world, pos, item);
        }
        for (class_3222 serverPlayer : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)S2CSoundPacket, (class_2540)PacketByteBufs.create().method_10807(pos));
        }
        world.method_8650(pos, false);
    }
}

