/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.minepulse.core;

import club.someoneice.json.JSON;
import club.someoneice.json.node.ArrayNode;
import club.someoneice.json.node.IntegerNode;
import club.someoneice.json.node.JsonNode;
import club.someoneice.json.node.MapNode;
import club.someoneice.json.node.StringNode;
import club.someoneice.json.processor.JsonBuilder;
import club.someoneice.minepulse.core.OreMark;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public final class ServerConfig {
    public static final Set<OreMark> ORE_MARKS = Sets.newHashSet();
    public static final Set<OreMark> TREE_MARKS = Sets.newHashSet();
    public static int maxSizeCache = 1024;

    public static void read() throws IOException {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "minepulse_common.json");
        ServerConfig.checkFile(file);
        MapNode node = JSON.json.parse(file).asMapNodeOrEmpty();
        ArrayNode ores = node.get("ores").asArrayNodeOrEmpty();
        ArrayNode trees = node.get("trees").asArrayNodeOrEmpty();
        ServerConfig.foreach(ores, ORE_MARKS);
        ServerConfig.foreach(trees, TREE_MARKS);
        maxSizeCache = node.has("maxSizeCache") ? (Integer)node.get("maxSizeCache").getObj() : maxSizeCache;
    }

    private static void write(File file) throws IOException {
        ArrayNode node = new ArrayNode();
        node.add(ServerConfig.to("#minecraft:coal_ores"));
        node.add(new ArrayNode((List<JsonNode<?>>)ImmutableList.of((Object)ServerConfig.to("#minecraft:copper_ores"), (Object)ServerConfig.to("#c:storage_blocks/raw_copper"))));
        node.add(new ArrayNode((List<JsonNode<?>>)ImmutableList.of((Object)ServerConfig.to("#minecraft:iron_ores"), (Object)ServerConfig.to("#c:storage_blocks/raw_iron"))));
        node.add(new ArrayNode((List<JsonNode<?>>)ImmutableList.of((Object)ServerConfig.to("#minecraft:gold_ores"), (Object)ServerConfig.to("#c:storage_blocks/raw_gold"))));
        node.add(ServerConfig.to("#minecraft:redstone_ores"));
        node.add(ServerConfig.to("#minecraft:diamond_ores"));
        node.add(ServerConfig.to("#minecraft:emerald_ores"));
        node.add(ServerConfig.to("#minecraft:lapis_ores"));
        node.add(ServerConfig.to("#minecraft:nether_quartz_ore"));
        node.add(ServerConfig.to("#minecraft:ancient_debris"));
        node.add(ServerConfig.to("#c:ores/netherite_scrap"));
        node.add(new ArrayNode((List<JsonNode<?>>)ImmutableList.of((Object)ServerConfig.to("minecraft:mushroom_stem"), (Object)ServerConfig.to("minecraft:red_mushroom_block"), (Object)ServerConfig.to("minecraft:brown_mushroom_block"))));
        ArrayNode treeNode = new ArrayNode((List<JsonNode<?>>)ImmutableList.of((Object)ServerConfig.to("#minecraft:logs")));
        node.add(ServerConfig.to("#c:ores/bauxite"));
        node.add(ServerConfig.to("#c:ores/cinnabar"));
        node.add(ServerConfig.to("#c:ores/galena"));
        node.add(ServerConfig.to("#c:ores/iridium"));
        node.add(ServerConfig.to("#c:ores/lead"));
        node.add(ServerConfig.to("#c:ores/peridot"));
        node.add(ServerConfig.to("#c:ores/pyrite"));
        node.add(ServerConfig.to("#c:ores/ruby"));
        node.add(ServerConfig.to("#c:ores/sapphire"));
        node.add(ServerConfig.to("#c:ores/sheldonite"));
        node.add(ServerConfig.to("#c:ores/silver"));
        node.add(ServerConfig.to("#c:ores/sodalite"));
        node.add(ServerConfig.to("#c:ores/sphalerite"));
        node.add(ServerConfig.to("#c:ores/tin"));
        node.add(ServerConfig.to("#c:ores/tungsten"));
        node.add(ServerConfig.to("#c:desh_ores"));
        node.add(ServerConfig.to("#c:storage_blocks/raw_desh"));
        node.add(ServerConfig.to("#c:ice_shard_ores"));
        node.add(ServerConfig.to("#c:ostrum_ores"));
        node.add(ServerConfig.to("#c:calorite_ores"));
        if (FabricLoader.getInstance().isModLoaded("create")) {
            node.addAll((List<JsonNode<?>>)ImmutableList.of((Object)ServerConfig.to("#c:zinc_ores"), (Object)ServerConfig.to("#c:storage_blocks/raw_zinc")));
        }
        if (FabricLoader.getInstance().isModLoaded("ad_astra")) {
            node.add(ServerConfig.to("ad_astra:moon_cheese_ore"));
        }
        if (FabricLoader.getInstance().isModLoaded("anvilcraft")) {
            node.addAll((List<JsonNode<?>>)ImmutableList.of((Object)ServerConfig.to("#c:tin_ores"), (Object)ServerConfig.to("#c:titanium_ores"), (Object)ServerConfig.to("#c:tungsten_ores"), (Object)ServerConfig.to("#c:lead_ores"), (Object)ServerConfig.to("#c:silver_ores"), (Object)ServerConfig.to("#c:uranium_ores"), (Object)ServerConfig.to("anvilcraft:void_stone"), (Object)ServerConfig.to("anvilcraft:earth_core_shard_ore")));
        }
        if (FabricLoader.getInstance().isModLoaded("ae2")) {
            node.add(ServerConfig.to("#c:certus_quartz_ores"));
        }
        MapNode out = new MapNode();
        out.put("ores", node);
        out.put("trees", treeNode);
        out.put("maxSizeCache", new IntegerNode(1024));
        String data = JsonBuilder.prettyPrint(out);
        Files.write(file.toPath(), data.getBytes(), new OpenOption[0]);
    }

    private static void checkFile(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            return;
        }
        if (!file.createNewFile()) {
            throw new RuntimeException("Cannot create the config file!");
        }
        ServerConfig.write(file);
    }

    private static void foreach(ArrayNode nodeArray, Set<OreMark> mark) {
        for (JsonNode<?> node : nodeArray) {
            mark.add(node.getType() == JsonNode.NodeType.String ? ServerConfig.make((StringNode)node.asTypeNode()) : ServerConfig.make(node.asArrayNodeOrEmpty()));
        }
    }

    private static OreMark make(ArrayNode node) {
        HashSet tags = Sets.newHashSet();
        HashSet blocks = Sets.newHashSet();
        node.forEach(it -> {
            String dat = it.toString();
            if (dat.startsWith("#")) {
                tags.add(ServerConfig.createTag(dat));
            } else {
                blocks.add(ServerConfig.createBlock(dat));
            }
        });
        return new OreMark(tags, blocks);
    }

    private static OreMark make(StringNode ore) {
        String dat = ore.toString();
        return dat.startsWith("#") ? new OreMark((Set<class_3494<class_2248>>)ImmutableSet.of(ServerConfig.createTag(dat)), (Set<class_2248>)ImmutableSet.of()) : new OreMark((Set<class_3494<class_2248>>)ImmutableSet.of(), (Set<class_2248>)ImmutableSet.of((Object)ServerConfig.createBlock(dat)));
    }

    private static class_3494<class_2248> createTag(String str) {
        return TagRegistry.block((class_2960)new class_2960(str.substring(1)));
    }

    private static class_2248 createBlock(String str) {
        return (class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)str));
    }

    private static StringNode to(String str) {
        return new StringNode(str);
    }
}

