/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat;

import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.client.renderer.entity.GoatEntityRenderer;
import com.momosoftworks.coldsweat.common.capability.DummyCapStorage;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.common.capability.shearing.IShearableCap;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.command.argument.TempAttributeTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TemperatureTraitArgument;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigUpdater;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ActivityInit;
import com.momosoftworks.coldsweat.core.init.AttributeInit;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.core.init.ContainerInit;
import com.momosoftworks.coldsweat.core.init.EffectInit;
import com.momosoftworks.coldsweat.core.init.EntityInit;
import com.momosoftworks.coldsweat.core.init.FeatureInit;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.init.MemoryInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.init.PotionInit;
import com.momosoftworks.coldsweat.core.init.SensorTypeInit;
import com.momosoftworks.coldsweat.core.init.SoundInit;
import com.momosoftworks.coldsweat.core.itemgroup.InsulationItemsGroup;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="cold_sweat")
public class ColdSweat {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cold Sweat");
    public static final String MOD_ID = "cold_sweat";

    public ColdSweat() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::registerCaps);
        bus.addListener(this::updateConfigs);
        if (CompatManager.isCuriosLoaded()) {
            bus.addListener(this::registerCurioSlots);
        }
        BlockInit.BLOCKS.register(bus);
        ItemInit.ITEMS.register(bus);
        EntityInit.ENTITY_TYPES.register(bus);
        BlockEntityInit.BLOCK_ENTITY_TYPES.register(bus);
        ContainerInit.MENU_TYPES.register(bus);
        EffectInit.EFFECTS.register(bus);
        ParticleTypesInit.PARTICLES.register(bus);
        PotionInit.POTIONS.register(bus);
        SoundInit.SOUNDS.register(bus);
        FeatureInit.FEATURES.register(bus);
        AttributeInit.ATTRIBUTES.register(bus);
        ActivityInit.ACTIVITIES.register(bus);
        SensorTypeInit.SENSORS.register(bus);
        MemoryInit.MEMORIES.register(bus);
        ConfigUpdater.updateFileNames();
        WorldSettingsConfig.setup();
        ItemSettingsConfig.setup();
        MainSettingsConfig.setup();
        ClientSettingsConfig.setup();
        EntitySettingsConfig.setup();
        CompatManager.registerEventHandlers();
    }

    public static String getVersion() {
        return ConfigUpdater.getVersionString(((ModContainer)ModList.get().getModContainerById(MOD_ID).get()).getModInfo().getVersion());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ColdSweatPacketHandler.init();
        event.enqueueWork(() -> {
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.TEMPERATURE_CHANGED);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.SOUL_LAMP_FUELLED);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.BLOCK_AFFECTS_TEMP);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)ModAdvancementTriggers.ARMOR_INSULATED);
            InsulationItemsGroup.INSULATION_ITEMS.register();
            ArgumentTypes.func_218136_a((String)"temperature", TemperatureTraitArgument.class, (IArgumentSerializer)new TemperatureTraitArgument.Serializer());
            ArgumentTypes.func_218136_a((String)"temp_attribute", TempAttributeTraitArgument.class, (IArgumentSerializer)new TempAttributeTraitArgument.Serializer());
            ArgumentTypes.func_218136_a((String)"temp_modifier", TempModifierTraitArgument.class, (IArgumentSerializer)new TempModifierTraitArgument.Serializer());
        });
    }

    public void registerCaps(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITemperatureCap.class, new DummyCapStorage(), EntityTempCap::new);
        CapabilityManager.INSTANCE.register(IShearableCap.class, new DummyCapStorage(), ShearableFurCap::new);
        CapabilityManager.INSTANCE.register(IInsulatableCap.class, new DummyCapStorage(), ItemInsulationCap::new);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.SOUL_STALK, (RenderType)RenderType.func_228641_d_());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CHAMELEON, ChameleonEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.GOAT, GoatEntityRenderer::new);
    }

    public void updateConfigs(FMLLoadCompleteEvent event) {
        ConfigUpdater.updateConfigs();
    }

    public void registerCurioSlots(InterModEnqueueEvent event) {
        event.enqueueWork(() -> InterModComms.sendTo((String)MOD_ID, (String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build()));
    }
}

