/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.init;

import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;

public class GatherDefaultTempModifiersEvent
extends Event {
    private final List<TempModifier> modifiers;
    private final LivingEntity entity;
    private final Temperature.Trait trait;

    public GatherDefaultTempModifiersEvent(LivingEntity entity, Temperature.Trait trait) {
        this.entity = entity;
        this.trait = trait;
        this.modifiers = new ArrayList<TempModifier>(Temperature.getModifiers(entity, trait));
    }

    public List<TempModifier> getModifiers() {
        return this.modifiers;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public Temperature.Trait getTrait() {
        return this.trait;
    }

    public void addModifier(TempModifier modifier) {
        this.modifiers.add(modifier);
    }

    public void addModifiers(List<TempModifier> modifiers) {
        this.modifiers.addAll(modifiers);
    }

    public void addModifier(TempModifier modifier, Placement.Duplicates duplicatePolicy, Placement params) {
        Temperature.addModifier(this.modifiers, modifier, duplicatePolicy, 1, params);
    }

    public void addModifiers(List<TempModifier> modifiers, Placement.Duplicates duplicatePolicy, Placement params) {
        for (int i = modifiers.size() - 1; i >= 0; --i) {
            this.addModifier(modifiers.get(i), duplicatePolicy, params);
        }
    }

    public void addModifierById(ResourceLocation id, Consumer<TempModifier> modifierBuilder, Placement.Duplicates duplicatePolicy, Placement params) {
        TempModifierRegistry.getValue(id).ifPresent(mod -> {
            modifierBuilder.accept((TempModifier)mod);
            this.addModifier((TempModifier)mod, duplicatePolicy, params);
        });
    }

    public void removeModifiers(TempModifier modifier, Placement.Duplicates matchPolicy) {
        this.modifiers.removeIf(mod -> Placement.Duplicates.check(matchPolicy, mod, modifier));
    }
}

