/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import java.util.Collection;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.eventbus.api.Event;

public abstract class CreateRegistriesEvent
extends Event {
    DynamicRegistries registryAccess;
    Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> registries;

    public CreateRegistriesEvent(DynamicRegistries registryAccess, Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> registries) {
        this.registryAccess = registryAccess;
        this.registries = registries;
    }

    public DynamicRegistries getRegistryAccess() {
        return this.registryAccess;
    }

    public Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> getRegistries() {
        return this.registries;
    }

    public <T extends ConfigData> Collection<T> getRegistry(ModRegistries.ConfigRegistry<T> key) {
        return this.registries.get(key.key());
    }

    public static class Post
    extends CreateRegistriesEvent {
        public Post(DynamicRegistries registryAccess, Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> registries) {
            super(registryAccess, registries);
        }
    }

    public static class Pre
    extends CreateRegistriesEvent {
        private Multimap<RegistryKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals;

        public Pre(DynamicRegistries registryAccess, Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> registries, Multimap<RegistryKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals) {
            super(registryAccess, registries);
        }

        public Multimap<RegistryKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> getRegistryRemovals() {
            return ImmutableMultimap.copyOf(this.removals);
        }
    }
}

