/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation.slot;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public abstract class ScalingFormula
implements NbtSerializable {
    Type scaling;

    protected ScalingFormula(Type scaling) {
        this.scaling = scaling;
    }

    public abstract int getSlots(EquipmentSlotType var1, ItemStack var2);

    public abstract List<? extends Number> getValues();

    public Type getType() {
        return this.scaling;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("scaling", this.scaling.func_176610_l());
        return tag;
    }

    public static ScalingFormula deserialize(CompoundNBT nbt) {
        Type scaling = Type.byName(nbt.func_74779_i("scaling"));
        switch (scaling) {
            case STATIC: {
                return Static.deserialize(nbt);
            }
        }
        return Dynamic.deserialize(nbt);
    }

    public static enum Type implements StringRepresentable
    {
        STATIC("static"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        final String name;
        public static final Codec<Type> CODEC;

        private Type(String name) {
            this.name = name;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown insulation scaling: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(Type::byName, Type::func_176610_l);
        }
    }

    public static class Dynamic
    extends ScalingFormula {
        double factor;
        double max;

        public Dynamic(Type scaling, double factor, double max) {
            super(scaling);
            this.factor = factor;
            this.max = max;
        }

        @Override
        public int getSlots(EquipmentSlotType slot, ItemStack stack) {
            double protection = stack.func_111283_C(slot).get((Object)Attributes.field_233826_i_).stream().findFirst().map(mod -> mod.func_111164_d()).orElse(0.0);
            switch (this.scaling) {
                case LINEAR: {
                    return (int)CSMath.clamp(Math.floor(protection * this.factor), 0.0, this.max);
                }
                case EXPONENTIAL: {
                    return (int)CSMath.clamp(Math.floor(Math.pow(protection, this.factor)), 0.0, this.max);
                }
                case LOGARITHMIC: {
                    return (int)CSMath.clamp(Math.floor(Math.sqrt(protection) * this.factor), 0.0, this.max);
                }
            }
            return 0;
        }

        @Override
        public List<? extends Number> getValues() {
            return Arrays.asList(this.factor, this.max);
        }

        public static Dynamic deserialize(CompoundNBT nbt) {
            return new Dynamic(Type.byName(nbt.func_74779_i("scaling")), nbt.func_74769_h("factor"), nbt.func_74769_h("max"));
        }

        @Override
        public CompoundNBT serialize() {
            CompoundNBT tag = super.serialize();
            tag.func_74780_a("factor", this.factor);
            tag.func_74780_a("max", this.max);
            return tag;
        }
    }

    public static class Static
    extends ScalingFormula {
        Map<EquipmentSlotType, Integer> slots = new EnumMap<EquipmentSlotType, Integer>(EquipmentSlotType.class);

        public Static(int head, int body, int legs, int feet) {
            super(Type.STATIC);
            this.slots.put(EquipmentSlotType.HEAD, head);
            this.slots.put(EquipmentSlotType.CHEST, body);
            this.slots.put(EquipmentSlotType.LEGS, legs);
            this.slots.put(EquipmentSlotType.FEET, feet);
        }

        private Static() {
            super(Type.STATIC);
        }

        @Override
        public int getSlots(EquipmentSlotType slot, ItemStack stack) {
            return this.slots.getOrDefault(slot, 0);
        }

        @Override
        public List<? extends Number> getValues() {
            return Arrays.asList(this.slots.get(EquipmentSlotType.HEAD), this.slots.get(EquipmentSlotType.CHEST), this.slots.get(EquipmentSlotType.LEGS), this.slots.get(EquipmentSlotType.FEET));
        }

        public static Static deserialize(CompoundNBT nbt) {
            Static instance = new Static();
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                instance.slots.put(slot, nbt.func_74762_e(slot.func_188450_d()));
            }
            return instance;
        }

        @Override
        public CompoundNBT serialize() {
            CompoundNBT tag = super.serialize();
            for (Map.Entry<EquipmentSlotType, Integer> entry : this.slots.entrySet()) {
                tag.func_74768_a(entry.getKey().func_188450_d(), entry.getValue().intValue());
            }
            return tag;
        }
    }
}

