/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.block_temp;

import com.google.common.collect.ImmutableSet;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlockTemp {
    private final Set<Block> validBlocks;
    private final double maxEffect;
    private final double minEffect;
    private final double maxTemperature;
    private final double minTemperature;
    private final double range;
    private final boolean fade;

    public abstract double getTemperature(World var1, @Nullable LivingEntity var2, BlockState var3, BlockPos var4, double var5);

    public boolean isValid(World level, BlockPos pos, BlockState state) {
        return true;
    }

    public BlockTemp(Block ... blocks) {
        this.validBlocks = ImmutableSet.builder().add((Object[])blocks).build();
        this.minEffect = Double.NEGATIVE_INFINITY;
        this.maxEffect = Double.POSITIVE_INFINITY;
        this.minTemperature = Double.NEGATIVE_INFINITY;
        this.maxTemperature = Double.POSITIVE_INFINITY;
        this.range = Double.POSITIVE_INFINITY;
        this.fade = true;
    }

    public BlockTemp(double minEffect, double maxEffect, double minTemp, double maxTemp, double range, boolean fade, Block ... blocks) {
        this.validBlocks = ImmutableSet.builder().add((Object[])blocks).build();
        this.minEffect = minEffect;
        this.maxEffect = maxEffect;
        this.minTemperature = minTemp;
        this.maxTemperature = maxTemp;
        this.range = range;
        this.fade = fade;
    }

    public boolean hasBlock(Block block) {
        return this.validBlocks.contains(block);
    }

    public Set<Block> getAffectedBlocks() {
        return this.validBlocks;
    }

    public double maxEffect() {
        return this.maxEffect;
    }

    public double minEffect() {
        return this.minEffect;
    }

    public double maxTemperature() {
        return this.maxTemperature;
    }

    public double minTemperature() {
        return this.minTemperature;
    }

    public double range() {
        return Math.min(this.range, (double)ConfigSettings.BLOCK_RANGE.get().intValue());
    }

    public boolean fade() {
        return this.fade;
    }
}

