/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;

public class BiomeTempModifier
extends TempModifier {
    public BiomeTempModifier() {
        this(16);
    }

    public BiomeTempModifier(int samples) {
        this.getNBT().func_74768_a("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        DimensionTempData dimTempOffsetConf;
        int samples = this.getNBT().func_74762_e("Samples");
        double worldTemp = 0.0;
        World level = entity.field_70170_p;
        BlockPos entPos = entity.func_233580_cy_();
        DimensionTempData dimTempOverride = ConfigSettings.DIMENSION_TEMPS.get(entity.field_70170_p.func_241828_r()).get(level.func_230315_m_());
        if (dimTempOverride != null) {
            return temp -> temp + dimTempOverride.getTemperature();
        }
        Pair<Double, Double> structureTemp = BiomeTempModifier.getStructureTemp(entity.field_70170_p, entity.func_233580_cy_());
        if (structureTemp.getFirst() != null) {
            return temp -> (Double)structureTemp.getFirst();
        }
        int biomeCount = 0;
        for (BlockPos blockPos : WorldHelper.getPositionGrid(entPos, samples, 10)) {
            Biome biome = level.func_225523_d_().func_226836_a_(blockPos);
            ++biomeCount;
            DimensionType dimension = level.func_230315_m_();
            if (!dimension.func_236037_d_()) {
                double biomeTemp = WorldHelper.getBiomeTemperature((IWorld)level, biome);
                if (CompatManager.isPrimalWinterLoaded()) {
                    biomeTemp = Math.min(biomeTemp, biomeTemp / 2.0) - Math.max(biomeTemp / 2.0, 0.0);
                }
                worldTemp += biomeTemp;
                continue;
            }
            worldTemp += CSMath.averagePair(WorldHelper.getBiomeTemperatureRange((IWorld)level, biome));
        }
        worldTemp /= (double)Math.max(1, biomeCount);
        if (!level.func_230315_m_().func_236037_d_() && level.func_72896_J()) {
            long time = level.func_72820_D();
            double overcastTemp = ConfigSettings.OVERCAST_TEMP_OFFSET.get();
            worldTemp += CSMath.blend(0.0, overcastTemp, (double)Math.abs(6000L - time), 6000.0, 0.0);
        }
        if ((dimTempOffsetConf = ConfigSettings.DIMENSION_OFFSETS.get(entity.field_70170_p.func_241828_r()).get(level.func_230315_m_())) != null) {
            worldTemp += dimTempOffsetConf.getTemperature();
        }
        double finalWorldTemp = worldTemp += ((Double)structureTemp.getSecond()).doubleValue();
        return temp -> temp + finalWorldTemp;
    }

    public static Pair<Double, Double> getStructureTemp(World level, BlockPos pos) {
        Optional<StructureFeature<?, ?>> structure = WorldHelper.getStructureAt(level, pos);
        if (!structure.isPresent()) {
            return Pair.of(null, (Object)0.0);
        }
        Double strucTemp = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_TEMPS.get(level.func_241828_r()).get(structure.get()), StructureTempData::getTemperature, null);
        Double strucOffset = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_OFFSETS.get(level.func_241828_r()).get(structure.get()), StructureTempData::getTemperature, 0.0);
        return Pair.of((Object)strucTemp, (Object)strucOffset);
    }
}

