/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.Triplet;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;

public class BlockTempModifier
extends TempModifier {
    Map<ChunkPos, IChunk> chunks = new HashMap<ChunkPos, IChunk>(16);
    Map<BlockTemp, Double> blockTempEffects = new HashMap<BlockTemp, Double>(128);
    Map<BlockPos, BlockState> stateCache = new HashMap<BlockPos, BlockState>(4096);
    List<Triplet<BlockPos, BlockTemp, Double>> triggers = new ArrayList<Triplet<BlockPos, BlockTemp, Double>>(128);

    public BlockTempModifier() {
    }

    public BlockTempModifier(int range) {
        if (range > 0) {
            this.getNBT().func_74768_a("RangeOverride", range);
        }
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        this.blockTempEffects.clear();
        this.stateCache.clear();
        this.triggers.clear();
        World world = entity.field_70170_p;
        int range = this.getNBT().func_150297_b("RangeOverride", 3) ? this.getNBT().func_74762_e("RangeOverride") : ConfigSettings.BLOCK_RANGE.get().intValue();
        BlockPos blockPos = entity.func_233580_cy_();
        int entX = blockPos.func_177958_n();
        int entY = blockPos.func_177956_o();
        int entZ = blockPos.func_177952_p();
        BlockPos.Mutable blockpos = new BlockPos.Mutable();
        boolean shouldTickAdvancements = this.getTicksExisted() % 20 == 0;
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                ChunkPos chunkPos = new ChunkPos(entX + x >> 4, entZ + z >> 4);
                IChunk chunk = this.chunks.get(chunkPos);
                if (chunk == null) {
                    chunk = WorldHelper.getChunk((IWorld)world, chunkPos);
                    this.chunks.put(chunkPos, chunk);
                }
                if (chunk == null) continue;
                for (int y = -range; y < range; ++y) {
                    Collection<BlockTemp> blockTemps;
                    blockpos.func_181079_c(entX + x, entY + y, entZ + z);
                    BlockState state = this.stateCache.get(blockpos);
                    if (state == null) {
                        ChunkSection section = WorldHelper.getChunkSection(chunk, blockpos.func_177956_o());
                        state = section == null ? chunk.func_180495_p((BlockPos)blockpos) : section.func_177485_a(blockpos.func_177958_n() & 0xF, blockpos.func_177956_o() & 0xF, blockpos.func_177952_p() & 0xF);
                        this.stateCache.put(blockpos.func_185334_h(), state);
                    }
                    if (state.func_185904_a() == Material.field_151579_a || (blockTemps = BlockTempRegistry.getBlockTempsFor(state)).isEmpty() || blockTemps.size() == 1 && blockTemps.contains(BlockTempRegistry.DEFAULT_BLOCK_TEMP) || !BlockTempModifier.areAnyBlockTempsInRange(this.blockTempEffects, blockTemps)) continue;
                    Vector3d pos = Vector3d.func_237489_a_((Vector3i)blockpos);
                    Vector3d playerClosest = WorldHelper.getClosestPointOnEntity(entity, pos);
                    int[] blocks = new int[1];
                    Vector3d ray = pos.func_178788_d(playerClosest);
                    Direction direction = Direction.func_210769_a((double)ray.field_72450_a, (double)ray.field_72448_b, (double)ray.field_72449_c);
                    WorldHelper.forBlocksInRay(playerClosest, pos, world, chunk, this.stateCache, (rayState, bpos) -> {
                        if (!bpos.equals((Object)blockpos) && WorldHelper.isSpreadBlocked((IWorld)world, rayState, bpos, direction, direction)) {
                            blocks[0] = blocks[0] + 1;
                        }
                    }, 3);
                    double distance = CSMath.getDistance(playerClosest, pos);
                    for (BlockTemp blockTemp : blockTemps) {
                        if (!blockTemp.isValid(world, (BlockPos)blockpos, state)) continue;
                        double temperature = blockTemp.getTemperature(world, entity, state, (BlockPos)blockpos, distance);
                        double tempToAdd = blockTemp.fade() ? CSMath.blend(temperature, 0.0, distance, 0.5, blockTemp.range()) : temperature;
                        double blockTempTotal = this.blockTempEffects.getOrDefault(blockTemp, 0.0) + tempToAdd / (double)(blocks[0] + 1);
                        this.blockTempEffects.put(blockTemp, CSMath.clamp(blockTempTotal, blockTemp.minEffect(), blockTemp.maxEffect()));
                        if (!shouldTickAdvancements) continue;
                        this.triggers.add(new Triplet<BlockPos.Mutable, BlockTemp, Double>(blockpos, blockTemp, distance));
                    }
                }
            }
        }
        if (entity instanceof ServerPlayerEntity && shouldTickAdvancements) {
            for (Triplet<BlockPos, BlockTemp, Double> trigger : this.triggers) {
                ModAdvancementTriggers.BLOCK_AFFECTS_TEMP.trigger((ServerPlayerEntity)entity, trigger.getA(), trigger.getC(), this.blockTempEffects.get(trigger.getB()));
            }
        }
        while (this.chunks.size() >= 16) {
            this.chunks.remove(this.chunks.keySet().iterator().next());
        }
        return temp -> {
            for (Map.Entry<BlockTemp, Double> effect : this.blockTempEffects.entrySet()) {
                BlockTemp be = effect.getKey();
                double min = be.minTemperature();
                double max = be.maxTemperature();
                if (!CSMath.betweenInclusive(temp, min, max)) continue;
                temp = CSMath.clamp(temp + effect.getValue(), min, max);
            }
            return temp;
        };
    }

    private static boolean areAnyBlockTempsInRange(Map<BlockTemp, Double> blockTempEffects, Collection<BlockTemp> blockTemps) {
        boolean isInTempRange = blockTempEffects.isEmpty();
        if (!isInTempRange) {
            for (Map.Entry<BlockTemp, Double> entry : blockTempEffects.entrySet()) {
                BlockTemp key = entry.getKey();
                Double value = entry.getValue();
                if (blockTemps.contains(key) && !CSMath.betweenInclusive(value, key.minEffect(), key.maxEffect())) continue;
                isInTempRange = true;
                break;
            }
        }
        return isInTempRange;
    }
}

