/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class ElevationTempModifier
extends TempModifier {
    public ElevationTempModifier() {
        this(49);
    }

    public ElevationTempModifier(int samples) {
        this.getNBT().func_74768_a("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (entity.field_70170_p.func_230315_m_().func_236037_d_()) {
            return temp -> temp;
        }
        World level = entity.field_70170_p;
        ArrayList<Pair> depthTable = new ArrayList<Pair>();
        for (BlockPos pos : WorldHelper.getPositionGrid(entity.func_233580_cy_(), this.getNBT().func_74762_e("Samples"), 10)) {
            depthTable.add(Pair.of((Object)pos, (Object)CSMath.getDistance((Vector3i)entity.func_233580_cy_(), (Vector3i)pos)));
        }
        int skylight = entity.field_70170_p.func_226658_a_(LightType.SKY, entity.func_233580_cy_());
        FastMap<BlockPos, Pair> depthRegions = new FastMap<BlockPos, Pair>();
        block1: for (Pair pair : depthTable) {
            int groundLevel;
            int minY;
            BlockPos originalPos = (BlockPos)pair.getFirst();
            int originalY = originalPos.func_177956_o();
            int adjustedY = CSMath.betweenInclusive(originalY, minY = 0, groundLevel = WorldHelper.getHeight(originalPos, level)) ? CSMath.clamp(originalY + skylight - 4, minY, groundLevel) : (originalY >= groundLevel ? CSMath.clamp(originalY + skylight - 4, groundLevel, originalY) : CSMath.clamp(originalY + skylight - 4, originalY, minY));
            BlockPos pos = new BlockPos(originalPos.func_177958_n(), adjustedY, originalPos.func_177952_p());
            double distance = (Double)pair.getSecond();
            for (DepthTempData data : ConfigSettings.DEPTH_REGIONS.get()) {
                DepthTempData.TempRegion region = data.getRegion(level, pos);
                if (region == null) continue;
                depthRegions.put(pos, Pair.of((Object)region, (Object)distance));
                continue block1;
            }
            depthRegions.put(pos, Pair.of(null, (Object)distance));
        }
        return temp -> {
            ArrayList depthTemps = new ArrayList();
            for (Map.Entry entry : depthRegions.entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                DepthTempData.TempRegion region = (DepthTempData.TempRegion)((Pair)entry.getValue()).getFirst();
                double distance = (Double)((Pair)entry.getValue()).getSecond();
                double depthTemp = CSMath.getIfNotNull(region, reg -> reg.getTemperature((double)temp, pos, level), temp);
                double weight = 1.0 / (distance / 10.0 + 1.0);
                depthTemps.add(new Pair((Object)depthTemp, (Object)weight));
            }
            if (depthTemps.isEmpty()) {
                return temp;
            }
            return CSMath.weightedAverage(depthTemps);
        };
    }
}

