/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.util.Temperature;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class TempModifier {
    private CompoundNBT nbt = new CompoundNBT();
    private int expireTicks = -1;
    private int ticksExisted = 0;
    private int tickRate = 1;
    private double lastInput = 0.0;
    private double lastOutput = 0.0;
    private Function<Double, Double> function = temp -> temp;
    private boolean changed = false;

    protected abstract Function<Double, Double> calculate(LivingEntity var1, Temperature.Trait var2);

    public final double update(double temp, LivingEntity entity, Temperature.Trait trait) {
        TempModifierEvent.Calculate.Pre pre = new TempModifierEvent.Calculate.Pre(this, entity, temp, trait);
        MinecraftForge.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            this.function = pre.getFunction();
            return this.apply(pre.getTemperature());
        }
        TempModifierEvent.Calculate.Post post = new TempModifierEvent.Calculate.Post(this, entity, pre.getTemperature(), this.calculate(entity, trait), trait);
        MinecraftForge.EVENT_BUS.post((Event)post);
        this.function = post.getFunction();
        return this.apply(post.getTemperature());
    }

    public double apply(double temp) {
        this.lastInput = temp;
        this.lastOutput = this.function.apply(temp);
        return this.lastOutput;
    }

    public final <T extends TempModifier> T expires(int ticks) {
        this.expireTicks = ticks;
        return (T)this;
    }

    public final int getExpireTime() {
        return this.expireTicks;
    }

    public final int getTicksExisted() {
        return this.ticksExisted;
    }

    public final int setTicksExisted(int ticks) {
        this.ticksExisted = ticks;
        return this.ticksExisted;
    }

    public final <T extends TempModifier> T tickRate(int ticks) {
        this.tickRate = Math.max(1, ticks);
        return (T)this;
    }

    public final int getTickRate() {
        return this.tickRate;
    }

    public final double getLastInput() {
        return this.lastInput;
    }

    public final double getLastOutput() {
        return this.lastOutput;
    }

    public final CompoundNBT getNBT() {
        return this.nbt;
    }

    public void setNBT(CompoundNBT data) {
        this.nbt = data;
    }

    public String toString() {
        return TempModifierRegistry.getKey(this).toString();
    }

    public void markDirty() {
        this.changed = true;
    }

    public boolean isDirty() {
        return this.changed;
    }

    public void markClean() {
        this.changed = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TempModifier) {
            TempModifier mod = (TempModifier)obj;
            return this.getClass().equals(mod.getClass()) && mod.getNBT().equals((Object)this.getNBT());
        }
        return false;
    }
}

