/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier.compat;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.SeasonalTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import corgitaco.betterweather.api.season.Season;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;

public class BetterWeatherTempModifier
extends TempModifier {
    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        Season season;
        if (entity.field_70170_p.func_230315_m_().func_236043_f_() && (season = Season.getSeason((World)entity.field_70170_p)) != null) {
            Pair startEndTemps;
            SeasonalTempData springTemps = ConfigSettings.SPRING_TEMPS.get();
            SeasonalTempData summerTemps = ConfigSettings.SUMMER_TEMPS.get();
            SeasonalTempData autumnTemps = ConfigSettings.AUTUMN_TEMPS.get();
            SeasonalTempData winterTemps = ConfigSettings.WINTER_TEMPS.get();
            block0 : switch (season.getKey()) {
                case AUTUMN: {
                    switch (season.getPhase()) {
                        case START: {
                            startEndTemps = Pair.of((Object)autumnTemps.getStartTemp(), (Object)autumnTemps.getMiddleTemp());
                            break block0;
                        }
                        case MID: {
                            startEndTemps = Pair.of((Object)autumnTemps.getMiddleTemp(), (Object)autumnTemps.getEndTemp());
                            break block0;
                        }
                        case END: {
                            startEndTemps = Pair.of((Object)autumnTemps.getEndTemp(), (Object)winterTemps.getStartTemp());
                            break block0;
                        }
                    }
                    return temp -> temp;
                }
                case WINTER: {
                    switch (season.getPhase()) {
                        case START: {
                            startEndTemps = Pair.of((Object)winterTemps.getStartTemp(), (Object)winterTemps.getMiddleTemp());
                            break block0;
                        }
                        case MID: {
                            startEndTemps = Pair.of((Object)winterTemps.getMiddleTemp(), (Object)winterTemps.getEndTemp());
                            break block0;
                        }
                        case END: {
                            startEndTemps = Pair.of((Object)winterTemps.getEndTemp(), (Object)springTemps.getStartTemp());
                            break block0;
                        }
                    }
                    return temp -> temp;
                }
                case SPRING: {
                    switch (season.getPhase()) {
                        case START: {
                            startEndTemps = Pair.of((Object)springTemps.getStartTemp(), (Object)springTemps.getMiddleTemp());
                            break block0;
                        }
                        case MID: {
                            startEndTemps = Pair.of((Object)springTemps.getMiddleTemp(), (Object)springTemps.getEndTemp());
                            break block0;
                        }
                        case END: {
                            startEndTemps = Pair.of((Object)springTemps.getEndTemp(), (Object)summerTemps.getStartTemp());
                            break block0;
                        }
                    }
                    return temp -> temp;
                }
                case SUMMER: {
                    switch (season.getPhase()) {
                        case START: {
                            startEndTemps = Pair.of((Object)summerTemps.getStartTemp(), (Object)summerTemps.getMiddleTemp());
                            break block0;
                        }
                        case MID: {
                            startEndTemps = Pair.of((Object)summerTemps.getMiddleTemp(), (Object)summerTemps.getEndTemp());
                            break block0;
                        }
                        case END: {
                            startEndTemps = Pair.of((Object)summerTemps.getEndTemp(), (Object)autumnTemps.getStartTemp());
                            break block0;
                        }
                    }
                    return temp -> temp;
                }
                default: {
                    return temp -> temp;
                }
            }
            double startValue = (Double)startEndTemps.getFirst();
            double endValue = (Double)startEndTemps.getSecond();
            int yearLength = season.getYearLength();
            int phaseLength = Season.getPhaseLength((int)yearLength);
            return temp -> temp + (double)((float)CSMath.blend(startValue, endValue, (double)(season.getCurrentYearTime() % phaseLength), 0.0, (double)phaseLength));
        }
        return temp -> temp;
    }
}

