/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.util;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.function.Predicate;

public class Placement {
    private final Mode mode;
    private final Order order;
    private final Predicate<TempModifier> predicate;
    public static final Placement AFTER_LAST = Placement.of(Mode.AFTER, Order.LAST, (TempModifier mod) -> true);
    public static final Placement BEFORE_FIRST = Placement.of(Mode.BEFORE, Order.FIRST, (TempModifier mod) -> true);

    public Placement(Mode mode, Order order, Predicate<TempModifier> predicate) {
        this.mode = mode;
        this.order = order;
        this.predicate = predicate;
    }

    public Mode mode() {
        return this.mode;
    }

    public Order order() {
        return this.order;
    }

    public Predicate<TempModifier> predicate() {
        return this.predicate;
    }

    public static Placement of(Mode mode, Order order, Predicate<TempModifier> predicate) {
        return new Placement(mode, order, predicate);
    }

    public static Placement of(Mode mode, Order order, Class<? extends TempModifier> clazz) {
        return new Placement(mode, order, clazz::isInstance);
    }

    public static enum Duplicates implements StringRepresentable
    {
        ALLOW("allow"),
        BY_CLASS("by_class"),
        EXACT("exact");

        private final String name;

        private Duplicates(String name) {
            this.name = name;
        }

        public static boolean check(Duplicates policy, TempModifier modA, TempModifier modB) {
            switch (policy) {
                case ALLOW: {
                    return false;
                }
                case BY_CLASS: {
                    return modA.getClass().equals(modB.getClass());
                }
                case EXACT: {
                    return modA.equals(modB);
                }
            }
            return false;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static Duplicates byName(String name) {
            for (Duplicates policy : Duplicates.values()) {
                if (!policy.name.equals(name)) continue;
                return policy;
            }
            return ALLOW;
        }
    }

    public static enum Order implements StringRepresentable
    {
        FIRST("first"),
        LAST("last");

        private final String name;

        private Order(String name) {
            this.name = name;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static Order byName(String name) {
            for (Order order : Order.values()) {
                if (!order.name.equals(name)) continue;
                return order;
            }
            return FIRST;
        }
    }

    public static enum Mode implements StringRepresentable
    {
        BEFORE("before"),
        AFTER("after"),
        REPLACE("replace"),
        REPLACE_OR_ADD("replace_or_add");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public boolean isReplacing() {
            return this == REPLACE || this == REPLACE_OR_ADD;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static Mode byName(String name) {
            for (Mode mode : Mode.values()) {
                if (!mode.name.equals(name)) continue;
                return mode;
            }
            return BEFORE;
        }
    }
}

