/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterItemOverrides {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.SOULSPRING_LAMP.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "soulspring_state"), (stack, level, entity) -> {
                CompoundNBT tag = stack.func_196082_o();
                if (tag.func_74767_n("Lit")) {
                    return tag.func_74762_e("Fuel") > 43 ? 3.0f : (tag.func_74762_e("Fuel") > 22 ? 2.0f : 1.0f);
                }
                return 0.0f;
            });
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.FILLED_WATERSKIN.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "water_temperature"), (stack, level, entity) -> stack.func_196082_o().func_74760_g("Temperature"));
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.THERMOMETER.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "temperature"), (stack, level, livingEntity) -> {
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : stack.func_234694_A_();
                if (entity != null) {
                    ItemFrameEntity frame;
                    double worldTemp;
                    double maxTemp;
                    double minTemp = livingEntity != null ? Temperature.get(livingEntity, Temperature.Trait.FREEZING_POINT) : ConfigSettings.MIN_TEMP.get();
                    double d = maxTemp = livingEntity != null ? Temperature.get(livingEntity, Temperature.Trait.BURNING_POINT) : ConfigSettings.MAX_TEMP.get();
                    if (!entity.getPersistentData().func_74764_b("WorldTempTimestamp") || (entity.field_70173_aa % 20 == 0 || entity instanceof PlayerEntity && entity.field_70173_aa % 2 == 0) && entity.getPersistentData().func_74762_e("WorldTempTimestamp") != entity.field_70173_aa) {
                        worldTemp = entity instanceof LivingEntity ? EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.getTrait(Temperature.Trait.WORLD)).orElse(0.0) : WorldHelper.getTemperatureAt(entity.field_70170_p, entity.func_233580_cy_());
                        entity.getPersistentData().func_74780_a("WorldTemp", worldTemp);
                        entity.getPersistentData().func_74768_a("WorldTempTimestamp", entity.field_70173_aa);
                    } else {
                        worldTemp = entity.getPersistentData().func_74769_h("WorldTemp");
                    }
                    if (entity instanceof ItemFrameEntity && Minecraft.func_71410_x().func_175598_ae().field_147941_i == (frame = (ItemFrameEntity)entity)) {
                        TextFormatting tempColor;
                        boolean celsius = ConfigSettings.CELSIUS.get();
                        switch (Overlays.getGaugeSeverity(worldTemp, minTemp, maxTemp)) {
                            case 0: {
                                tempColor = TextFormatting.WHITE;
                                break;
                            }
                            case 2: 
                            case 3: {
                                tempColor = TextFormatting.GOLD;
                                break;
                            }
                            case 4: {
                                tempColor = TextFormatting.RED;
                                break;
                            }
                            case -3: 
                            case -2: {
                                tempColor = TextFormatting.AQUA;
                                break;
                            }
                            case -4: {
                                tempColor = TextFormatting.BLUE;
                                break;
                            }
                            default: {
                                tempColor = TextFormatting.RESET;
                            }
                        }
                        int convertedTemp = (int)Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true) + ConfigSettings.TEMP_OFFSET.get();
                        frame.func_82335_i().func_200302_a((ITextComponent)new StringTextComponent(convertedTemp + " " + (celsius ? Temperature.Units.C.getFormattedName() : Temperature.Units.F.getFormattedName())).func_240699_a_(tempColor));
                    }
                    double worldTempAdjusted = Overlays.getWorldSeverity(worldTemp, minTemp, maxTemp) * 1.01;
                    return (float)worldTempAdjusted;
                }
                return 0.0f;
            });
        });
    }
}

