/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderLampHand {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHandRender(RenderHandEvent event) {
        if (event.getItemStack().func_77973_b() == ModItems.SOULSPRING_LAMP) {
            event.setCanceled(true);
            MatrixStack ms = event.getMatrixStack();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            boolean isRightHand = EntityHelper.getArmFromHand(event.getHand(), (PlayerEntity)player) == HandSide.RIGHT;
            PlayerRenderer playerRenderer = (PlayerRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)player);
            FirstPersonRenderer handRenderer = Minecraft.func_71410_x().field_71460_t.field_78516_c;
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, 0.2, -0.3);
            ms.func_227860_a_();
            float swingProgress = event.getSwingProgress();
            float equipProgress = event.getEquipProgress();
            float handX = isRightHand ? 1.0f : -1.0f;
            ms.func_227861_a_(isRightHand ? 0.0 : -0.698, 0.6, isRightHand ? 0.7 : 0.76);
            float sqrtSwing = MathHelper.func_76129_c((float)swingProgress);
            float handSwingX = -0.3f * MathHelper.func_76126_a((float)(sqrtSwing * (float)Math.PI));
            float handSwingY = 0.4f * MathHelper.func_76126_a((float)(sqrtSwing * ((float)Math.PI * 2)));
            float handSwingZ = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
            float swingSize = isRightHand ? (float)(equipProgress != 0.0f && equipProgress < 1.0f ? 2 : 4) : (equipProgress != 0.0f && equipProgress < 1.0f ? 1.5f : 7.0f);
            ms.func_227861_a_((double)(handX * (handSwingX + 0.64000005f)), (double)(handSwingY / swingSize + -0.6f + equipProgress * -0.6f), (double)(handSwingZ / (swingSize * 6.0f) + -0.71999997f));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(handX * 45.0f));
            float handFlailZ = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
            float handFlailX = MathHelper.func_76126_a((float)(sqrtSwing * (float)Math.PI));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(handX * handFlailX * (isRightHand ? 1.0f : 20.0f)));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(handX * handFlailX * (isRightHand ? -10.0f : 1.0f)));
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(handX * handFlailZ * 20.0f));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            if (isRightHand) {
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-130.0f));
            } else {
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-230.0f));
            }
            ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            if (isRightHand) {
                ms.func_227861_a_(0.5, -0.1, 0.5);
            } else {
                ms.func_227861_a_(-1.2, -0.1, 0.5);
            }
            RenderLampHand.renderHand(ms, event.getBuffers(), event.getLight(), (AbstractClientPlayerEntity)player, isRightHand, event.getHand(), handRenderer, playerRenderer, event.getItemStack());
            ms.func_227865_b_();
            ms.func_227865_b_();
        }
    }

    public static void transformArm(LivingEntity entity, ModelRenderer arm, HandSide side) {
        if (entity instanceof PlayerEntity && EntityHelper.holdingLamp(entity, side)) {
            PlayerEntity player = (PlayerEntity)entity;
            float sideMultiplier = side == HandSide.RIGHT ? 1.0f : -1.0f;
            arm.field_78808_h += 1.5707964f * sideMultiplier;
            arm.field_78796_g = -arm.field_78795_f * sideMultiplier - 1.5707964f * sideMultiplier * 1.04f;
            arm.field_78795_f = -1.5707964f;
            arm.field_78800_c -= 1.0f * sideMultiplier;
            if (player.func_213453_ef()) {
                arm.field_78795_f -= 0.4f;
            }
            if (player.field_82175_bq && side == EntityHelper.getArmFromHand(player.field_184622_au, player)) {
                RenderLampHand.swingArm(arm, (LivingEntity)player, side);
            }
        }
    }

    private static void swingArm(ModelRenderer arm, LivingEntity player, HandSide side) {
        float sideMultiplier = side == HandSide.RIGHT ? 1.0f : -1.0f;
        float partialTick = Minecraft.func_71410_x().func_184121_ak();
        float attackAnim = player.func_70678_g(partialTick);
        float playerPitch = player.func_195050_f(partialTick);
        float pitchFactor = RenderLampHand.getSwingHorizontalOffset(side, playerPitch);
        float windUpTime = 0.3f;
        float windUpPoint = 1.5f;
        float midSwingTime = 0.7f;
        arm.field_78795_f = attackAnim < windUpTime / 3.0f ? (arm.field_78795_f += CSMath.blendLog(0.0f, windUpPoint, attackAnim, 0.0f, windUpTime / 3.0f) / pitchFactor) : (attackAnim < windUpTime ? (arm.field_78795_f += CSMath.blendLog(windUpPoint, 1.0f, attackAnim, windUpTime / 3.0f, windUpTime) / pitchFactor) : (attackAnim < midSwingTime ? (arm.field_78795_f += CSMath.blend(1.0f, 0.2f, attackAnim, windUpTime, midSwingTime) / pitchFactor) : (arm.field_78795_f += CSMath.blendExp(0.2f, 0.0f, attackAnim, midSwingTime, 1.0f) / pitchFactor)));
        float pitchSwingHeight = playerPitch < 0.0f ? playerPitch / 20.0f : playerPitch / 60.0f;
        arm.field_78796_g = (float)((double)arm.field_78796_g + (Math.pow((double)attackAnim - 0.5, 2.0) - 0.25) * (double)pitchSwingHeight * (double)sideMultiplier);
        if (side == HandSide.LEFT) {
            arm.field_78808_h = (float)((double)arm.field_78808_h + Math.sin((double)attackAnim * Math.PI) * 0.5);
        }
    }

    private static float getSwingHorizontalOffset(HandSide side, float playerPitch) {
        float pitchFactor = side == HandSide.RIGHT ? (playerPitch < 0.0f ? CSMath.blend(1.8f, 0.6f, playerPitch, 0.0f, -90.0f) : CSMath.blend(1.8f, 3.0f, playerPitch, 0.0f, 90.0f)) : (playerPitch < 0.0f ? CSMath.blend(3.0f, 0.5f, playerPitch, 0.0f, -90.0f) : CSMath.blend(3.0f, 3.0f, playerPitch, 0.0f, 90.0f));
        return pitchFactor;
    }

    public static void rotateArmorShoulder(LivingEntity entity, BipedModel<?> model, HandSide side, boolean slim) {
        float partialTick = Minecraft.func_71410_x().func_184121_ak();
        float playerPitch = entity.func_195050_f(partialTick);
        float attackAnim = entity.func_70678_g(partialTick);
        if (side == HandSide.RIGHT) {
            float xRot = model.field_178723_h.field_78795_f;
            model.field_178723_h.field_78808_h -= CSMath.toRadians(90.0f);
            model.field_178723_h.field_78795_f = -model.field_178723_h.field_78796_g - CSMath.toRadians(90.0f);
            model.field_178723_h.field_78796_g = xRot + CSMath.toRadians(90.0f);
            model.field_178723_h.field_78800_c += 1.0f;
            if (!slim) {
                model.field_178723_h.field_78797_d -= 1.0f;
            }
            float pitchSwingHeight = playerPitch < 0.0f ? playerPitch / 20.0f : playerPitch / 60.0f;
            float pitchRot = (float)(Math.pow((double)attackAnim - 0.5, 2.0) - 0.25) * pitchSwingHeight;
            model.field_178723_h.field_78808_h += pitchRot * 0.4f;
            model.field_178723_h.field_78796_g += pitchRot * 0.2f;
        } else if (side == HandSide.LEFT) {
            float xRot = model.field_178724_i.field_78795_f;
            model.field_178724_i.field_78808_h += CSMath.toRadians(90.0f);
            model.field_178724_i.field_78795_f = model.field_178724_i.field_78796_g - CSMath.toRadians(90.0f);
            model.field_178724_i.field_78796_g = -xRot - CSMath.toRadians(90.0f);
            model.field_178724_i.field_78800_c -= 1.0f;
            if (!slim) {
                model.field_178724_i.field_78797_d -= 1.0f;
            }
            float pitchSwingHeight = playerPitch < 0.0f ? playerPitch / 20.0f : playerPitch / 60.0f;
            model.field_178723_h.field_78796_g = (float)((double)model.field_178723_h.field_78796_g + (Math.pow((double)attackAnim - 0.5, 2.0) - 0.25) * (double)pitchSwingHeight * -1.0);
        }
    }

    private static void renderHand(MatrixStack ms, IRenderTypeBuffer bufferSource, int light, AbstractClientPlayerEntity player, boolean isRightHand, Hand hand, FirstPersonRenderer handRenderer, PlayerRenderer playerRenderer, ItemStack itemStack) {
        boolean isSelected = player.func_184586_b(hand).func_77973_b() == ModItems.SOULSPRING_LAMP;
        ms.func_227860_a_();
        ms.func_227860_a_();
        ms.func_227862_a_(1.0f, 1.2f, 1.0f);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-25.0f));
        ms.func_227861_a_(0.0, -0.2, 0.25);
        if (!isSelected) {
            ms.func_227861_a_(0.0, isRightHand ? -0.012 : 0.015, 0.0);
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(2.4f * (float)(isRightHand ? -1 : 1)));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(2.3f));
        }
        if (isRightHand) {
            if (isSelected) {
                ms.func_227861_a_(-0.365, -0.2, -0.075);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
            } else {
                ms.func_227861_a_(-0.3925, 0.06, 0.38);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            }
            playerRenderer.func_229144_a_(ms, bufferSource, light, player);
        } else {
            if (isSelected) {
                ms.func_227861_a_(-0.335, -0.2, -0.075);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            } else {
                ms.func_227861_a_(-0.325, 0.06, 0.38);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(87.0f));
            }
            playerRenderer.func_229146_b_(ms, bufferSource, light, player);
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        ms.func_227861_a_(-0.35, 0.1, 0.625);
        ms.func_227862_a_(1.0f, 1.0f, 0.8f);
        if (isRightHand) {
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            ms.func_227861_a_(-0.1, 0.125, 0.0);
            handRenderer.func_228397_a_((LivingEntity)player, itemStack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, ms, bufferSource, light);
        } else {
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            ms.func_227861_a_(-0.1, 0.125, 0.0);
            handRenderer.func_228397_a_((LivingEntity)player, itemStack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, false, ms, bufferSource, light);
        }
        ms.func_227865_b_();
        ms.func_227865_b_();
    }
}

