/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.api.event.client.RenderFogEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.RenderLevelEvent;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.client.renderer.PostProcessShaderManager;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TempEffectsClient {
    static float BLEND_TEMP = 0.0f;
    static float PREV_X_SWAY = 0.0f;
    static float PREV_Y_SWAY = 0.0f;
    static float X_SWAY_SPEED = 0.0f;
    static float Y_SWAY_SPEED = 0.0f;
    static float X_SWAY_PHASE = 0.0f;
    static float Y_SWAY_PHASE = 0.0f;
    static float TIME_SINCE_NEW_SWAY = 0.0f;
    static double COLD_IMMUNITY = 0.0;
    static double HOT_IMMUNITY = 0.0;
    static final ResourceLocation HAZE_TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/haze.png");
    static final ResourceLocation FREEZE_TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/freeze_overlay.png");

    @SubscribeEvent
    public static void setCamera(EntityViewRenderEvent.CameraSetup event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !player.func_70089_S() || EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        if (!Minecraft.func_71410_x().func_147113_T()) {
            float frameTime = Minecraft.func_71410_x().func_193989_ak();
            BLEND_TEMP = (float)CSMath.blend(Overlays.PREV_BODY_TEMP, Overlays.BODY_TEMP, event.getRenderPartialTicks(), 0.0, 1.0);
            if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue()) {
                if (BLEND_TEMP <= -50.0f && COLD_IMMUNITY < 1.0) {
                    double tickTime = (double)player.field_70173_aa + event.getRenderPartialTicks();
                    float shiverIntensity = CSMath.blend(((float)Math.sin(tickTime / 10.0) + 1.0f) * 0.03f + 0.01f, 0.0f, BLEND_TEMP, -100.0f, -50.0f);
                    shiverIntensity *= Minecraft.func_71410_x().func_193989_ak() * 10.0f;
                    shiverIntensity = (float)CSMath.blend((double)shiverIntensity, 0.0, COLD_IMMUNITY, 0.0, 1.0);
                    float shiverRotation = (float)(Math.sin(tickTime * 2.5) * (double)shiverIntensity);
                    player.func_70034_d(player.func_70079_am() + shiverRotation);
                } else if (BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 1.0) {
                    float immunityModifier = (float)CSMath.blend((double)BLEND_TEMP, 50.0, HOT_IMMUNITY, 0.0, 1.0);
                    float factor = CSMath.blend(0.0f, 20.0f, immunityModifier, 50.0f, 100.0f);
                    if (TIME_SINCE_NEW_SWAY > 100.0f || X_SWAY_SPEED == 0.0f || Y_SWAY_SPEED == 0.0f) {
                        TIME_SINCE_NEW_SWAY = 0.0f;
                        X_SWAY_SPEED = (float)(Math.random() * (double)0.003f + (double)0.004f);
                        Y_SWAY_SPEED = (float)(Math.random() * (double)0.003f + (double)0.004f);
                    }
                    TIME_SINCE_NEW_SWAY += frameTime;
                    X_SWAY_PHASE = (float)((double)X_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)X_SWAY_SPEED);
                    Y_SWAY_PHASE = (float)((double)Y_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)Y_SWAY_SPEED);
                    float xOffs = (float)(Math.sin(X_SWAY_PHASE) * (double)factor);
                    float yOffs = (float)((Math.sin(Y_SWAY_PHASE) + Math.cos(Y_SWAY_PHASE / 4.0f) * 2.0) * (double)factor * 3.0);
                    player.field_70125_A = player.field_70125_A + xOffs - PREV_X_SWAY;
                    player.field_70177_z = player.field_70177_z + yOffs - PREV_Y_SWAY;
                    PREV_X_SWAY = xOffs;
                    PREV_Y_SWAY = yOffs;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || EntityTempManager.isPeacefulMode((LivingEntity)player)) {
                return;
            }
            if (player.field_70173_aa % 5 == 0) {
                COLD_IMMUNITY = player.func_70644_a(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE);
                HOT_IMMUNITY = player.func_70644_a(Effects.field_76426_n) && ConfigSettings.FIRE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get((LivingEntity)player, Temperature.Trait.HEAT_RESISTANCE);
            }
        }
    }

    @SubscribeEvent
    public static void renderFog(EntityViewRenderEvent event) {
        if (!(event instanceof RenderFogEvent) && !(event instanceof EntityViewRenderEvent.FogColors)) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        double fogDistance = Math.max(0.01, ConfigSettings.HEATSTROKE_FOG_DISTANCE.get());
        if (fogDistance >= 64.0) {
            return;
        }
        if (fogDistance < Double.POSITIVE_INFINITY && BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 1.0) {
            float tempWithResistance = (float)CSMath.blend((double)BLEND_TEMP, 50.0, HOT_IMMUNITY, 0.0, 1.0);
            if (event instanceof RenderFogEvent) {
                RenderFogEvent fog = (RenderFogEvent)event;
                if (fogDistance > (double)fog.getFarPlaneDistance()) {
                    return;
                }
                fog.setFarPlaneDistance(CSMath.blend(fog.getFarPlaneDistance(), (float)fogDistance, tempWithResistance, 50.0f, 90.0f));
                fog.setNearPlaneDistance(CSMath.blend(fog.getNearPlaneDistance(), (float)(fogDistance * 0.3), tempWithResistance, 50.0f, 90.0f));
                fog.setCanceled(true);
            } else if (event instanceof EntityViewRenderEvent.FogColors) {
                EntityViewRenderEvent.FogColors fogColor = (EntityViewRenderEvent.FogColors)event;
                fogColor.setRed(CSMath.blend(fogColor.getRed(), 0.01f, tempWithResistance, 50.0f, 90.0f));
                fogColor.setGreen(CSMath.blend(fogColor.getGreen(), 0.01f, tempWithResistance, 50.0f, 90.0f));
                fogColor.setBlue(CSMath.blend(fogColor.getBlue(), 0.05f, tempWithResistance, 50.0f, 90.0f));
            }
        }
    }

    @SubscribeEvent
    public static void vignette(RenderGameOverlayEvent.Pre event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && (BLEND_TEMP > 0.0f && HOT_IMMUNITY < 1.0 || BLEND_TEMP < 0.0f && COLD_IMMUNITY < 1.0)) {
            float resistance = (float)CSMath.blend(1.0, 0.0, BLEND_TEMP > 0.0f ? HOT_IMMUNITY : COLD_IMMUNITY, 0.0, 1.0);
            float opacity = CSMath.blend(0.0f, 1.0f, Math.abs(BLEND_TEMP), 50.0f, 100.0f) * resistance;
            float tickTime = (float)player.field_70173_aa + event.getPartialTicks();
            if (opacity == 0.0f) {
                return;
            }
            double width = event.getWindow().func_198109_k();
            double height = event.getWindow().func_198091_l();
            double scale = event.getWindow().func_198100_s();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (BLEND_TEMP > 0.0f) {
                float vignetteBrightness = opacity + ((float)Math.sin((double)(tickTime + 3.0f) / 3.18306181683261) / 5.0f - 0.2f) * opacity;
                RenderSystem.color4f((float)0.231f, (float)0.0f, (float)0.0f, (float)vignetteBrightness);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(HAZE_TEXTURE);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FREEZE_TEXTURE);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_225582_a_(0.0, height / scale, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_(width / scale, height / scale, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_(width / scale, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
        }
    }

    @SubscribeEvent
    public static void onRenderBlur(RenderLevelEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        PostProcessShaderManager shaderManager = PostProcessShaderManager.getInstance();
        float playerTemp = (float)Overlays.BODY_TEMP;
        if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue() && playerTemp >= 50.0f && HOT_IMMUNITY < 1.0 && mc.field_71439_g != null && !EntityTempManager.isPeacefulMode((LivingEntity)mc.field_71439_g)) {
            ShaderUniform blurRadius;
            float blur = CSMath.blend(0.0f, 12.0f, playerTemp, 50.0f, 100.0f);
            blur = (float)CSMath.blend((double)blur, 0.0, HOT_IMMUNITY, 0.0, 1.0);
            if (!shaderManager.hasEffect("heat_blur")) {
                shaderManager.loadEffect("heat_blur", PostProcessShaderManager.BLOBS);
            }
            if ((blurRadius = shaderManager.getPostPasses("heat_blur").get(0).func_217624_b().func_216539_a("Radius")) != null) {
                blurRadius.func_148090_a(blur);
            }
        } else if (shaderManager.hasEffect("heat_blur")) {
            shaderManager.closeEffect("heat_blur");
        }
        shaderManager.process(event.getPartialTick());
    }
}

