/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.tooltip.ClientInsulationAttributeTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.ClientInsulationTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.ClientSoulspringTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.Tooltip;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncItemPredicatesMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.exceptions.RegistryFailureException;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TooltipHandler {
    public static final Style COLD = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)3767039));
    public static final Style HOT = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)16736574));
    public static final IFormattableTextComponent EXPAND_TOOLTIP = new StringTextComponent("?").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_244282_c(Boolean.valueOf(true))).func_230529_a_((ITextComponent)new StringTextComponent(" 'Shift'").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY).func_244282_c(Boolean.valueOf(false))));
    private static int TOOLTIP_BACKGROUND_COLOR = 0;
    private static int HOVERED_ITEM_UPDATE_COOLDOWN = 0;
    private static ItemStack HOVERED_STACK = ItemStack.field_190927_a;
    public static HashMap<UUID, Boolean> HOVERED_STACK_PREDICATES = new HashMap();
    private static final List<Object> TOOLTIP_INSERTIONS = new ArrayList<Object>();
    static int FUEL_FADE_TIMER = 0;
    private static final Map<Class<? extends Tooltip>, String> TOOLTIPS = new HashMap<Class<? extends Tooltip>, String>();
    private static int TOOLTIP_REGISTRY_SIZE = 0;

    public static <T extends ConfigData> boolean passesRequirement(T element) {
        return HOVERED_STACK_PREDICATES.getOrDefault(element.getId(), true);
    }

    public static boolean isShiftDown() {
        return Screen.func_231173_s_() || ConfigSettings.EXPAND_TOOLTIPS.get() != false;
    }

    public static int getTooltipTitleIndex(List<ITextComponent> tooltip, ItemStack stack) {
        int tooltipStartIndex;
        if (tooltip.isEmpty()) {
            return 0;
        }
        String hoverName = stack.func_200301_q().getString();
        for (tooltipStartIndex = 0; tooltipStartIndex < tooltip.size(); ++tooltipStartIndex) {
            if (!tooltip.get(tooltipStartIndex).getString().trim().equals(hoverName)) continue;
            ++tooltipStartIndex;
            break;
        }
        tooltipStartIndex = CSMath.clamp(tooltipStartIndex, 0, tooltip.size());
        return tooltipStartIndex;
    }

    public static int getTooltipEndIndex(List<ITextComponent> tooltip, ItemStack stack) {
        int tooltipEndIndex = tooltip.size();
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            --tooltipEndIndex;
            while (tooltipEndIndex > 0 && !tooltip.get(tooltipEndIndex).getString().equals(stack.func_77973_b().getRegistryName().toString())) {
                --tooltipEndIndex;
            }
        }
        tooltipEndIndex = CSMath.clamp(tooltipEndIndex, 0, tooltip.size());
        return tooltipEndIndex;
    }

    public static void addModifierTooltipLines(List<ITextComponent> tooltip, AttributeModifierMap map, boolean showIcon, boolean strikethrough) {
        map.getMap().asMap().forEach((attribute, modifiers) -> {
            for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                double value = 0.0;
                for (AttributeModifier modifier : modifiers.stream().filter(mod -> mod.func_220375_c() == operation).collect(Collectors.toList())) {
                    value += modifier.func_111164_d();
                }
                if (value == 0.0) continue;
                tooltip.add((ITextComponent)TooltipHandler.getFormattedAttributeModifier(attribute, value, operation, showIcon, strikethrough));
            }
        });
    }

    public static IFormattableTextComponent getFormattedAttributeModifier(Attribute attribute, double amount, AttributeModifier.Operation operation, boolean forTooltip, boolean strikethrough) {
        IFormattableTextComponent component;
        String percent;
        String sign;
        TextFormatting color;
        String operationString;
        if (attribute == null) {
            return new StringTextComponent("");
        }
        double value = amount;
        String attributeName = attribute.func_233754_c_().replace("attribute.", "");
        if (operation == AttributeModifier.Operation.ADDITION && (attribute == ModAttributes.FREEZING_POINT || attribute == ModAttributes.BURNING_POINT || attribute == ModAttributes.WORLD_TEMPERATURE)) {
            value = Temperature.convert(value, Temperature.Units.MC, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, false);
        }
        String string = operationString = operation == AttributeModifier.Operation.ADDITION ? "add" : "multiply";
        if (value >= 0.0) {
            color = TextFormatting.BLUE;
            sign = "+";
        } else {
            color = TextFormatting.RED;
            sign = "";
        }
        if (operation != AttributeModifier.Operation.ADDITION || attribute == ModAttributes.HEAT_RESISTANCE || attribute == ModAttributes.COLD_RESISTANCE || attribute == ModAttributes.HEAT_DAMPENING || attribute == ModAttributes.COLD_DAMPENING) {
            percent = "%";
            value *= 100.0;
        } else {
            percent = "";
        }
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(sign + CSMath.formatDoubleOrInt(CSMath.round(value, 2)) + percent));
        if (EntityTempManager.isTemperatureAttribute(attribute)) {
            component = new TranslationTextComponent(String.format("attribute.cold_sweat.modifier.%s.%s", operationString, attributeName), params.toArray());
        } else {
            component = TooltipHandler.getFormattedVanillaAttributeModifier(attribute, amount, operation);
            Object[] contents = ((TranslationTextComponent)component).func_150271_j();
            params.addAll(0, Arrays.asList(contents));
            component = TooltipHandler.setComponentContents(TooltipHandler.getFormattedVanillaAttributeModifier(attribute, amount, operation), contents);
        }
        component = component.func_240699_a_(color);
        component = TooltipHandler.addTooltipFlags(component, forTooltip, strikethrough);
        return component;
    }

    public static IFormattableTextComponent getFormattedVanillaAttributeModifier(Attribute attribute, double amount, AttributeModifier.Operation operation) {
        double adjustedAmount = operation == AttributeModifier.Operation.ADDITION ? (attribute.equals(Attributes.field_233820_c_) ? amount * 10.0 : amount) : amount * 100.0;
        if (amount >= 0.0) {
            return new TranslationTextComponent("attribute.modifier.plus." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(adjustedAmount), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.BLUE);
        }
        return new TranslationTextComponent("attribute.modifier.take." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(adjustedAmount *= -1.0), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.RED);
    }

    public static IFormattableTextComponent setComponentContents(IFormattableTextComponent component, Object[] newContents) {
        if (component instanceof TranslationTextComponent) {
            TranslationTextComponent translatable = (TranslationTextComponent)component;
            IFormattableTextComponent newComponent = new TranslationTextComponent(translatable.func_150268_i(), newContents).func_230530_a_(component.func_150256_b());
            component.func_150253_a().forEach(arg_0 -> ((IFormattableTextComponent)newComponent).func_230529_a_(arg_0));
            return newComponent;
        }
        return component;
    }

    public static IFormattableTextComponent addTooltipFlags(IFormattableTextComponent component, boolean showIcon, boolean strikethrough) {
        if (component instanceof TranslationTextComponent) {
            TranslationTextComponent translatable = (TranslationTextComponent)component;
            ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(translatable.func_150271_j()));
            if (showIcon) {
                params.add("show_icon");
            }
            if (strikethrough) {
                params.add("strikethrough");
            }
            IFormattableTextComponent newComponent = TooltipHandler.setComponentContents(component, params.toArray());
            if (strikethrough) {
                newComponent.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)7561572)));
            }
            return newComponent;
        }
        return component;
    }

    @SubscribeEvent
    public static void trackTooltipColor(RenderTooltipEvent.Color event) {
        TOOLTIP_BACKGROUND_COLOR = event.getBackground();
    }

    private static void addTooltip(int index, Tooltip tooltip, List<ITextComponent> elements) {
        TOOLTIP_INSERTIONS.add(index, tooltip);
        elements.add(index, TooltipHandler.getTooltipCode(tooltip.getClass()));
    }

    private static void setTooltip(int index, Tooltip tooltip, List<ITextComponent> elements) {
        TOOLTIP_INSERTIONS.set(index, tooltip);
        elements.set(index, TooltipHandler.getTooltipCode(tooltip.getClass()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void updateHoveredItem(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen menu = (ContainerScreen)event.getGui();
            Slot hoveredSlot = menu.getSlotUnderMouse();
            if (hoveredSlot == null) {
                return;
            }
            ItemStack stack = hoveredSlot.func_75211_c();
            EquipmentSlotType equipmentSlot = EntityHelper.getEquipmentSlot(hoveredSlot.field_75222_d);
            if (!HOVERED_STACK.equals(stack)) {
                if (stack.func_190926_b()) {
                    HOVERED_STACK = stack;
                    return;
                }
                if (HOVERED_ITEM_UPDATE_COOLDOWN <= 0 || ItemInsulationManager.getAllInsulatorsForStack(stack).stream().map(ConfigData::getId).anyMatch(id -> !HOVERED_STACK_PREDICATES.containsKey(id))) {
                    HOVERED_STACK = stack;
                    HOVERED_ITEM_UPDATE_COOLDOWN = 5;
                    ColdSweatPacketHandler.INSTANCE.sendToServer((Object)SyncItemPredicatesMessage.fromClient(stack, hoveredSlot.field_75222_d, equipmentSlot));
                }
            }
        }
    }

    @SubscribeEvent
    public static void tickHoverCooldown(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && HOVERED_ITEM_UPDATE_COOLDOWN > 0) {
            --HOVERED_ITEM_UPDATE_COOLDOWN;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addSimpleTooltips(ItemTooltipEvent event) {
        boolean hideTooltips;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        List elements = event.getToolTip();
        boolean bl = hideTooltips = ConfigSettings.HIDE_TOOLTIPS.get() != false && !TooltipHandler.isShiftDown();
        if (stack.func_190926_b()) {
            return;
        }
        TOOLTIP_INSERTIONS.clear();
        TOOLTIP_INSERTIONS.addAll(ListBuilder.begin(new Object[0]).fill(elements.size(), Object::new).build());
        int tooltipStartIndex = TooltipHandler.getTooltipTitleIndex(elements, stack);
        int tooltipEndIndex = TooltipHandler.getTooltipEndIndex(elements, stack);
        if (stack.func_77973_b() instanceof SoulspringLampItem) {
            if (!TooltipHandler.isShiftDown()) {
                elements.add(tooltipStartIndex, EXPAND_TOOLTIP);
            } else {
                for (int i = 0; i < CSMath.ceil((double)ConfigSettings.SOULSPRING_LAMP_FUEL.get().size() / 6.0) + 1; ++i) {
                    elements.add(tooltipStartIndex, new StringTextComponent(""));
                }
            }
            TooltipHandler.addTooltip(tooltipStartIndex, new ClientSoulspringTooltip(stack.func_196082_o().func_74769_h("Fuel")), elements);
        }
        if (stack.func_77975_n() == UseAction.DRINK || stack.func_77975_n() == UseAction.EAT) {
            int dietTooltipSectionIndex = CSMath.getIndexOf(elements, line -> line.getString().equalsIgnoreCase(new TranslationTextComponent("tooltip.diet.eaten").getString()));
            int index = dietTooltipSectionIndex != -1 ? dietTooltipSectionIndex + 1 : tooltipEndIndex;
            FastMap foodTemps = new FastMap();
            for (FoodData foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)item)) {
                if (!TooltipHandler.passesRequirement(foodData)) continue;
                foodTemps.merge(foodData.duration(), foodData.temperature(), Double::sum);
            }
            for (Map.Entry entry : foodTemps.entrySet()) {
                TranslationTextComponent consumeEffects;
                double temp = (Double)entry.getValue();
                int duration = (Integer)entry.getKey();
                Object object = temp > 0.0 ? new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}).func_240703_c_(HOT) : (consumeEffects = temp == 0.0 ? new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}) : new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{CSMath.formatDoubleOrInt(temp)}).func_240703_c_(COLD));
                if (duration > 0) {
                    consumeEffects.func_240702_b_(" (" + StringUtils.func_76337_a((int)duration) + ")");
                }
                elements.add(index, consumeEffects);
            }
            if (!foodTemps.isEmpty() && dietTooltipSectionIndex == -1) {
                elements.add(tooltipEndIndex, new TranslationTextComponent("tooltip.cold_sweat.consumed").func_240699_a_(TextFormatting.GRAY));
                elements.add(tooltipEndIndex, new StringTextComponent(""));
            }
        }
        if (!hideTooltips && !stack.func_190926_b()) {
            ArrayList<Insulation> armorInsulation = new ArrayList<Insulation>();
            ArrayList<Insulation> unmetArmorInsulation = new ArrayList<Insulation>();
            for (InsulatorData insulator : ConfigSettings.INSULATING_ARMORS.get().get((Object)item)) {
                TooltipHandler.validateInsulator(insulator, armorInsulation, unmetArmorInsulation);
            }
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
                if (cap.getInsulation().isEmpty()) {
                    cap.deserializeNBT(stack.func_196082_o());
                }
                List<Pair<ItemStack, Collection<InsulatorData>>> insulatorPairs = cap.getInsulation();
                for (int i = 0; i < insulatorPairs.size(); ++i) {
                    Pair<ItemStack, Collection<InsulatorData>> pair = insulatorPairs.get(i);
                    for (InsulatorData insulator : (Collection)pair.getSecond()) {
                        TooltipHandler.validateInsulator(insulator, armorInsulation, unmetArmorInsulation);
                    }
                }
            });
            if (!armorInsulation.isEmpty()) {
                TooltipHandler.addTooltip(tooltipStartIndex, new ClientInsulationTooltip(armorInsulation, Insulation.Slot.ARMOR, stack, false), elements);
            }
            if (!unmetArmorInsulation.isEmpty()) {
                TooltipHandler.addTooltip(tooltipStartIndex, new ClientInsulationTooltip(unmetArmorInsulation, Insulation.Slot.ARMOR, stack, true), elements);
            }
            ArrayList<Insulation> insulation = new ArrayList<Insulation>();
            ArrayList<Insulation> unmetInsulation = new ArrayList<Insulation>();
            for (InsulatorData insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)item)) {
                TooltipHandler.validateInsulator(insulator, insulation, unmetInsulation);
            }
            if (!insulation.isEmpty() && !insulation.equals(Insulation.splitList(armorInsulation))) {
                TooltipHandler.addTooltip(tooltipStartIndex, new ClientInsulationTooltip(insulation, Insulation.Slot.ITEM, stack, false), elements);
            }
            if (!unmetInsulation.isEmpty() && !unmetInsulation.equals(Insulation.splitList(unmetArmorInsulation))) {
                TooltipHandler.addTooltip(tooltipStartIndex, new ClientInsulationTooltip(unmetInsulation, Insulation.Slot.ITEM, stack, true), elements);
            }
            if (CompatManager.isCuriosLoaded()) {
                insulation = new ArrayList();
                unmetInsulation = new ArrayList();
                for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)item)) {
                    TooltipHandler.validateInsulator(insulator, insulation, unmetInsulation);
                }
                if (!insulation.isEmpty()) {
                    TooltipHandler.addTooltip(tooltipStartIndex, new ClientInsulationTooltip(insulation, Insulation.Slot.CURIO, stack, false), elements);
                }
                if (!unmetInsulation.isEmpty()) {
                    TooltipHandler.addTooltip(tooltipStartIndex, new ClientInsulationTooltip(unmetInsulation, Insulation.Slot.CURIO, stack, true), elements);
                }
            }
        }
        boolean foundUnmetAttribute = false;
        for (int i = 0; i < elements.size(); ++i) {
            List<Object> list;
            boolean strikethrough;
            TranslationTextComponent component;
            ITextComponent element = (ITextComponent)elements.get(i);
            if (!(element instanceof TranslationTextComponent) || (component = (TranslationTextComponent)element).func_150271_j() == null) continue;
            if (component.func_150268_i().contains("item.modifiers")) {
                foundUnmetAttribute = false;
            }
            if ((strikethrough = (list = Arrays.asList(component.func_150271_j())).contains("strikethrough")) && !foundUnmetAttribute) {
                IFormattableTextComponent unmetAttributesTooltip = new TranslationTextComponent("tooltip.cold_sweat.unmet_attributes").func_240699_a_(TextFormatting.RED);
                TooltipHandler.addTooltip(i, new ClientInsulationAttributeTooltip(unmetAttributesTooltip, Minecraft.func_71410_x().field_71466_p, false), elements);
                foundUnmetAttribute = true;
                ++i;
            }
            if (!list.contains("show_icon")) continue;
            TooltipHandler.setTooltip(i, new ClientInsulationAttributeTooltip((IFormattableTextComponent)component, Minecraft.func_71410_x().field_71466_p, strikethrough), elements);
        }
    }

    @SubscribeEvent
    public static void renderTooltips(RenderTooltipEvent.PostText event) {
        if (TOOLTIP_INSERTIONS.isEmpty()) {
            return;
        }
        int y = event.getY() - 10;
        List tooltipLines = event.getLines();
        for (int i = 0; i < Math.min(tooltipLines.size(), TOOLTIP_INSERTIONS.size()); ++i) {
            Tooltip nextTooltip;
            String tooltipID;
            Object nextInsertion;
            y += 10;
            ITextProperties tooltipLine = (ITextProperties)tooltipLines.get(i);
            String line = tooltipLine.getString();
            if (line.isEmpty() || !((nextInsertion = TOOLTIP_INSERTIONS.get(i)) instanceof Tooltip) || !line.equals(tooltipID = TOOLTIPS.get((nextTooltip = (Tooltip)nextInsertion).getClass()))) continue;
            nextTooltip.renderImage(Minecraft.func_71410_x().field_71466_p, event.getX(), y, event.getMatrixStack(), Minecraft.func_71410_x().func_175599_af(), 0);
            nextTooltip.renderText(Minecraft.func_71410_x().field_71466_p, event.getX(), y, event.getMatrixStack(), Minecraft.func_71410_x().func_175599_af(), 0);
        }
    }

    private static void validateInsulator(InsulatorData insulator, List<Insulation> insulation, List<Insulation> unmetInsulation) {
        boolean multiSlot = insulator.fillSlots();
        if (!insulator.insulation().isEmpty()) {
            List<Insulation> insulList;
            List<Insulation> list = insulList = multiSlot ? Insulation.splitList(insulator.insulation()) : insulator.insulation();
            if (TooltipHandler.passesRequirement(insulator)) {
                insulation.addAll(insulList);
            } else {
                unmetInsulation.addAll(insulList);
            }
        }
    }

    @SubscribeEvent
    public static void renderSoulLampInsertTooltip(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen inventoryScreen = (ContainerScreen)event.getGui();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && inventoryScreen.getSlotUnderMouse() != null && inventoryScreen.getSlotUnderMouse().func_75211_c().func_77973_b() == ModItems.SOULSPRING_LAMP) {
                double fuel = inventoryScreen.getSlotUnderMouse().func_75211_c().func_196082_o().func_74769_h("Fuel");
                ItemStack carriedStack = player.field_71071_by.func_70445_o();
                FuelData itemFuel = ConfigSettings.SOULSPRING_LAMP_FUEL.get().get((Object)carriedStack.func_77973_b()).stream().filter(predicate -> predicate.test(carriedStack)).findFirst().orElse(null);
                if (!carriedStack.func_190926_b() && itemFuel != null) {
                    double fuelValue = (double)carriedStack.func_190916_E() * itemFuel.fuel();
                    int slotX = inventoryScreen.getSlotUnderMouse().field_75223_e + ((ContainerScreen)event.getGui()).getGuiLeft();
                    int slotY = inventoryScreen.getSlotUnderMouse().field_75221_f + ((ContainerScreen)event.getGui()).getGuiTop();
                    MatrixStack ms = event.getMatrixStack();
                    if (event.getMouseY() < slotY + 8) {
                        ms.func_227861_a_(0.0, 32.0, 0.0);
                    }
                    event.getGui().func_238652_a_(ms, (ITextComponent)new StringTextComponent("       "), slotX - 18, slotY);
                    RenderSystem.defaultBlendFunc();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(ClientSoulspringTooltip.TOOLTIP_LOCATION.get());
                    AbstractGui.func_238464_a_((MatrixStack)ms, (int)(slotX - 7), (int)(slotY - 12), (int)401, (float)0.0f, (float)0.0f, (int)30, (int)8, (int)34, (int)30);
                    RenderSystem.enableBlend();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.15f + (float)((Math.sin((float)FUEL_FADE_TIMER / 5.0f) + 1.0) / 2.0) * 0.4f));
                    AbstractGui.func_238464_a_((MatrixStack)ms, (int)(slotX - 7), (int)(slotY - 12), (int)401, (float)0.0f, (float)8.0f, (int)Math.min(30, (int)((fuel + fuelValue) / (double)2.1333f)), (int)8, (int)34, (int)30);
                    RenderSystem.disableBlend();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    AbstractGui.func_238464_a_((MatrixStack)ms, (int)(slotX - 7), (int)(slotY - 12), (int)401, (float)0.0f, (float)16.0f, (int)((int)(fuel / (double)2.1333f)), (int)8, (int)34, (int)30);
                }
            }
        }
    }

    @SubscribeEvent
    public static void tickSoulLampInsertTooltip(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++FUEL_FADE_TIMER;
        }
    }

    private static void registerTooltip(Class<? extends Tooltip> tooltip) {
        if (!TOOLTIPS.containsKey(tooltip)) {
            if (TOOLTIP_REGISTRY_SIZE >= 63) {
                throw new RuntimeException("Too many tooltips registered!");
            }
            String code = Integer.toBinaryString(TOOLTIP_REGISTRY_SIZE);
            while (code.length() < 5) {
                code = "0" + code;
            }
            code = code.replace("0", "-");
            code = code.replace("1", "+");
            TOOLTIPS.put(tooltip, code);
            ++TOOLTIP_REGISTRY_SIZE;
        } else {
            throw new RegistryFailureException(tooltip, "Tooltips", "Tooltip already registered!", null);
        }
    }

    private static ITextComponent getTooltipCode(Class<? extends Tooltip> tooltip) {
        return new StringTextComponent(TOOLTIPS.get(tooltip)).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TOOLTIP_BACKGROUND_COLOR)));
    }

    static {
        TooltipHandler.registerTooltip(ClientInsulationTooltip.class);
        TooltipHandler.registerTooltip(ClientSoulspringTooltip.class);
        TooltipHandler.registerTooltip(ClientInsulationAttributeTooltip.class);
    }
}

