/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.Vec2f;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import com.momosoftworks.coldsweat.util.serialization.Triplet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class WetnessRenderer {
    private static final ResourceLocation WATER_DROP = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet.png");
    private static final ResourceLocation WATER_DROP_TRAIL = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet_trail.png");
    private static final List<Droplet> WATER_DROPS = new ArrayList<Droplet>();
    private static final List<Triplet<Vec2i, Float, Integer>> TRAILS = new ArrayList<Triplet<Vec2i, Float, Integer>>();
    private static boolean WAS_SUBMERGED = false;

    @SubscribeEvent
    public static void updateSkyBrightness(TickEvent.ClientTickEvent event) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level != null) {
            level.func_72966_v();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        int size;
        int i;
        boolean justExitedWater;
        ClientPlayerEntity player;
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || !ConfigSettings.WATER_EFFECT_SETTING.get().showGui()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack ps = event.getMatrixStack();
        float frametime = mc.func_193989_ak();
        int screenWidth = mc.func_228018_at_().func_198107_o();
        int screenHeight = mc.func_228018_at_().func_198087_p();
        boolean paused = mc.func_147113_T();
        int uiScale = mc.field_71474_y.field_74335_Z;
        if (uiScale == 0) {
            uiScale = mc.func_228018_at_().func_216521_a(0, mc.func_211821_e());
        }
        if ((player = mc.field_71439_g) == null) {
            return;
        }
        BlockPos playerPos = player.func_233580_cy_();
        float playerYVelocity = (float)(player.func_213303_ch().field_72448_b - player.field_70137_T);
        boolean isSubmerged = player.func_208600_a((ITag)FluidTags.field_206959_a);
        int light = player.field_70170_p.func_201696_r(playerPos.func_177984_a());
        if (player.func_70644_a(Effects.field_76439_r)) {
            light = 15;
        }
        float brightness = CSMath.blend(0.0f, 1.0f, light, 0.0f, 15.0f);
        float tempMult = (float)CSMath.blend(0.3, 6.0, Temperature.get((LivingEntity)player, Temperature.Trait.WORLD), ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get() * 2.0);
        if (isSubmerged && !paused) {
            TRAILS.clear();
            for (Droplet drop : WATER_DROPS) {
                drop.alpha -= 0.6f * frametime;
                float xMoveDir = drop.position.x < (float)screenWidth / 2.0f ? -1.0f : 1.0f;
                float yMoveDir = drop.position.y < (float)screenHeight / 2.0f ? -1.0f : 1.0f;
                drop.position.add(new Vec2f(xMoveDir, yMoveDir).mul(200.0f * -playerYVelocity * frametime));
            }
        }
        double wetness = Temperature.getModifier((LivingEntity)mc.field_71439_g, Temperature.Trait.WORLD, WaterTempModifier.class).map(arg_0 -> WetnessRenderer.lambda$onRenderOverlay$0((PlayerEntity)player, arg_0)).orElse(0.0);
        boolean bl = justExitedWater = WAS_SUBMERGED && !isSubmerged;
        if (justExitedWater) {
            for (int i2 = 0; i2 < 15; ++i2) {
                Droplet newDrop = WetnessRenderer.createDrop(screenWidth);
                newDrop.yMotion = WetnessRenderer.getRandomVelocity(frametime) / 2.0f + 0.3f;
                newDrop.position.y = (float)Math.random() * (float)screenHeight;
                WATER_DROPS.add(newDrop);
                int streakLength = (int)(Math.random() * 5.0) + 5;
                int x = (int)newDrop.position.x;
                int y = (int)newDrop.position.y;
                for (int j = 1; j < streakLength; ++j) {
                    TRAILS.add(new Triplet<Vec2i, Float, Integer>(new Vec2i(x, y - j), Float.valueOf(CSMath.blend(newDrop.alpha * 0.8f, 0.0f, j, 1.0f, streakLength)), newDrop.size / 2));
                }
            }
        }
        boolean bl2 = WAS_SUBMERGED = player.func_70089_S() && isSubmerged;
        if (!paused && !isSubmerged && wetness > (double)0.01f && (double)((float)Math.random()) * 0.05 < (double)0.0015f * wetness * (double)(frametime * 2.0f) && WATER_DROPS.size() < 5) {
            WATER_DROPS.add(WetnessRenderer.createDrop(screenWidth));
        }
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(WATER_DROP);
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (i = 0; i < WATER_DROPS.size(); ++i) {
            Droplet drop = WATER_DROPS.get(i);
            Vec2f pos = drop.position;
            float alpha = drop.alpha;
            size = drop.size / uiScale * 3;
            drop.size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(drop.size);
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuad(ps, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale), (int)pos.y, size, size, 0.0f, 0.0f, 1.0f, 1.0f, brightness, brightness, brightness, alpha);
                if (!paused) {
                    drop.alpha = wetness <= 0.0 ? (drop.alpha -= 0.08f * frametime) : (drop.alpha -= 0.003f * frametime * tempMult);
                    if (drop.yMotionUpdateCooldown <= 0.0f) {
                        drop.yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
                        drop.yMotion = WetnessRenderer.getRandomVelocity(frametime);
                    } else {
                        drop.yMotionUpdateCooldown -= frametime;
                    }
                    float dropMoveFromPlayerLook = -(player.field_70759_as - player.field_70758_at) / 20.0f;
                    dropMoveFromPlayerLook = (float)CSMath.shrink(dropMoveFromPlayerLook, 0.5);
                    drop.xVelocity = (float)CSMath.maxAbs((double)dropMoveFromPlayerLook * (Math.random() * 0.2), drop.xVelocity);
                    drop.xVelocity /= 1.0f + 0.6f * frametime;
                    if (drop.XMotionUpdateCooldown <= 0.0f) {
                        drop.XMotionUpdateCooldown = (float)Math.random() * 8.0f + 4.0f;
                        drop.xMotion = (float)Math.random() * 0.02f - 0.01f;
                    }
                    drop.XMotionUpdateCooldown -= frametime;
                    int oldY = (int)pos.y;
                    if (!isSubmerged) {
                        drop.position.add(new Vec2f(drop.xMotion * drop.yMotion * 20.0f + drop.xVelocity, drop.yMotion).div(uiScale).mul(3.0f));
                    }
                    for (int j = 0; j < Math.max(0, (int)(pos.y - (float)oldY)); ++j) {
                        TRAILS.add(new Triplet<Vec2i, Float, Integer>(new Vec2i((int)pos.x, oldY + j), Float.valueOf(alpha), size));
                    }
                }
                if (pos.x < -20.0f) {
                    pos.x = screenWidth + 20;
                } else if (pos.x > (float)(screenWidth + 20)) {
                    pos.x = -20.0f;
                }
                if (!(pos.y > (float)screenHeight)) continue;
                WATER_DROPS.remove(drop);
                --i;
                continue;
            }
            WATER_DROPS.remove(drop);
            --i;
        }
        Tessellator.func_178181_a().func_78381_a();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(WATER_DROP_TRAIL);
        for (i = 0; i < TRAILS.size(); ++i) {
            Triplet<Vec2i, Float, Integer> trail = TRAILS.get(i);
            Vec2i pos = trail.getA();
            float alpha = trail.getB().floatValue();
            size = trail.getC();
            size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(size);
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuad(ps, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale * 4.0f), pos.y, size, 1, 0.0f, 0.0f, 1.0f, 1.0f, brightness, brightness, brightness, alpha);
                if (paused) continue;
                TRAILS.set(i, new Triplet<Vec2i, Float, Integer>(new Vec2i(pos.x, pos.y), Float.valueOf(alpha - 0.045f * frametime), size));
                continue;
            }
            TRAILS.remove(trail);
            --i;
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private static float getRandomVelocity(float frametime) {
        return (float)Math.min((double)(0.7f * frametime * 20.0f), Math.pow(Math.random() * 5.0 + (double)0.1f, 3.0) * (double)frametime / 4.0);
    }

    private static Droplet createDrop(int screenWidth) {
        IntegerBounds dropSize = ConfigSettings.WATER_DROPLET_SCALE.get();
        int size = dropSize.getRandom();
        return new Droplet(new Vec2f((int)(Math.random() * (double)screenWidth), -size), 1.0f, size);
    }

    private static void renderQuad(MatrixStack poseStack, BufferBuilder bufferBuilder, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, float r, float g, float b, float a) {
        Matrix4f lastPose = poseStack.func_227866_c_().func_227870_a_();
        bufferBuilder.func_227888_a_(lastPose, (float)x, (float)y, 0.0f).func_225583_a_(u, v).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(lastPose, (float)x, (float)(y + height), 0.0f).func_225583_a_(u, v + vHeight).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(lastPose, (float)(x + width), (float)(y + height), 0.0f).func_225583_a_(u + uWidth, v + vHeight).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(lastPose, (float)(x + width), (float)y, 0.0f).func_225583_a_(u + uWidth, v).func_227885_a_(r, g, b, a).func_181675_d();
    }

    private static /* synthetic */ Double lambda$onRenderOverlay$0(PlayerEntity player, WaterTempModifier mod) {
        return CSMath.blend(0.0, 1.0, mod.getWetness(), 0.0, mod.getMaxStrength((LivingEntity)player));
    }

    protected static class Droplet {
        public Vec2f position;
        public float alpha;
        public int size;
        public float yMotion = (float)Math.random() * 0.05f + 0.05f;
        public float xMotion = (float)Math.random() * 0.02f - 0.01f;
        public float xVelocity = 0.0f;
        public float yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
        public float XMotionUpdateCooldown = 16.0f;

        public Droplet(Vec2f position, float alpha, int size) {
            this.position = position;
            this.alpha = alpha;
            this.size = size;
        }
    }
}

