/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Overlays {
    public static final ResourceLocation BODY_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge.png");
    public static final ResourceLocation BODY_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge_hc.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_hc.png");
    public static final Supplier<ResourceLocation> BODY_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? BODY_TEMP_GAUGE_HC : BODY_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> WORLD_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? WORLD_TEMP_GAUGE_HC : WORLD_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> VAGUE_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? VAGUE_TEMP_GAUGE_HC : VAGUE_TEMP_GAUGE;
    static boolean ADVANCED_WORLD_TEMP = false;
    public static double WORLD_TEMP = 0.0;
    static double PREV_WORLD_TEMP = 0.0;
    static double PLAYER_MAX_TEMP = 0.0;
    static double PLAYER_MIN_TEMP = 0.0;
    public static double BODY_TEMP = 0.0;
    public static double PREV_BODY_TEMP = 0.0;
    static int BLEND_BODY_TEMP = 0;
    static int ICON_BOB = 0;
    static double BODY_TEMP_SEVERITY = 0.0;

    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int severity;
            double temp;
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            MatrixStack poseStack = event.getMatrixStack();
            int width = event.getWindow().func_198107_o();
            int height = event.getWindow().func_198087_p();
            if (player != null && (ADVANCED_WORLD_TEMP && Minecraft.func_71410_x().field_71442_b.func_178889_l() != GameType.SPECTATOR && !Minecraft.func_71410_x().field_71474_y.field_74319_N && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue() || player.func_184812_l_())) {
                int color;
                temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
                severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
                switch (severity) {
                    case 2: 
                    case 3: {
                        color = 16297781;
                        break;
                    }
                    case 4: {
                        color = 16728089;
                        break;
                    }
                    case -3: 
                    case -2: {
                        color = 8443135;
                        break;
                    }
                    case -4: {
                        color = 4236031;
                        break;
                    }
                    default: {
                        color = 14737376;
                    }
                }
                poseStack.func_227860_a_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(WORLD_TEMP_GAUGE_LOCATION.get());
                AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(width / 2 + 93 + ConfigSettings.WORLD_GAUGE_POS.get().x()), (int)(height - 19 + ConfigSettings.WORLD_GAUGE_POS.get().y()), (float)0.0f, (float)(64 - severity * 16), (int)25, (int)16, (int)25, (int)144);
                RenderSystem.disableBlend();
                int bob = ConfigSettings.ICON_BOBBING.get() != false && !CSMath.betweenInclusive(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP) && player.field_70173_aa % 2 == 0 ? 1 : 0;
                int blendedTemp = (int)CSMath.blend(PREV_WORLD_TEMP, WORLD_TEMP, (double)Minecraft.func_71410_x().func_184121_ak(), 0.0, 1.0);
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(poseStack, blendedTemp + ConfigSettings.TEMP_OFFSET.get() + "", (float)(width / 2 + 106 + Integer.toString(blendedTemp + ConfigSettings.TEMP_OFFSET.get()).length() * -3 + ConfigSettings.WORLD_GAUGE_POS.get().x()), (float)(height - 15 - bob + ConfigSettings.WORLD_GAUGE_POS.get().y()), color);
                poseStack.func_227865_b_();
            }
            if (mc.field_71442_b.func_78755_b() && mc.func_175606_aa() instanceof PlayerEntity && !Minecraft.func_71410_x().field_71474_y.field_74319_N) {
                int color;
                BLEND_BODY_TEMP = (int)CSMath.blend(PREV_BODY_TEMP, BODY_TEMP, (double)Minecraft.func_71410_x().func_184121_ak(), 0.0, 1.0);
                switch ((int)BODY_TEMP_SEVERITY) {
                    case -7: 
                    case 7: {
                        color = 0xFFFFFF;
                        break;
                    }
                    case 6: {
                        color = 0xFFFFAC;
                        break;
                    }
                    case 5: {
                        color = 16767856;
                        break;
                    }
                    case 4: {
                        color = 16759634;
                        break;
                    }
                    case 3: {
                        color = 16751174;
                        break;
                    }
                    case -3: {
                        color = 6078975;
                        break;
                    }
                    case -4: {
                        color = 7528447;
                        break;
                    }
                    case -5: {
                        color = 0x84F4FF;
                        break;
                    }
                    case -6: {
                        color = 0xB0FFFF;
                        break;
                    }
                    default: {
                        int n = BLEND_BODY_TEMP > 0 ? 16744509 : (color = BLEND_BODY_TEMP < 0 ? 4233468 : 0xAFAFAF);
                    }
                }
                int colorBG = BLEND_BODY_TEMP < 0 ? 1122643 : (BLEND_BODY_TEMP > 0 ? 5376516 : 0);
                int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
                int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.func_71410_x().field_175622_Z.field_70173_aa % 2 : 0));
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(BODY_TEMP_GAUGE_LOCATION.get());
                if (ConfigSettings.BODY_ICON_ENABLED.get().booleanValue()) {
                    int icon = Math.abs(BLEND_BODY_TEMP) < 100 ? CSMath.floor(BODY_TEMP_SEVERITY) : 4 * CSMath.sign(BODY_TEMP_SEVERITY);
                    int iconX = width / 2 - 5 + ConfigSettings.BODY_ICON_POS.get().x();
                    int iconYOffset = ADVANCED_WORLD_TEMP && ConfigSettings.MOVE_BODY_ICON_WHEN_ADVANCED.get() != false ? 54 : 47;
                    int iconY = height - iconYOffset - threatOffset + ConfigSettings.BODY_ICON_POS.get().y();
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)iconX, (int)iconY, (float)0.0f, (float)(40 - icon * 10), (int)10, (int)10, (int)10, (int)90);
                    if (CSMath.betweenExclusive(Math.abs(BLEND_BODY_TEMP), 0.0, 100.0)) {
                        double blend = CSMath.blend(1.0, 9.0, Math.abs(BODY_TEMP_SEVERITY), (double)Math.abs(CSMath.floor(BODY_TEMP_SEVERITY)), (double)Math.abs(CSMath.ceil(BODY_TEMP_SEVERITY)));
                        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)iconX, (int)(iconY + 10 - CSMath.ceil(blend)), (float)0.0f, (float)(40 - CSMath.grow(icon, BLEND_BODY_TEMP > 0 ? 0 : 2) * 10 - CSMath.ceil(blend)), (int)10, (int)CSMath.ceil(blend), (int)10, (int)90);
                    }
                }
                if (ConfigSettings.BODY_READOUT_ENABLED.get().booleanValue() && ADVANCED_WORLD_TEMP) {
                    FontRenderer font = mc.field_71466_p;
                    int scaledWidth = mc.func_228018_at_().func_198107_o();
                    int scaledHeight = mc.func_228018_at_().func_198087_p();
                    String s = "" + Math.min(Math.abs(BLEND_BODY_TEMP), 100);
                    int x = (scaledWidth - font.func_78256_a(s)) / 2 + ConfigSettings.BODY_READOUT_POS.get().x();
                    int y = scaledHeight - 31 - 10 + ConfigSettings.BODY_READOUT_POS.get().y();
                    font.func_238421_b_(poseStack, s, (float)(x + 1), (float)y, colorBG);
                    font.func_238421_b_(poseStack, s, (float)(x - 1), (float)y, colorBG);
                    font.func_238421_b_(poseStack, s, (float)x, (float)(y + 1), colorBG);
                    font.func_238421_b_(poseStack, s, (float)x, (float)(y - 1), colorBG);
                    font.func_238421_b_(poseStack, s, (float)x, (float)y, color);
                }
            }
            if (player != null && !ADVANCED_WORLD_TEMP && mc.field_71442_b.func_178889_l() != GameType.SPECTATOR && !mc.field_71474_y.field_74319_N && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue() && Minecraft.func_71410_x().field_71442_b.func_78755_b()) {
                temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
                severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
                int renderOffset = CSMath.clamp(severity, -1, 1) * 2;
                poseStack.func_227860_a_();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
                int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.func_71410_x().field_175622_Z.field_70173_aa % 2 : 0));
                mc.field_71446_o.func_110577_a(VAGUE_TEMP_GAUGE_LOCATION.get());
                AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(width / 2 - 8 + ConfigSettings.BODY_ICON_POS.get().x()), (int)(height - 50 + ConfigSettings.BODY_ICON_POS.get().y() - renderOffset - threatOffset), (float)0.0f, (float)(64 - severity * 16), (int)16, (int)16, (int)16, (int)144);
                poseStack.func_227865_b_();
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase == TickEvent.Phase.START && player != null && player.func_70089_S()) {
            EntityTempManager.getTemperatureCap((Entity)player).ifPresent(arg_0 -> Overlays.lambda$onClientTick$3((PlayerEntity)player, arg_0));
        }
    }

    public static double getWorldSeverity(double temp, double playerMin, double playerMax) {
        double normalMax;
        if (temp < playerMin) {
            return -1.0;
        }
        if (temp > playerMax) {
            return 1.0;
        }
        double normalMin = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MIN_TEMP);
        double mid = Overlays.calculateMidpoint(playerMin, playerMax, normalMin, normalMax = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MAX_TEMP).doubleValue());
        return temp < mid ? CSMath.blend(-1.0, 0.0, temp, playerMin, mid) : CSMath.blend(0.0, 1.0, temp, mid, playerMax);
    }

    private static double calculateMidpoint(double playerMin, double playerMax, double normalMin, double normalMax) {
        boolean bothBelowNormal = playerMin < normalMin && playerMax < normalMax;
        boolean bothAboveNormal = playerMin > normalMin && playerMax > normalMax;
        return bothBelowNormal || bothAboveNormal ? (playerMin + playerMax) / 2.0 : (normalMin + normalMax) / 2.0;
    }

    public static int getGaugeSeverity(double temp, double playerMin, double playerMax) {
        return (int)(Overlays.getWorldSeverity(temp, playerMin, playerMax) * 4.0);
    }

    static double getBodySeverity(int temp) {
        int sign = CSMath.sign(temp);
        int absTemp = Math.abs(temp);
        return (absTemp < 100 ? CSMath.blend(0.0, 3.0, (double)absTemp, 0.0, 100.0) : CSMath.blend(3.0, 7.0, (double)absTemp, 100.0, 150.0)) * (double)sign;
    }

    public static void setBodyTempInstant(double temp) {
        BODY_TEMP = temp;
        PREV_BODY_TEMP = temp;
        BLEND_BODY_TEMP = (int)temp;
    }

    public static void setWorldTempInstant(double temp) {
        WORLD_TEMP = temp;
        PREV_WORLD_TEMP = temp;
    }

    private static /* synthetic */ void lambda$onClientTick$3(PlayerEntity player, ITemperatureCap icap) {
        if (!(icap instanceof PlayerTempCap)) {
            return;
        }
        PlayerTempCap cap = (PlayerTempCap)icap;
        cap.calculateHudVisibility(player);
        ADVANCED_WORLD_TEMP = cap.showAdvancedWorldTemp();
        boolean celsius = ConfigSettings.CELSIUS.get();
        double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
        double realTemp = Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true);
        double diff = realTemp - WORLD_TEMP;
        PREV_WORLD_TEMP = WORLD_TEMP;
        WORLD_TEMP += Math.abs(diff) <= 1.0 ? diff : CSMath.maxAbs(diff / ConfigSettings.TEMP_SMOOTHING.get(), 0.25 * (double)CSMath.sign(diff));
        PLAYER_MAX_TEMP = cap.getTrait(Temperature.Trait.BURNING_POINT);
        PLAYER_MIN_TEMP = cap.getTrait(Temperature.Trait.FREEZING_POINT);
        PREV_BODY_TEMP = BODY_TEMP;
        double currentTemp = cap.getTrait(Temperature.Trait.BODY);
        BODY_TEMP = Math.abs(currentTemp - BODY_TEMP) < 0.1 ? currentTemp : BODY_TEMP + (cap.getTrait(Temperature.Trait.BODY) - BODY_TEMP) / 5.0;
        ICON_BOB = player.field_70173_aa % 3 == 0 && Math.random() < 0.3 ? 1 : 0;
        BODY_TEMP_SEVERITY = Overlays.getBodySeverity(BLEND_BODY_TEMP);
        BODY_TEMP_SEVERITY = Overlays.getBodySeverity(BLEND_BODY_TEMP);
    }
}

