/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.gui.config.ConfigButton;
import com.momosoftworks.coldsweat.client.gui.config.ConfigLabel;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.client.gui.config.ConfigSliderButton;
import com.momosoftworks.coldsweat.client.gui.config.ImageWidget;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public abstract class AbstractConfigPage
extends Screen {
    static int MOUSE_STILL_TIMER = 0;
    static int TOOLTIP_DELAY = 5;
    private final Screen parentScreen;
    public Map<String, Pair<List<IGuiEventListener>, Boolean>> widgetBatches = new HashMap<String, Pair<List<IGuiEventListener>, Boolean>>();
    public Map<String, List<ITextComponent>> tooltips = new HashMap<String, List<ITextComponent>>();
    protected int rightSideLength = 0;
    protected int leftSideLength = 0;
    private static final int TITLE_HEIGHT = 16;
    private static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    private static final int BOTTOM_BUTTON_WIDTH = 150;
    public static Minecraft MINECRAFT = Minecraft.func_71410_x();
    static ResourceLocation TEXTURE = new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png");
    ImageButton nextNavButton;
    ImageButton prevNavButton;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ++MOUSE_STILL_TIMER;
    }

    public void func_212927_b(double mouseX, double mouseY) {
        MOUSE_STILL_TIMER = 0;
        super.func_212927_b(mouseX, mouseY);
    }

    public abstract ITextComponent sectionOneTitle();

    @Nullable
    public abstract ITextComponent sectionTwoTitle();

    public AbstractConfigPage(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("cold_sweat.config.title"));
        this.parentScreen = parentScreen;
    }

    protected void addEmptySpace(Side side, double height) {
        if (side == Side.LEFT) {
            this.leftSideLength += (int)(25.0 * height);
        } else {
            this.rightSideLength += (int)(25.0 * height);
        }
    }

    protected void addLabel(String id, Side side, String text, int color) {
        int labelX = side == Side.LEFT ? this.field_230708_k_ / 2 - 185 : this.field_230708_k_ / 2 + 51;
        int labelY = this.field_230709_l_ / 4 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        ConfigLabel label = new ConfigLabel(id, text, labelX, labelY, color);
        this.addWidgetBatch(id, Arrays.asList(new IGuiEventListener[]{label}), true);
        if (side == Side.LEFT) {
            this.field_230712_o_.getClass();
            this.leftSideLength += 9 + 4;
        } else {
            this.field_230712_o_.getClass();
            this.rightSideLength += 9 + 4;
        }
    }

    protected void addLabel(String id, Side side, String text) {
        this.addLabel(id, side, text, 0xFFFFFF);
    }

    protected void addButton(String id, Side side, Supplier<IFormattableTextComponent> dynamicLabel, Consumer<Button> onClick, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, IFormattableTextComponent ... tooltip) {
        IFormattableTextComponent label = dynamicLabel.get();
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.field_71439_g == null || AbstractConfigPage.MINECRAFT.field_71439_g.func_211513_k(2);
        int buttonX = this.field_230708_k_ / 2;
        int xOffset = side == Side.LEFT ? -179 : 56;
        int buttonY = this.field_230709_l_ / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        int buttonWidth = 152 + Math.max(0, this.field_230712_o_.func_238414_a_((ITextProperties)label) - 140);
        ConfigButton button = new ConfigButton(buttonX + xOffset, buttonY, buttonWidth, 20, label, button1 -> {
            onClick.accept(button1);
            button1.func_238482_a_((ITextComponent)dynamicLabel.get());
        }){

            @Override
            public boolean setsCustomDifficulty() {
                return setsCustomDifficulty;
            }
        };
        button.field_230693_o_ = shouldBeActive;
        if (clientside) {
            this.func_230481_d_((IGuiEventListener)new ImageWidget(TEXTURE, this.field_230708_k_ / 2 + xOffset - 18, buttonY + 3, 16, 15, 0, 144));
        }
        ArrayList<IFormattableTextComponent> tooltipList = new ArrayList<IFormattableTextComponent>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add(new TranslationTextComponent("cold_sweat.config.clientside_warning").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, Arrays.asList(new IGuiEventListener[]{button}), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void addDecimalInput(String id, Side side, IFormattableTextComponent label, final Consumer<Double> onEdited, Consumer<TextFieldWidget> onInit, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, IFormattableTextComponent ... tooltip) {
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.field_71439_g == null || AbstractConfigPage.MINECRAFT.field_71439_g.func_211513_k(2);
        int xOffset = side == Side.LEFT ? -82 : 151;
        int yOffset = (side == Side.LEFT ? this.leftSideLength : this.rightSideLength) - 2;
        int labelOffset = this.field_230712_o_.func_78256_a(label.getString()) > 90 ? this.field_230712_o_.func_78256_a(label.getString()) - 84 : 0;
        TextFieldWidget textBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + xOffset + labelOffset, this.field_230709_l_ / 4 - 6 + yOffset, 51, 22, (ITextComponent)new StringTextComponent("")){

            public void onEdit() {
                CSMath.tryCatch(() -> {
                    onEdited.accept(Double.parseDouble(this.func_146179_b()));
                    if (setsCustomDifficulty) {
                        ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
                    }
                });
            }

            public void func_146191_b(String text) {
                super.func_146191_b(text);
                this.onEdit();
            }

            public void func_146177_a(int i) {
                super.func_146177_a(i);
                this.onEdit();
            }

            public void func_146175_b(int i) {
                super.func_146175_b(i);
                this.onEdit();
            }
        };
        textBox.func_146184_c(shouldBeActive);
        onInit.accept(textBox);
        textBox.func_146180_a(ConfigScreen.TWO_PLACES.format(Double.parseDouble(textBox.func_146179_b())));
        ConfigLabel configLabel = new ConfigLabel(id, label.getString(), this.field_230708_k_ / 2 + xOffset - 95, this.field_230709_l_ / 4 + yOffset, shouldBeActive ? 0xFFFFFF : 0x808080);
        if (clientside) {
            this.func_230481_d_((IGuiEventListener)new ImageWidget(TEXTURE, this.field_230708_k_ / 2 + xOffset - 115, this.field_230709_l_ / 4 - 4 + yOffset, 16, 15, 0, 144));
        }
        ArrayList<IFormattableTextComponent> tooltipList = new ArrayList<IFormattableTextComponent>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add(new TranslationTextComponent("cold_sweat.config.clientside_warning").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, Arrays.asList(new IGuiEventListener[]{textBox, configLabel}), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength = (int)((double)this.leftSideLength + 30.0);
        } else {
            this.rightSideLength = (int)((double)this.rightSideLength + 30.0);
        }
    }

    protected void addDirectionPanel(String id, Side side, IFormattableTextComponent label, Consumer<Integer> leftRightPressed, Consumer<Integer> upDownPressed, Runnable reset, Supplier<Boolean> hide, boolean requireOP, boolean setsCustomDifficulty, boolean clientside, boolean canHide, IFormattableTextComponent ... tooltip) {
        int xOffset = side == Side.LEFT ? -97 : 136;
        int yOffset = side == Side.LEFT ? this.leftSideLength : this.rightSideLength;
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.field_71439_g == null || AbstractConfigPage.MINECRAFT.field_71439_g.func_211513_k(2);
        int labelWidth = this.field_230712_o_.func_78256_a(label.getString());
        int labelOffset = labelWidth > 84 ? labelWidth - 84 : 0;
        ArrayList<IGuiEventListener> widgetBatch = new ArrayList<IGuiEventListener>();
        ImageButton leftButton = new ImageButton(this.field_230708_k_ / 2 + xOffset + labelOffset, this.field_230709_l_ / 4 - 8 + yOffset, 14, 20, 0, 0, 20, TEXTURE, button -> {
            leftRightPressed.accept(-1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        leftButton.field_230693_o_ = shouldBeActive;
        widgetBatch.add((IGuiEventListener)leftButton);
        ImageButton upButton = new ImageButton(this.field_230708_k_ / 2 + xOffset + 14 + labelOffset, this.field_230709_l_ / 4 - 8 + yOffset, 20, 10, 14, 0, 20, TEXTURE, button -> {
            upDownPressed.accept(-1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        upButton.field_230693_o_ = shouldBeActive;
        widgetBatch.add((IGuiEventListener)upButton);
        ImageButton downButton = new ImageButton(this.field_230708_k_ / 2 + xOffset + 14 + labelOffset, this.field_230709_l_ / 4 + 2 + yOffset, 20, 10, 14, 10, 20, TEXTURE, button -> {
            upDownPressed.accept(1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        downButton.field_230693_o_ = shouldBeActive;
        widgetBatch.add((IGuiEventListener)downButton);
        ImageButton rightButton = new ImageButton(this.field_230708_k_ / 2 + xOffset + 34 + labelOffset, this.field_230709_l_ / 4 - 8 + yOffset, 14, 20, 34, 0, 20, TEXTURE, button -> {
            leftRightPressed.accept(1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        rightButton.field_230693_o_ = shouldBeActive;
        widgetBatch.add((IGuiEventListener)rightButton);
        ImageButton resetButton = new ImageButton(this.field_230708_k_ / 2 + xOffset + 52 + labelOffset, this.field_230709_l_ / 4 - 8 + yOffset, 20, canHide ? 10 : 20, canHide ? 68 : 48, 0, 20, TEXTURE, button -> {
            reset.run();
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        resetButton.field_230693_o_ = shouldBeActive;
        widgetBatch.add((IGuiEventListener)resetButton);
        if (canHide) {
            ImageButton hideButton = new ImageButton(this.field_230708_k_ / 2 + xOffset + 52 + labelOffset, this.field_230709_l_ / 4 + 2 + yOffset, 20, 10, 68, 10, 20, TEXTURE, button -> {
                if (setsCustomDifficulty) {
                    ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
                }
                AbstractConfigPage.setButtonImageX((ImageButton)button, (Boolean)hide.get() != false ? 68 : 88);
            });
            hide.get();
            AbstractConfigPage.setButtonImageX(hideButton, hide.get() != false ? 68 : 88);
            hideButton.field_230693_o_ = shouldBeActive;
            widgetBatch.add((IGuiEventListener)hideButton);
        }
        ConfigLabel configLabel = new ConfigLabel(id, label.getString(), this.field_230708_k_ / 2 + xOffset - 79, this.field_230709_l_ / 4 + yOffset, shouldBeActive ? 0xFFFFFF : 0x808080);
        if (clientside) {
            this.func_230481_d_((IGuiEventListener)new ImageWidget(TEXTURE, this.field_230708_k_ / 2 + xOffset - 98, this.field_230709_l_ / 4 - 8 + yOffset + 5, 16, 15, 0, 144));
        }
        widgetBatch.add((IGuiEventListener)configLabel);
        ArrayList<IFormattableTextComponent> tooltipList = new ArrayList<IFormattableTextComponent>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add(new TranslationTextComponent("cold_sweat.config.clientside_warning").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, widgetBatch, shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength = (int)((double)this.leftSideLength + 30.0);
        } else {
            this.rightSideLength = (int)((double)this.rightSideLength + 30.0);
        }
    }

    protected void addSliderButton(String id, Side side, final Supplier<ITextComponent> dynamicLabel, final double minVal, final double maxVal, final BiConsumer<Double, ConfigSliderButton> onChanged, Consumer<ConfigSliderButton> onInit, boolean requireOP, boolean clientside, IFormattableTextComponent ... tooltip) {
        ITextComponent label = dynamicLabel.get();
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.field_71439_g == null || AbstractConfigPage.MINECRAFT.field_71439_g.func_211513_k(2);
        int buttonX = this.field_230708_k_ / 2;
        int xOffset = side == Side.LEFT ? -179 : 56;
        int buttonY = this.field_230709_l_ / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        ConfigSliderButton sliderButton = new ConfigSliderButton(buttonX + xOffset, buttonY, label, 0.0, 1.0, 0.0, button -> {}, slider -> onChanged.accept(CSMath.blend(minVal, maxVal, CSMath.truncate(slider.sliderValue, 2), 0.0, 1.0), (ConfigSliderButton)slider)){

            public void updateSlider() {
                super.updateSlider();
                this.func_238482_a_((ITextComponent)dynamicLabel.get());
                onChanged.accept(CSMath.blend(minVal, maxVal, CSMath.truncate(this.sliderValue, 2), 0.0, 1.0), this);
            }
        };
        sliderButton.field_230693_o_ = shouldBeActive;
        onInit.accept(sliderButton);
        if (clientside) {
            this.func_230481_d_((IGuiEventListener)new ImageWidget(TEXTURE, this.field_230708_k_ / 2 + xOffset - 115, buttonY, 16, 15, 0, 144));
        }
        ArrayList<IFormattableTextComponent> tooltipList = new ArrayList<IFormattableTextComponent>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add(new TranslationTextComponent("cold_sweat.config.clientside_warning").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, Arrays.asList(new IGuiEventListener[]{sliderButton}), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void func_231160_c_() {
        this.leftSideLength = 0;
        this.rightSideLength = 0;
        this.func_230481_d_((IGuiEventListener)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ - 26, 150, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.close()));
        this.nextNavButton = new ImageButton(this.field_230708_k_ - 32, 12, 20, 20, 0, 88, 20, TEXTURE, button -> MINECRAFT.func_147108_a(ConfigScreen.getPage(++ConfigScreen.CURRENT_PAGE, this.parentScreen)));
        if (ConfigScreen.CURRENT_PAGE < ConfigScreen.LAST_PAGE) {
            this.func_230481_d_((IGuiEventListener)this.nextNavButton);
        }
        this.prevNavButton = new ImageButton(this.field_230708_k_ - 76, 12, 20, 20, 20, 88, 20, TEXTURE, button -> MINECRAFT.func_147108_a(ConfigScreen.getPage(--ConfigScreen.CURRENT_PAGE, this.parentScreen)));
        if (ConfigScreen.CURRENT_PAGE > ConfigScreen.FIRST_PAGE) {
            this.func_230481_d_((IGuiEventListener)this.prevNavButton);
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        AbstractConfigPage.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)16, (int)0xFFFFFF);
        AbstractConfigPage.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(ConfigScreen.CURRENT_PAGE + 1 + "/" + (ConfigScreen.LAST_PAGE + 1)), (int)(this.field_230708_k_ - 53), (int)18, (int)0xFFFFFF);
        AbstractConfigPage.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.sectionOneTitle(), (int)(this.field_230708_k_ / 2 - 204), (int)(this.field_230709_l_ / 4 - 28), (int)0xFFFFFF);
        this.field_230706_i_.field_71446_o.func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 202, this.field_230709_l_ / 4 - 16, 255, 0, 1, 154);
        if (this.sectionTwoTitle() != null) {
            AbstractConfigPage.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.sectionTwoTitle(), (int)(this.field_230708_k_ / 2 + 32), (int)(this.field_230709_l_ / 4 - 28), (int)0xFFFFFF);
            this.field_230706_i_.field_71446_o.func_110577_a(TEXTURE);
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 34, this.field_230709_l_ / 4 - 16, 255, 0, 1, 154);
        }
        this.field_230705_e_.forEach(listener -> {
            if (listener instanceof Widget) {
                ((Widget)listener).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        });
        if (this.func_231041_ay__()) {
            MOUSE_STILL_TIMER = 0;
        }
        if (MOUSE_STILL_TIMER < TOOLTIP_DELAY) {
            return;
        }
        for (Map.Entry<String, Pair<List<IGuiEventListener>, Boolean>> entry : this.widgetBatches.entrySet()) {
            List<ITextComponent> tooltipList;
            String id = entry.getKey();
            List widgets = (List)entry.getValue().getFirst();
            boolean enabled = (Boolean)entry.getValue().getSecond();
            int minX = 0;
            int minY = 0;
            int maxX = 0;
            int maxY = 0;
            for (IGuiEventListener listener2 : widgets) {
                if (!(listener2 instanceof Widget)) continue;
                Widget widget = (Widget)listener2;
                if (minX == 0 || widget.field_230690_l_ < minX) {
                    minX = widget.field_230690_l_;
                }
                if (minY == 0 || widget.field_230691_m_ < minY) {
                    minY = widget.field_230691_m_;
                }
                if (maxX == 0 || widget.field_230690_l_ + widget.func_230998_h_() > maxX) {
                    maxX = widget.field_230690_l_ + widget.func_230998_h_();
                }
                if (maxY != 0 && widget.field_230691_m_ + widget.func_238483_d_() <= maxY) continue;
                maxY = widget.field_230691_m_ + widget.func_238483_d_();
            }
            if (!CSMath.betweenInclusive(mouseX, minX, maxX) || !CSMath.betweenInclusive(mouseY, minY, maxY)) continue;
            List<ITextComponent> list = tooltipList = enabled ? this.tooltips.get(id) : Arrays.asList(new TranslationTextComponent("cold_sweat.config.require_op").func_240699_a_(TextFormatting.RED));
            if (tooltipList == null || tooltipList.isEmpty()) break;
            this.func_243308_b(matrixStack, tooltipList, mouseX, mouseY);
            break;
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
    }

    public boolean func_231177_au__() {
        return true;
    }

    public void close() {
        this.func_231175_as__();
        Minecraft.func_71410_x().func_147108_a(this.parentScreen);
    }

    protected void addWidgetBatch(String id, List<IGuiEventListener> elements, boolean enabled) {
        for (IGuiEventListener element : elements) {
            if (!(element instanceof Widget)) continue;
            this.func_230481_d_((IGuiEventListener)((Widget)element));
        }
        this.widgetBatches.put(id, (Pair<List<IGuiEventListener>, Boolean>)Pair.of(elements, (Object)enabled));
    }

    public List<IGuiEventListener> getWidgetBatch(String id) {
        return (List)this.widgetBatches.get(id).getFirst();
    }

    protected void setTooltip(String id, List<IFormattableTextComponent> tooltip) {
        ArrayList wrappedTooltip = new ArrayList();
        for (IFormattableTextComponent component : tooltip) {
            List wrappedText = this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)component, 300, component.func_150256_b());
            wrappedTooltip.addAll(wrappedText.stream().map(text -> new StringTextComponent(text.getString()).func_240703_c_(component.func_150256_b())).collect(Collectors.toList()));
        }
        this.tooltips.put(id, wrappedTooltip);
    }

    public static void setButtonImageX(ImageButton button, int x) {
        Field imageX = ObfuscationReflectionHelper.findField(ImageButton.class, (String)"field_191747_p");
        imageX.setAccessible(true);
        try {
            imageX.set(button, x);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_231175_as__() {
        MINECRAFT.func_147108_a(this.parentScreen);
        ConfigScreen.saveConfig();
    }

    public IFormattableTextComponent getToggleButtonText(IFormattableTextComponent text, boolean on) {
        return text.func_240702_b_(": ").func_230529_a_(on ? DialogTexts.field_240630_a_ : DialogTexts.field_240631_b_);
    }

    public <T extends Enum<T>> IFormattableTextComponent getEnumButtonText(IFormattableTextComponent text, T value) {
        return text.func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(((StringRepresentable)((Object)value)).func_176610_l()));
    }

    public <T extends Enum<T>> T getNextCycle(T current) {
        Enum[] values = (Enum[])current.getDeclaringClass().getEnumConstants();
        int index = (current.ordinal() + 1) % values.length;
        return (T)values[index];
    }

    public IFormattableTextComponent getSliderPercentageText(IFormattableTextComponent message, double value, double offAt) {
        return message.func_240702_b_(": ").func_230529_a_((ITextComponent)(Double.compare(offAt, value) != 0 ? new StringTextComponent((int)(value * 100.0) + "%") : new StringTextComponent(DialogTexts.field_240631_b_.getString())));
    }

    public IFormattableTextComponent getSliderText(IFormattableTextComponent message, int value, int min, int max, int offAt) {
        return message.func_240702_b_(": ").func_230529_a_((ITextComponent)((value > min || value < max) && value != offAt ? new StringTextComponent(value + "") : new StringTextComponent(DialogTexts.field_240631_b_.getString())));
    }

    public IFormattableTextComponent getSliderText(IFormattableTextComponent message, double value, double min, double max, double offAt) {
        return message.func_240702_b_(": ").func_230529_a_((ITextComponent)((value > min || value < max) && Double.compare(value, offAt) != 0 ? new StringTextComponent(CSMath.truncate(value, 1) + "") : new StringTextComponent(DialogTexts.field_240631_b_.getString())));
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

