/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.tooltip;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.client.gui.tooltip.Tooltip;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientInsulationTooltip
extends Tooltip {
    private static final ResourceLocation TOOLTIP = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar.png");
    private static final ResourceLocation TOOLTIP_HC = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar_hc.png");
    public static final Supplier<ResourceLocation> TOOLTIP_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? TOOLTIP_HC : TOOLTIP;
    private static final Minecraft MC = Minecraft.func_71410_x();
    List<Insulation> insulation;
    Insulation.Slot slot;
    int width = 0;
    ItemStack stack;
    boolean strikethrough;
    private static final Method INNER_BLIT = ObfuscationReflectionHelper.findMethod(AbstractGui.class, (String)"func_238469_a_", (Class[])new Class[]{MatrixStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE});
    static boolean RECURSIVE;

    public static void innerBlit(MatrixStack poseStack, int x1, int x2, int y1, int y2, int zOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        try {
            INNER_BLIT.invoke(null, poseStack, x1, x2, y1, y2, zOffset, uWidth, vHeight, Float.valueOf(uOffset), Float.valueOf(vOffset), textureWidth, textureHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void blit(MatrixStack poseStack, int x, int y, int zOffset, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        ClientInsulationTooltip.innerBlit(poseStack, x, x + width, y, y + height, zOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public ClientInsulationTooltip(List<Insulation> insulation, Insulation.Slot slot, ItemStack stack, boolean strikethrough) {
        if (slot != Insulation.Slot.ITEM) {
            insulation = Insulation.splitList(insulation);
        }
        this.insulation = insulation;
        this.slot = slot;
        this.stack = stack;
        this.strikethrough = strikethrough;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public int getWidth(FontRenderer font) {
        return this.width + 12;
    }

    @Override
    public void renderImage(FontRenderer font, int x, int y, MatrixStack poseStack, ItemRenderer itemRenderer, int depth) {
        y += 2;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        ArrayList<Insulation> posInsulation = new ArrayList<Insulation>();
        ArrayList<Insulation> negInsulation = new ArrayList<Insulation>();
        for (Insulation ins : this.insulation) {
            if (ins instanceof StaticInsulation) {
                StaticInsulation insul = (StaticInsulation)ins;
                double cold = insul.getCold();
                double hot = insul.getHeat();
                if (CSMath.sign(cold) == CSMath.sign(hot)) {
                    switch (CSMath.sign(cold)) {
                        case -1: {
                            negInsulation.add(ins);
                            break;
                        }
                        case 1: {
                            posInsulation.add(ins);
                        }
                    }
                    continue;
                }
                switch (CSMath.sign(cold)) {
                    case -1: {
                        negInsulation.add(new StaticInsulation(-cold, 0.0));
                        break;
                    }
                    case 1: {
                        posInsulation.add(new StaticInsulation(cold, 0.0));
                    }
                }
                switch (CSMath.sign(hot)) {
                    case -1: {
                        negInsulation.add(new StaticInsulation(0.0, hot));
                        break;
                    }
                    case 1: {
                        posInsulation.add(new StaticInsulation(0.0, hot));
                    }
                }
                continue;
            }
            if (!(ins instanceof AdaptiveInsulation)) continue;
            AdaptiveInsulation adaptive = (AdaptiveInsulation)ins;
            double value = adaptive.getInsulation();
            if (value < 0.0) {
                negInsulation.add(ins);
                continue;
            }
            posInsulation.add(ins);
        }
        poseStack.func_227860_a_();
        this.width = 0;
        if (!posInsulation.isEmpty()) {
            BarType barType = negInsulation.isEmpty() ? BarType.NONE : BarType.POSITIVE;
            this.width += ClientInsulationTooltip.renderBar(poseStack, x + this.width, y, posInsulation, this.slot, this.stack, barType);
        }
        if (!negInsulation.isEmpty()) {
            if (!posInsulation.isEmpty()) {
                this.width += 4;
            }
            this.width += ClientInsulationTooltip.renderBar(poseStack, x + this.width, y, negInsulation, this.slot, this.stack, BarType.NEGATIVE);
        }
        poseStack.func_227865_b_();
        if (this.strikethrough) {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)(x - 1), (int)(y + 2), (int)(x + 8), (int)(y + 3), (int)-642510);
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)x, (int)(y + 3), (int)(x + 9), (int)(y + 4), (int)-642510);
        }
    }

    static void renderCell(MatrixStack poseStack, int x, int y, Insulation insulation) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        double rounded = CSMath.roundNearest(Math.abs(insulation.getValue()), 0.25);
        int uvX = 0;
        if (insulation instanceof AdaptiveInsulation) {
            AdaptiveInsulation adaptive = (AdaptiveInsulation)insulation;
            uvX = !RECURSIVE ? 16 : (adaptive.getFactor() < 0.0 ? 10 : (adaptive.getFactor() == 0.0 ? 16 : 22));
        } else if (insulation instanceof StaticInsulation) {
            double heat;
            StaticInsulation stat = (StaticInsulation)insulation;
            double cold = Math.abs(stat.getCold());
            int n = cold > (heat = Math.abs(stat.getHeat())) ? 10 : (uvX = cold == heat ? 16 : 22);
        }
        int uvY = insulation instanceof AdaptiveInsulation ? (rounded >= 2.0 ? 16 : 20) : (rounded >= 2.0 ? 8 : 12);
        ClientInsulationTooltip.renderCellBackground(poseStack, x, y);
        ClientInsulationTooltip.MC.field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        Screen.func_238464_a_((MatrixStack)poseStack, (int)x, (int)y, (int)0, (float)uvX, (float)uvY, (int)6, (int)4, (int)28, (int)36);
        if (insulation instanceof AdaptiveInsulation && ((AdaptiveInsulation)insulation).getFactor() != 0.0 && !RECURSIVE) {
            AdaptiveInsulation adaptive = (AdaptiveInsulation)insulation;
            double blend = Math.abs(adaptive.getFactor());
            RenderSystem.enableBlend();
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)blend));
            RECURSIVE = true;
            ClientInsulationTooltip.renderCell(poseStack, x, y, insulation);
            RenderSystem.disableBlend();
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RECURSIVE = false;
    }

    static void renderCellBackground(MatrixStack poseStack, int x, int y) {
        ClientInsulationTooltip.MC.field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        Screen.func_238464_a_((MatrixStack)poseStack, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)6, (int)4, (int)28, (int)36);
    }

    static void renderIcon(MatrixStack poseStack, int x, int y, Insulation.Slot slot, BarType type) {
        ClientInsulationTooltip.MC.field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        switch (slot) {
            case ITEM: {
                Screen.func_238464_a_((MatrixStack)poseStack, (int)x, (int)y, (int)0, (float)28.0f, (float)0.0f, (int)8, (int)8, (int)28, (int)36);
                break;
            }
            case ARMOR: {
                Screen.func_238464_a_((MatrixStack)poseStack, (int)x, (int)y, (int)0, (float)28.0f, (float)8.0f, (int)8, (int)8, (int)28, (int)36);
                break;
            }
            case CURIO: {
                Screen.func_238464_a_((MatrixStack)poseStack, (int)x, (int)y, (int)0, (float)28.0f, (float)16.0f, (int)8, (int)8, (int)28, (int)36);
            }
        }
        switch (type) {
            case POSITIVE: {
                Screen.func_238464_a_((MatrixStack)poseStack, (int)(x + 3), (int)(y + 3), (int)0, (float)18.0f, (float)0.0f, (int)5, (int)5, (int)28, (int)36);
                break;
            }
            case NEGATIVE: {
                Screen.func_238464_a_((MatrixStack)poseStack, (int)(x + 3), (int)(y + 3), (int)0, (float)23.0f, (float)0.0f, (int)5, (int)5, (int)28, (int)36);
            }
        }
    }

    static int renderBar(MatrixStack poseStack, int x, int y, List<Insulation> insulations, Insulation.Slot slot, ItemStack stack, BarType type) {
        ClientInsulationTooltip.MC.field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        List<Insulation> sortedInsulation = Insulation.sort(insulations);
        ClientInsulationTooltip.setAdaptations(sortedInsulation, stack);
        Mode mode = sortedInsulation.stream().map(Insulation::split).mapToInt(List::size).sum() > 10 ? Mode.OVERFLOW : (insulations.stream().anyMatch(insul -> insul.split().size() > 1) ? Mode.COMPOUND : Mode.NORMAL);
        int armorSlots = slot == Insulation.Slot.ARMOR && type != BarType.NEGATIVE && ItemInsulationManager.isInsulatable(stack) ? ItemInsulationManager.getInsulationSlots(stack) : 0;
        int slots = Math.max(armorSlots, insulations.size());
        poseStack.func_227860_a_();
        int finalWidth = mode == Mode.OVERFLOW ? ClientInsulationTooltip.renderOverflowBar(poseStack, x + 8, y, sortedInsulation, slots) : (mode == Mode.COMPOUND ? ClientInsulationTooltip.renderCompoundBar(poseStack, x + 7, y, sortedInsulation, slots) : ClientInsulationTooltip.renderNormalBar(poseStack, x + 7, y, sortedInsulation, slots));
        poseStack.func_227865_b_();
        ClientInsulationTooltip.renderIcon(poseStack, x, y, slot, type);
        if (mode != Mode.OVERFLOW) {
            finalWidth += 2;
        }
        return finalWidth + 6;
    }

    static int renderNormalBar(MatrixStack poseStack, int x, int y, List<Insulation> insulations, int slots) {
        int i;
        for (i = 0; i < insulations.size(); ++i) {
            Insulation insulation = insulations.get(i);
            ClientInsulationTooltip.renderCell(poseStack, x + i * 6, y + 2, insulation);
        }
        for (i = insulations.size(); i < slots; ++i) {
            ClientInsulationTooltip.renderCellBackground(poseStack, x + i * 6, y + 2);
        }
        for (i = 0; i < slots; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(slots, i);
            if (segment == BorderSegment.SINGLE) {
                segment = BorderSegment.TAIL;
            }
            if (segment == BorderSegment.HEAD) {
                segment = BorderSegment.BODY;
            }
            ClientInsulationTooltip.renderCellBorder(poseStack, x + i * 6, y + 2, segment, BorderType.NORMAL);
        }
        return Math.max(insulations.size(), slots) * 6;
    }

    static int renderCompoundBar(MatrixStack poseStack, int x, int y, List<Insulation> insulations, int slots) {
        int cellX = 0;
        int compoundCount = 0;
        for (int i = 0; i < insulations.size(); ++i) {
            Insulation insulation = insulations.get(i);
            List<Insulation> subInsulations = Insulation.sort(insulation.split());
            if (subInsulations.size() > 1) {
                ++compoundCount;
                for (int j = 0; j < subInsulations.size(); ++j) {
                    Insulation subInsul = subInsulations.get(j);
                    BorderSegment segment = ClientInsulationTooltip.getBorderSegment(subInsulations.size(), j);
                    ClientInsulationTooltip.renderCell(poseStack, x + cellX, y + 2, subInsul);
                    ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, segment, BorderType.COMPOUND);
                    cellX += 6;
                }
                if (i >= slots - 1) continue;
                ++cellX;
                if (i < insulations.size() - 1 && insulations.get(i + 1).split().size() > 1) {
                    ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, BorderSegment.TAIL, BorderType.DIVIDER);
                }
                ++cellX;
                continue;
            }
            int normalCount = insulations.size() - compoundCount;
            ClientInsulationTooltip.renderCell(poseStack, x + cellX, y + 2, insulation);
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(normalCount, i - compoundCount);
            if (segment == BorderSegment.TAIL && i < slots - 1) {
                segment = BorderSegment.BODY;
            }
            BorderType borderType = segment == BorderSegment.TAIL ? BorderType.NORMAL : BorderType.SEGMENT;
            ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, segment, borderType);
            cellX += 6;
            if (i >= slots - 1) continue;
            ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, BorderSegment.BODY, BorderType.DIVIDER);
            ++cellX;
        }
        int emptySlots = slots - insulations.size();
        for (int i = 0; i < emptySlots; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(emptySlots, i);
            if (segment == BorderSegment.SINGLE) {
                segment = BorderSegment.TAIL;
            }
            BorderType borderType = segment == BorderSegment.TAIL ? BorderType.NORMAL : BorderType.SEGMENT;
            ClientInsulationTooltip.renderCellBackground(poseStack, x + cellX, y + 2);
            ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, segment, borderType);
            cellX += 6;
            if (i >= emptySlots - 1) continue;
            ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, BorderSegment.TAIL, BorderType.EMPTY_DIVIDER);
            ++cellX;
        }
        return cellX;
    }

    static int renderOverflowBar(MatrixStack poseStack, int x, int y, List<Insulation> insulations, int slots) {
        int width = 0;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        double cold = 0.0;
        double heat = 0.0;
        double neutral = 0.0;
        double adaptive = 0.0;
        for (Insulation insulation : insulations) {
            if (insulation instanceof StaticInsulation) {
                double thisHeat;
                StaticInsulation staticInsulation = (StaticInsulation)insulation;
                double thisCold = Math.abs(staticInsulation.getCold());
                if (thisCold == (thisHeat = Math.abs(staticInsulation.getHeat()))) {
                    neutral += thisCold;
                    continue;
                }
                cold += thisCold;
                heat += thisHeat;
                continue;
            }
            if (!(insulation instanceof AdaptiveInsulation)) continue;
            AdaptiveInsulation adaptiveInsulation = (AdaptiveInsulation)insulation;
            double thisAdaptive = Math.abs(adaptiveInsulation.getInsulation());
            adaptive += thisAdaptive;
        }
        int textColor = 0xA0A0A0;
        poseStack.func_227860_a_();
        if (insulations.size() < slots) {
            int xOffs = ClientInsulationTooltip.renderEmptyBar(poseStack, x, y + 2, slots - insulations.size());
            width += xOffs;
            poseStack.func_227861_a_((double)xOffs, 0.0, 0.0);
        }
        if (cold > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new StaticInsulation(cold, 0.0), textColor);
            width += xOffs;
            poseStack.func_227861_a_((double)xOffs, 0.0, 0.0);
        }
        if (heat > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new StaticInsulation(0.0, heat), textColor);
            width += xOffs;
            poseStack.func_227861_a_((double)xOffs, 0.0, 0.0);
        }
        if (neutral > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new StaticInsulation(neutral, neutral), textColor);
            width += xOffs;
            poseStack.func_227861_a_((double)xOffs, 0.0, 0.0);
        }
        if (adaptive > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new AdaptiveInsulation(adaptive, 0.0), textColor);
            width += xOffs;
            poseStack.func_227861_a_((double)xOffs, 0.0, 0.0);
        }
        poseStack.func_227865_b_();
        return width;
    }

    static int renderOverflowCell(MatrixStack poseStack, FontRenderer font, int x, int y, Insulation insulation, int textColor) {
        Number insul = CSMath.truncate(insulation.getValue() / 2.0, 2);
        if (CSMath.isInteger(insul)) {
            insul = ((Number)insul).intValue();
        }
        String text = "x" + insul;
        ClientInsulationTooltip.renderCell(poseStack, x, y, insulation);
        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.HEAD, BorderType.OVERFLOW);
        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.BODY, BorderType.OVERFLOW);
        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.TAIL, BorderType.OVERFLOW);
        Screen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)font, (String)text, (int)(x + 8), (int)(y - 2), (int)textColor);
        return 12 + font.func_78256_a(text);
    }

    static int renderEmptyBar(MatrixStack poseStack, int x, int y, int size) {
        ClientInsulationTooltip.MC.field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        for (int i = 0; i < size; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(size, i);
            Screen.func_238464_a_((MatrixStack)poseStack, (int)(x + 7 + i * 6), (int)(y + 1), (int)0, (float)0.0f, (float)0.0f, (int)6, (int)4, (int)28, (int)36);
            ClientInsulationTooltip.renderCellBorder(poseStack, x + i * 6, y, segment, BorderType.OVERFLOW);
        }
        poseStack.func_227860_a_();
        poseStack.func_227865_b_();
        return size * 6 + 4;
    }

    static void renderCellBorder(MatrixStack poseStack, int x, int y, BorderSegment segment, BorderType type) {
        ClientInsulationTooltip.MC.field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        switch (type) {
            case DIVIDER: {
                Screen.func_238464_a_((MatrixStack)poseStack, (int)x, (int)(y - 1), (int)0, (float)10.0f, (float)0.0f, (int)1, (int)6, (int)28, (int)36);
                break;
            }
            case EMPTY_DIVIDER: {
                Screen.func_238464_a_((MatrixStack)poseStack, (int)x, (int)(y - 1), (int)0, (float)11.0f, (float)0.0f, (int)1, (int)6, (int)28, (int)36);
                break;
            }
            default: {
                int vOffset;
                switch (type) {
                    case NORMAL: {
                        vOffset = 4;
                        break;
                    }
                    case OVERFLOW: {
                        vOffset = 10;
                        break;
                    }
                    case SEGMENT: {
                        vOffset = 16;
                        break;
                    }
                    case COMPOUND: {
                        vOffset = 22;
                        break;
                    }
                    default: {
                        vOffset = 0;
                    }
                }
                switch (segment) {
                    case SINGLE: {
                        if (RECURSIVE) break;
                        RECURSIVE = true;
                        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.HEAD, type);
                        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.TAIL, type);
                        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.BODY, type);
                        RECURSIVE = false;
                        break;
                    }
                    case HEAD: {
                        Screen.func_238464_a_((MatrixStack)poseStack, (int)(x - 1), (int)(y - 1), (int)0, (float)0.0f, (float)vOffset, (int)7, (int)6, (int)28, (int)36);
                        break;
                    }
                    case BODY: {
                        Screen.func_238464_a_((MatrixStack)poseStack, (int)(x + 0), (int)(y - 1), (int)0, (float)2.0f, (float)vOffset, (int)6, (int)6, (int)28, (int)36);
                        break;
                    }
                    case TAIL: {
                        Screen.func_238464_a_((MatrixStack)poseStack, (int)(x + 0), (int)(y - 1), (int)0, (float)3.0f, (float)vOffset, (int)7, (int)6, (int)28, (int)36);
                    }
                }
                break;
            }
        }
    }

    static BorderSegment getBorderSegment(int collectionSize, int index) {
        if (collectionSize == 1) {
            return BorderSegment.SINGLE;
        }
        if (index == collectionSize - 1) {
            return BorderSegment.TAIL;
        }
        if (index == 0) {
            return BorderSegment.HEAD;
        }
        return BorderSegment.BODY;
    }

    static void setAdaptations(List<Insulation> insulations, ItemStack stack) {
        for (int i = 0; i < insulations.size(); ++i) {
            Object insul = insulations.get(i).copy();
            if (insul instanceof AdaptiveInsulation) {
                AdaptiveInsulation.readFactorFromArmor((AdaptiveInsulation)insul, stack);
            }
            insulations.set(i, (Insulation)insul);
        }
    }

    static {
        INNER_BLIT.setAccessible(true);
        RECURSIVE = false;
    }

    private static enum BarType {
        POSITIVE,
        NEGATIVE,
        NONE;

    }

    private static enum BorderType {
        NORMAL,
        OVERFLOW,
        SEGMENT,
        COMPOUND,
        DIVIDER,
        EMPTY_DIVIDER;

    }

    private static enum BorderSegment {
        HEAD,
        BODY,
        TAIL,
        SINGLE;

    }

    private static enum Mode {
        NORMAL,
        COMPOUND,
        OVERFLOW;

    }
}

