/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.tooltip;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.client.gui.tooltip.Tooltip;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSoulspringTooltip
extends Tooltip {
    private static final ResourceLocation TOOLTIP = new ResourceLocation("cold_sweat:textures/gui/tooltip/soulspring_lamp_fuel.png");
    private static final ResourceLocation TOOLTIP_HC = new ResourceLocation("cold_sweat:textures/gui/tooltip/soulspring_lamp_fuel_hc.png");
    public static final Supplier<ResourceLocation> TOOLTIP_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? TOOLTIP_HC : TOOLTIP;
    double fuel;

    public ClientSoulspringTooltip(double fuel) {
        this.fuel = fuel;
    }

    @Override
    public int getHeight() {
        return TooltipHandler.isShiftDown() ? CSMath.ceil((double)ConfigSettings.SOULSPRING_LAMP_FUEL.get().size() / 6.0) * 16 + 14 : 12;
    }

    @Override
    public int getWidth(FontRenderer font) {
        return TooltipHandler.isShiftDown() ? Math.min(6, ConfigSettings.SOULSPRING_LAMP_FUEL.get().size()) * 16 : 32;
    }

    @Override
    public void renderImage(FontRenderer font, int x, int y, MatrixStack poseStack, ItemRenderer itemRenderer, int depth) {
        poseStack.func_227860_a_();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TOOLTIP_LOCATION.get());
        AbstractGui.func_238464_a_((MatrixStack)poseStack, (int)x, (int)(++y), (int)401, (float)0.0f, (float)0.0f, (int)30, (int)8, (int)34, (int)30);
        AbstractGui.func_238464_a_((MatrixStack)poseStack, (int)x, (int)y, (int)401, (float)0.0f, (float)16.0f, (int)((int)(this.fuel / 2.1333)), (int)8, (int)34, (int)30);
        if (TooltipHandler.isShiftDown()) {
            AbstractGui.func_238464_a_((MatrixStack)poseStack, (int)(x + 34), (int)y, (int)401, (float)0.0f, (float)24.0f, (int)16, (int)10, (int)34, (int)30);
            float oldBlitOffset = itemRenderer.field_77023_b;
            itemRenderer.field_77023_b = 300.0f;
            int i = 0;
            for (Item item : ConfigSettings.SOULSPRING_LAMP_FUEL.get().keySet()) {
                for (FuelData fuelData : ConfigSettings.SOULSPRING_LAMP_FUEL.get().get((Object)item)) {
                    CompoundNBT nbt = fuelData.item().flatMap(req -> req.nbt().tag(), CompoundNBT::func_197643_a).orElse(new CompoundNBT());
                    itemRenderer.func_175042_a(new ItemStack((IItemProvider)item, 1, nbt), x + i * 16 % 96, y + 12 + CSMath.floor((double)i / 6.0) * 16);
                    ++i;
                }
            }
            itemRenderer.field_77023_b = oldBlitOffset;
        }
        poseStack.func_227865_b_();
    }
}

